/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.resolving.processing.log;

import de.quantummaid.mapmaid.builder.resolving.requirements.DetectionRequirementReasons;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import de.quantummaid.mapmaid.shared.validators.NotNullValidator;
import lombok.Generated;

public final class LoggedState {
    private final TypeIdentifier type;
    private final Class<?> state;
    private final DetectionRequirementReasons detectionRequirementReasons;

    public static LoggedState loggedState(TypeIdentifier type, Class<?> state, DetectionRequirementReasons detectionRequirementReasons) {
        NotNullValidator.validateNotNull(type, "type");
        NotNullValidator.validateNotNull(state, "state");
        NotNullValidator.validateNotNull(detectionRequirementReasons, "detectionRequirementReasons");
        return new LoggedState(type, state, detectionRequirementReasons);
    }

    public String buildTypeDescription() {
        return this.type.description();
    }

    public String buildStateName() {
        return this.state.getSimpleName();
    }

    public String buildDetectionRequirementReasons() {
        return this.detectionRequirementReasons.summary();
    }

    String dump() {
        return String.format("%s: %s (%s)", this.type.simpleDescription(), this.state, this.detectionRequirementReasons.summary());
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LoggedState)) {
            return false;
        }
        LoggedState other = (LoggedState)o;
        TypeIdentifier this$type = this.type;
        TypeIdentifier other$type = other.type;
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Class<?> this$state = this.state;
        Class<?> other$state = other.state;
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        DetectionRequirementReasons this$detectionRequirementReasons = this.detectionRequirementReasons;
        DetectionRequirementReasons other$detectionRequirementReasons = other.detectionRequirementReasons;
        return !(this$detectionRequirementReasons == null ? other$detectionRequirementReasons != null : !((Object)this$detectionRequirementReasons).equals(other$detectionRequirementReasons));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TypeIdentifier $type = this.type;
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Class<?> $state = this.state;
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        DetectionRequirementReasons $detectionRequirementReasons = this.detectionRequirementReasons;
        result = result * 59 + ($detectionRequirementReasons == null ? 43 : ((Object)$detectionRequirementReasons).hashCode());
        return result;
    }

    @Generated
    private LoggedState(TypeIdentifier type, Class<?> state, DetectionRequirementReasons detectionRequirementReasons) {
        this.type = type;
        this.state = state;
        this.detectionRequirementReasons = detectionRequirementReasons;
    }
}

