/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.resolving.states.detected;

import de.quantummaid.mapmaid.builder.resolving.Context;
import de.quantummaid.mapmaid.builder.resolving.Report;
import de.quantummaid.mapmaid.builder.resolving.processing.CollectionResult;
import de.quantummaid.mapmaid.builder.resolving.requirements.DetectionRequirements;
import de.quantummaid.mapmaid.builder.resolving.requirements.RequirementsReducer;
import de.quantummaid.mapmaid.builder.resolving.states.StatefulDefinition;
import de.quantummaid.mapmaid.builder.resolving.states.detected.ToBeDetected;
import de.quantummaid.mapmaid.builder.resolving.states.detected.Unreasoned;
import de.quantummaid.mapmaid.debug.Lingo;
import de.quantummaid.mapmaid.debug.RequiredAction;
import de.quantummaid.mapmaid.debug.ScanInformationBuilder;
import java.util.Optional;
import lombok.Generated;

public final class Undetectable
extends StatefulDefinition {
    private final String reason;

    private Undetectable(Context context, String reason) {
        super(context);
        this.reason = reason;
    }

    public static StatefulDefinition undetectable(Context context, String reason) {
        return new Undetectable(context, reason);
    }

    @Override
    public StatefulDefinition changeRequirements(RequirementsReducer reducer) {
        RequiredAction requiredAction = this.context.scanInformationBuilder().changeRequirements(reducer);
        return requiredAction.map(() -> this, () -> ToBeDetected.toBeDetected(this.context), () -> Unreasoned.unreasoned(this.context));
    }

    @Override
    public Optional<Report> getDefinition() {
        ScanInformationBuilder scanInformationBuilder = this.context.scanInformationBuilder();
        CollectionResult collectionResult = CollectionResult.collectionResult(null, scanInformationBuilder);
        DetectionRequirements detectionRequirements = this.context.scanInformationBuilder().detectionRequirements();
        String mode = Lingo.mode(detectionRequirements.serialization, detectionRequirements.deserialization);
        return Optional.of(Report.failure(collectionResult, String.format("unable to detect %s:%n%s", mode, this.reason)));
    }

    @Generated
    public String toString() {
        return "Undetectable(reason=" + this.reason + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Undetectable)) {
            return false;
        }
        Undetectable other = (Undetectable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$reason = this.reason;
        String other$reason = other.reason;
        return !(this$reason == null ? other$reason != null : !this$reason.equals(other$reason));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Undetectable;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $reason = this.reason;
        result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
        return result;
    }
}

