/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.debug;

import de.quantummaid.mapmaid.builder.resolving.processing.log.StateLog;
import de.quantummaid.mapmaid.debug.ScanInformationBuilder;
import de.quantummaid.mapmaid.debug.SubReasonProvider;
import de.quantummaid.mapmaid.debug.scaninformation.NeverScannedScanInformation;
import de.quantummaid.mapmaid.debug.scaninformation.ScanInformation;
import de.quantummaid.mapmaid.shared.identifier.RealTypeIdentifier;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import de.quantummaid.reflectmaid.ResolvedType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

public final class DebugInformation {
    private final Map<TypeIdentifier, ScanInformation> scanInformations;
    private final StateLog stateLog;

    public static DebugInformation debugInformation(Map<TypeIdentifier, ScanInformationBuilder> scanInformationBuilders, StateLog stateLog) {
        HashMap<TypeIdentifier, ScanInformation> scanInformations = new HashMap<TypeIdentifier, ScanInformation>(scanInformationBuilders.size());
        SubReasonProvider serializationSubReasonProvider = typeIdentifier -> ((ScanInformation)scanInformations.get(typeIdentifier)).reasonsForSerialization();
        SubReasonProvider deserializationSubReasonProvider = typeIdentifier -> ((ScanInformation)scanInformations.get(typeIdentifier)).reasonsForDeserialization();
        scanInformationBuilders.forEach((typeIdentifier, scanInformationBuilder) -> {
            ScanInformation scanInformation = scanInformationBuilder.build(serializationSubReasonProvider, deserializationSubReasonProvider);
            scanInformations.put((TypeIdentifier)typeIdentifier, scanInformation);
        });
        return new DebugInformation(scanInformations, stateLog);
    }

    public ScanInformation scanInformationFor(Class<?> type) {
        return this.scanInformationFor(ResolvedType.resolvedType(type));
    }

    public ScanInformation scanInformationFor(ResolvedType type) {
        return this.scanInformationFor(RealTypeIdentifier.realTypeIdentifier(type));
    }

    public ScanInformation scanInformationFor(TypeIdentifier type) {
        return this.optionalScanInformationFor(type).orElseGet(() -> NeverScannedScanInformation.neverScanned(type));
    }

    public Optional<ScanInformation> optionalScanInformationFor(Class<?> type) {
        return this.optionalScanInformationFor(ResolvedType.resolvedType(type));
    }

    public Optional<ScanInformation> optionalScanInformationFor(ResolvedType type) {
        return this.optionalScanInformationFor(RealTypeIdentifier.realTypeIdentifier(type));
    }

    public Optional<ScanInformation> optionalScanInformationFor(TypeIdentifier type) {
        if (!this.scanInformations.containsKey(type)) {
            return Optional.empty();
        }
        return Optional.of(this.scanInformations.get(type));
    }

    public List<ScanInformation> allScanInformations() {
        return new ArrayList<ScanInformation>(this.scanInformations.values());
    }

    public StateLog stateLog() {
        return this.stateLog;
    }

    public String dumpAll() {
        return this.allScanInformations().stream().map(ScanInformation::render).collect(Collectors.joining("\n\n\n"));
    }

    @Generated
    public String toString() {
        return "DebugInformation(scanInformations=" + this.scanInformations + ", stateLog=" + this.stateLog + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DebugInformation)) {
            return false;
        }
        DebugInformation other = (DebugInformation)o;
        Map<TypeIdentifier, ScanInformation> this$scanInformations = this.scanInformations;
        Map<TypeIdentifier, ScanInformation> other$scanInformations = other.scanInformations;
        if (this$scanInformations == null ? other$scanInformations != null : !((Object)this$scanInformations).equals(other$scanInformations)) {
            return false;
        }
        StateLog this$stateLog = this.stateLog;
        StateLog other$stateLog = other.stateLog;
        return !(this$stateLog == null ? other$stateLog != null : !this$stateLog.equals(other$stateLog));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<TypeIdentifier, ScanInformation> $scanInformations = this.scanInformations;
        result = result * 59 + ($scanInformations == null ? 43 : ((Object)$scanInformations).hashCode());
        StateLog $stateLog = this.stateLog;
        result = result * 59 + ($stateLog == null ? 43 : $stateLog.hashCode());
        return result;
    }

    @Generated
    private DebugInformation(Map<TypeIdentifier, ScanInformation> scanInformations, StateLog stateLog) {
        this.scanInformations = scanInformations;
        this.stateLog = stateLog;
    }
}

