/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.mapper.deserialization;

import de.quantummaid.mapmaid.mapper.deserialization.InternalUnmarshallingException;
import de.quantummaid.mapmaid.mapper.marshalling.MarshallingType;
import de.quantummaid.mapmaid.mapper.marshalling.Unmarshaller;
import de.quantummaid.mapmaid.mapper.marshalling.registry.UnmarshallerRegistry;
import de.quantummaid.mapmaid.mapper.universal.Universal;
import de.quantummaid.mapmaid.shared.validators.NotNullValidator;
import java.util.Set;
import lombok.Generated;

final class Unmarshallers {
    private final UnmarshallerRegistry unmarshallers;

    static Unmarshallers unmarshallers(UnmarshallerRegistry unmarshallers) {
        NotNullValidator.validateNotNull(unmarshallers, "unmarshallers");
        return new Unmarshallers(unmarshallers);
    }

    <M> Universal unmarshall(M input, MarshallingType<M> marshallingType) {
        NotNullValidator.validateNotNull(input, "input");
        Unmarshaller<M> unmarshaller = this.unmarshallers.getForType(marshallingType);
        try {
            Object unmarshalled = unmarshaller.unmarshal(input);
            return Universal.fromNativeJava(unmarshalled);
        }
        catch (Exception e) {
            throw InternalUnmarshallingException.internalUnmarshallingException(input, e);
        }
    }

    Set<MarshallingType<?>> supportedMarshallingTypes() {
        return this.unmarshallers.supportedTypes();
    }

    @Generated
    public String toString() {
        return "Unmarshallers(unmarshallers=" + this.unmarshallers + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Unmarshallers)) {
            return false;
        }
        Unmarshallers other = (Unmarshallers)o;
        UnmarshallerRegistry this$unmarshallers = this.unmarshallers;
        UnmarshallerRegistry other$unmarshallers = other.unmarshallers;
        return !(this$unmarshallers == null ? other$unmarshallers != null : !this$unmarshallers.equals(other$unmarshallers));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UnmarshallerRegistry $unmarshallers = this.unmarshallers;
        result = result * 59 + ($unmarshallers == null ? 43 : $unmarshallers.hashCode());
        return result;
    }

    @Generated
    private Unmarshallers(UnmarshallerRegistry unmarshallers) {
        this.unmarshallers = unmarshallers;
    }
}

