/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.mapper.deserialization;

import de.quantummaid.mapmaid.debug.MapMaidException;
import de.quantummaid.mapmaid.debug.scaninformation.ScanInformation;
import de.quantummaid.mapmaid.mapper.deserialization.validation.ExceptionTracker;
import de.quantummaid.mapmaid.mapper.universal.Universal;
import de.quantummaid.mapmaid.shared.validators.NotNullValidator;

public final class WrongInputStructureException
extends MapMaidException {
    private final transient Object inputObject;

    public WrongInputStructureException(String message, Object inputObject) {
        super(message, null);
        this.inputObject = inputObject;
    }

    public static WrongInputStructureException wrongInputStructureException(Class<? extends Universal> expected, Universal actual, ExceptionTracker exceptionTracker, ScanInformation scanInformation) {
        NotNullValidator.validateNotNull(expected, "expected");
        NotNullValidator.validateNotNull(actual, "actual");
        NotNullValidator.validateNotNull(exceptionTracker, "exceptionTracker");
        String position = exceptionTracker.getPosition();
        Object location = position.isEmpty() ? "" : " for field '" + position + "'";
        String message = "Requiring the input to be an '" + Universal.describe(expected) + "'" + (String)location + "\n\n" + scanInformation.render();
        return new WrongInputStructureException(message, actual.toNativeJava());
    }

    public Object inputObject() {
        return this.inputObject;
    }
}

