/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.mapper.marshalling.registry;

import de.quantummaid.mapmaid.mapper.marshalling.MarshallingType;
import de.quantummaid.mapmaid.mapper.marshalling.UnsupportedMarshallingTypeException;
import de.quantummaid.mapmaid.shared.validators.NotNullValidator;
import java.util.Map;
import java.util.Set;
import lombok.Generated;

final class Registry<T> {
    private final Map<MarshallingType<?>, T> map;

    static <T> Registry<T> registry(Map<MarshallingType<?>, T> map) {
        NotNullValidator.validateNotNull(map, "map");
        return new Registry<T>(map);
    }

    T getForType(MarshallingType<?> type) {
        NotNullValidator.validateNotNull(type, "type");
        T entry = this.map.get(type);
        if (entry == null) {
            throw UnsupportedMarshallingTypeException.unsupportedMarshallingTypeException(type, this.map.keySet());
        }
        return entry;
    }

    Set<MarshallingType<?>> supportedTypes() {
        return this.map.keySet();
    }

    @Generated
    private Registry(Map<MarshallingType<?>, T> map) {
        this.map = map;
    }
}

