/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.mapper.serialization;

import de.quantummaid.mapmaid.debug.DebugInformation;
import de.quantummaid.mapmaid.debug.MapMaidException;
import de.quantummaid.mapmaid.debug.scaninformation.ScanInformation;
import de.quantummaid.mapmaid.mapper.definitions.Definition;
import de.quantummaid.mapmaid.mapper.definitions.Definitions;
import de.quantummaid.mapmaid.mapper.marshalling.Marshaller;
import de.quantummaid.mapmaid.mapper.marshalling.MarshallingType;
import de.quantummaid.mapmaid.mapper.marshalling.registry.MarshallerRegistry;
import de.quantummaid.mapmaid.mapper.serialization.SerializationCallback;
import de.quantummaid.mapmaid.mapper.serialization.UnexpectedExceptionThrownDuringMarshallingException;
import de.quantummaid.mapmaid.mapper.serialization.serializers.TypeSerializer;
import de.quantummaid.mapmaid.mapper.serialization.tracker.SerializationTracker;
import de.quantummaid.mapmaid.mapper.universal.Universal;
import de.quantummaid.mapmaid.mapper.universal.UniversalNull;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import de.quantummaid.mapmaid.shared.mapping.CustomPrimitiveMappings;
import de.quantummaid.mapmaid.shared.validators.NotNullValidator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.UnaryOperator;
import lombok.Generated;

public final class Serializer
implements SerializationCallback {
    private final MarshallerRegistry marshallers;
    private final Definitions definitions;
    private final CustomPrimitiveMappings customPrimitiveMappings;
    private final DebugInformation debugInformation;

    public static Serializer serializer(MarshallerRegistry marshallers, Definitions definitions, CustomPrimitiveMappings customPrimitiveMappings, DebugInformation debugInformation) {
        return new Serializer(marshallers, definitions, customPrimitiveMappings, debugInformation);
    }

    public Set<MarshallingType<?>> supportedMarshallingTypes() {
        return this.marshallers.supportedTypes();
    }

    public <T> T serialize(Object object, TypeIdentifier type, MarshallingType<T> marshallingType, UnaryOperator<Map<String, Object>> serializedPropertyInjector) {
        NotNullValidator.validateNotNull(object, "object");
        Object normalized = this.normalize(object, type);
        if (normalized instanceof Map) {
            normalized = serializedPropertyInjector.apply((Map)normalized);
        }
        Marshaller<T> marshaller = this.marshallers.getForType(marshallingType);
        try {
            return marshaller.marshal(normalized);
        }
        catch (Exception e) {
            throw UnexpectedExceptionThrownDuringMarshallingException.fromException(e, object);
        }
    }

    public <T> T marshalFromUniversalObject(Object object, MarshallingType<T> marshallingType) {
        Marshaller<T> marshaller = this.marshallers.getForType(marshallingType);
        try {
            return marshaller.marshal(object);
        }
        catch (Exception e) {
            throw UnexpectedExceptionThrownDuringMarshallingException.fromException(e, object);
        }
    }

    public Object serializeToUniversalObject(Object object, TypeIdentifier type) {
        if (Objects.isNull(object)) {
            return new HashMap(0);
        }
        return this.normalize(object, type);
    }

    private Object normalize(Object object, TypeIdentifier type) {
        if (Objects.isNull(object)) {
            return null;
        }
        return this.serializeDefinition(type, object, SerializationTracker.serializationTracker()).toNativeJava();
    }

    @Override
    public Universal serializeDefinition(TypeIdentifier type, Object object, SerializationTracker tracker) {
        if (Objects.isNull(object)) {
            return UniversalNull.universalNull();
        }
        SerializationTracker childTracker = tracker.trackToProhibitCyclicReferences(object);
        Definition definition = this.definitions.getDefinitionForType(type);
        return definition.serializer().orElseThrow(() -> {
            ScanInformation scanInformation = this.debugInformation.scanInformationFor(type);
            return MapMaidException.mapMaidException(String.format("No serializer configured for type '%s'", definition.type().description()), scanInformation);
        }).serialize(object, this, childTracker, this.customPrimitiveMappings, this.debugInformation);
    }

    public Definitions getDefinitions() {
        return this.definitions;
    }

    public Universal schema(TypeIdentifier typeIdentifier) {
        NotNullValidator.validateNotNull(typeIdentifier, "typeIdentifier");
        Definition definition = this.definitions.getDefinitionForType(typeIdentifier);
        TypeSerializer serializer = definition.serializer().orElseThrow();
        return serializer.schema(this::schema);
    }

    @Generated
    public String toString() {
        return "Serializer(marshallers=" + this.marshallers + ", definitions=" + this.getDefinitions() + ", customPrimitiveMappings=" + this.customPrimitiveMappings + ", debugInformation=" + this.debugInformation + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Serializer)) {
            return false;
        }
        Serializer other = (Serializer)o;
        MarshallerRegistry this$marshallers = this.marshallers;
        MarshallerRegistry other$marshallers = other.marshallers;
        if (this$marshallers == null ? other$marshallers != null : !this$marshallers.equals(other$marshallers)) {
            return false;
        }
        Definitions this$definitions = this.getDefinitions();
        Definitions other$definitions = other.getDefinitions();
        if (this$definitions == null ? other$definitions != null : !((Object)this$definitions).equals(other$definitions)) {
            return false;
        }
        CustomPrimitiveMappings this$customPrimitiveMappings = this.customPrimitiveMappings;
        CustomPrimitiveMappings other$customPrimitiveMappings = other.customPrimitiveMappings;
        if (this$customPrimitiveMappings == null ? other$customPrimitiveMappings != null : !((Object)this$customPrimitiveMappings).equals(other$customPrimitiveMappings)) {
            return false;
        }
        DebugInformation this$debugInformation = this.debugInformation;
        DebugInformation other$debugInformation = other.debugInformation;
        return !(this$debugInformation == null ? other$debugInformation != null : !((Object)this$debugInformation).equals(other$debugInformation));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MarshallerRegistry $marshallers = this.marshallers;
        result = result * 59 + ($marshallers == null ? 43 : $marshallers.hashCode());
        Definitions $definitions = this.getDefinitions();
        result = result * 59 + ($definitions == null ? 43 : ((Object)$definitions).hashCode());
        CustomPrimitiveMappings $customPrimitiveMappings = this.customPrimitiveMappings;
        result = result * 59 + ($customPrimitiveMappings == null ? 43 : ((Object)$customPrimitiveMappings).hashCode());
        DebugInformation $debugInformation = this.debugInformation;
        result = result * 59 + ($debugInformation == null ? 43 : ((Object)$debugInformation).hashCode());
        return result;
    }

    @Generated
    private Serializer(MarshallerRegistry marshallers, Definitions definitions, CustomPrimitiveMappings customPrimitiveMappings, DebugInformation debugInformation) {
        this.marshallers = marshallers;
        this.definitions = definitions;
        this.customPrimitiveMappings = customPrimitiveMappings;
        this.debugInformation = debugInformation;
    }
}

