/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.mapper.serialization.serializers.serializedobject;

import de.quantummaid.mapmaid.mapper.serialization.serializers.serializedobject.queries.PublicFieldQuery;
import de.quantummaid.mapmaid.mapper.serialization.serializers.serializedobject.queries.SerializationFieldQuery;
import de.quantummaid.mapmaid.shared.identifier.RealTypeIdentifier;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import de.quantummaid.mapmaid.shared.validators.NotNullValidator;
import de.quantummaid.reflectmaid.ResolvedType;
import de.quantummaid.reflectmaid.resolver.ResolvedField;
import lombok.Generated;

public final class SerializationField {
    private final ResolvedType type;
    private final String name;
    private final SerializationFieldQuery query;

    public static SerializationField serializationField(ResolvedType type, String name, SerializationFieldQuery query) {
        NotNullValidator.validateNotNull(type, "type");
        NotNullValidator.validateNotNull(name, "name");
        NotNullValidator.validateNotNull(query, "query");
        return new SerializationField(type, name, query);
    }

    public static SerializationField fromField(ResolvedType declaringType, ResolvedField field) {
        NotNullValidator.validateNotNull(declaringType, "declaringType");
        NotNullValidator.validateNotNull(field, "field");
        ResolvedType fullType = field.type();
        String name = field.name();
        SerializationFieldQuery query = PublicFieldQuery.publicFieldQuery(field);
        return SerializationField.serializationField(fullType, name, query);
    }

    public TypeIdentifier type() {
        return RealTypeIdentifier.realTypeIdentifier(this.type);
    }

    public String name() {
        return this.name;
    }

    public Object query(Object object) {
        NotNullValidator.validateNotNull(object, "object");
        return this.query.query(object);
    }

    public SerializationFieldQuery getQuery() {
        return this.query;
    }

    public String describe() {
        return String.format("%s [%s] via %s", this.name, this.type.simpleDescription(), this.query.describe());
    }

    @Generated
    public String toString() {
        return "SerializationField(type=" + this.type + ", name=" + this.name + ", query=" + this.getQuery() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SerializationField)) {
            return false;
        }
        SerializationField other = (SerializationField)o;
        ResolvedType this$type = this.type;
        ResolvedType other$type = other.type;
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$name = this.name;
        String other$name = other.name;
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        SerializationFieldQuery this$query = this.getQuery();
        SerializationFieldQuery other$query = other.getQuery();
        return !(this$query == null ? other$query != null : !this$query.equals(other$query));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResolvedType $type = this.type;
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        SerializationFieldQuery $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        return result;
    }

    @Generated
    private SerializationField(ResolvedType type, String name, SerializationFieldQuery query) {
        this.type = type;
        this.name = name;
        this.query = query;
    }
}

