/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.polymorphy;

import de.quantummaid.mapmaid.builder.customtypes.CustomType;
import de.quantummaid.mapmaid.collections.BiMap;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.TypeDeserializer;
import de.quantummaid.mapmaid.mapper.serialization.serializers.TypeSerializer;
import de.quantummaid.mapmaid.polymorphy.PolymorphicDeserializer;
import de.quantummaid.mapmaid.polymorphy.PolymorphicSerializer;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.reflect.KClass;
import lombok.Generated;

public final class PolymorphicCustomType<T>
implements CustomType<T> {
    private static final String DEFAULT_TYPE_FIELD = "type";
    private final TypeIdentifier typeIdentifier;
    private final BiMap<String, TypeIdentifier> nameToType;
    private final String typeField;

    public static <T> PolymorphicCustomType<T> fromKotlinSealedClass(KClass<T> kotlinClass) {
        Class javaClass = JvmClassMappingKt.getJavaClass(kotlinClass);
        TypeIdentifier typeIdentifier = TypeIdentifier.typeIdentifierFor(javaClass);
        List<TypeIdentifier> implementations = kotlinClass.getSealedSubclasses().stream().map(JvmClassMappingKt::getJavaClass).map(TypeIdentifier::typeIdentifierFor).collect(Collectors.toList());
        return PolymorphicCustomType.polymorphicCustomType(typeIdentifier, implementations, TypeIdentifier::description, DEFAULT_TYPE_FIELD);
    }

    public static <T> PolymorphicCustomType<T> polymorphicCustomType(TypeIdentifier typeIdentifier, List<TypeIdentifier> implementations, Function<TypeIdentifier, String> nameExtractor, String typeField) {
        Map<String, TypeIdentifier> nameToTypeMap = implementations.stream().collect(Collectors.toMap(nameExtractor, type -> type));
        return PolymorphicCustomType.polymorphicCustomType(typeIdentifier, BiMap.biMap(nameToTypeMap), typeField);
    }

    public static <T> PolymorphicCustomType<T> polymorphicCustomType(TypeIdentifier typeIdentifier, BiMap<String, TypeIdentifier> nameToType, String typeField) {
        return new PolymorphicCustomType<T>(typeIdentifier, nameToType, typeField);
    }

    @Override
    public TypeIdentifier type() {
        return this.typeIdentifier;
    }

    @Override
    public Optional<TypeDeserializer> deserializer() {
        PolymorphicDeserializer deserializer = PolymorphicDeserializer.polymorphicDeserializer(this.typeIdentifier, this.nameToType, this.typeField);
        return Optional.of(deserializer);
    }

    @Override
    public Optional<TypeSerializer> serializer() {
        PolymorphicSerializer serializer = PolymorphicSerializer.polymorphicSerializer(this.typeIdentifier, this.nameToType, this.typeField);
        return Optional.of(serializer);
    }

    @Generated
    public String toString() {
        return "PolymorphicCustomType(typeIdentifier=" + this.typeIdentifier + ", nameToType=" + this.nameToType + ", typeField=" + this.typeField + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PolymorphicCustomType)) {
            return false;
        }
        PolymorphicCustomType other = (PolymorphicCustomType)o;
        TypeIdentifier this$typeIdentifier = this.typeIdentifier;
        TypeIdentifier other$typeIdentifier = other.typeIdentifier;
        if (this$typeIdentifier == null ? other$typeIdentifier != null : !this$typeIdentifier.equals(other$typeIdentifier)) {
            return false;
        }
        BiMap<String, TypeIdentifier> this$nameToType = this.nameToType;
        BiMap<String, TypeIdentifier> other$nameToType = other.nameToType;
        if (this$nameToType == null ? other$nameToType != null : !((Object)this$nameToType).equals(other$nameToType)) {
            return false;
        }
        String this$typeField = this.typeField;
        String other$typeField = other.typeField;
        return !(this$typeField == null ? other$typeField != null : !this$typeField.equals(other$typeField));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TypeIdentifier $typeIdentifier = this.typeIdentifier;
        result = result * 59 + ($typeIdentifier == null ? 43 : $typeIdentifier.hashCode());
        BiMap<String, TypeIdentifier> $nameToType = this.nameToType;
        result = result * 59 + ($nameToType == null ? 43 : ((Object)$nameToType).hashCode());
        String $typeField = this.typeField;
        result = result * 59 + ($typeField == null ? 43 : $typeField.hashCode());
        return result;
    }

    @Generated
    private PolymorphicCustomType(TypeIdentifier typeIdentifier, BiMap<String, TypeIdentifier> nameToType, String typeField) {
        this.typeIdentifier = typeIdentifier;
        this.nameToType = nameToType;
        this.typeField = typeField;
    }
}

