/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.polymorphy;

import de.quantummaid.mapmaid.collections.BiMap;
import de.quantummaid.mapmaid.debug.DebugInformation;
import de.quantummaid.mapmaid.debug.scaninformation.ScanInformation;
import de.quantummaid.mapmaid.mapper.deserialization.DeserializerCallback;
import de.quantummaid.mapmaid.mapper.deserialization.WrongInputStructureException;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.TypeDeserializer;
import de.quantummaid.mapmaid.mapper.deserialization.validation.ExceptionTracker;
import de.quantummaid.mapmaid.mapper.injector.Injector;
import de.quantummaid.mapmaid.mapper.schema.SchemaCallback;
import de.quantummaid.mapmaid.mapper.schema.SchemaSupport;
import de.quantummaid.mapmaid.mapper.universal.Universal;
import de.quantummaid.mapmaid.mapper.universal.UniversalObject;
import de.quantummaid.mapmaid.polymorphy.MissingPolymorphicTypeFieldException;
import de.quantummaid.mapmaid.polymorphy.UnknownPolymorphicSubtypeException;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import de.quantummaid.mapmaid.shared.mapping.CustomPrimitiveMappings;
import java.util.List;
import lombok.Generated;

public final class PolymorphicDeserializer
implements TypeDeserializer {
    private final TypeIdentifier typeIdentifier;
    private final BiMap<String, TypeIdentifier> nameToType;
    private final String typeField;

    public static PolymorphicDeserializer polymorphicDeserializer(TypeIdentifier typeIdentifier, BiMap<String, TypeIdentifier> nameToType, String typeField) {
        return new PolymorphicDeserializer(typeIdentifier, nameToType, typeField);
    }

    @Override
    public List<TypeIdentifier> requiredTypes() {
        return this.nameToType.values();
    }

    @Override
    public <T> T deserialize(Universal input, ExceptionTracker exceptionTracker, Injector injector, DeserializerCallback callback, CustomPrimitiveMappings customPrimitiveMappings, TypeIdentifier typeIdentifier, DebugInformation debugInformation) {
        UniversalObject universalObject = this.asUniversalObject(input, exceptionTracker, debugInformation);
        Universal typeAsUniversal = universalObject.getField(this.typeField).orElseThrow(() -> {
            ScanInformation scanInformation = debugInformation.scanInformationFor(typeIdentifier);
            return MissingPolymorphicTypeFieldException.missingPolymorphicTypeFieldException(input, typeIdentifier, this.typeField, scanInformation);
        });
        String type = (String)typeAsUniversal.toNativeJava();
        TypeIdentifier implementation = this.nameToType.lookup(type).orElseThrow(() -> {
            ScanInformation scanInformation = debugInformation.scanInformationFor(typeIdentifier);
            throw UnknownPolymorphicSubtypeException.unknownPolymorphicSubtypeException(input, typeIdentifier, type, this.nameToType.keys(), scanInformation);
        });
        return (T)callback.deserializeRecursive(input, implementation, exceptionTracker, injector, debugInformation);
    }

    private UniversalObject asUniversalObject(Universal input, ExceptionTracker exceptionTracker, DebugInformation debugInformation) {
        if (input instanceof UniversalObject) {
            return (UniversalObject)input;
        }
        ScanInformation scanInformation = debugInformation.scanInformationFor(this.typeIdentifier);
        throw WrongInputStructureException.wrongInputStructureException(UniversalObject.class, input, exceptionTracker, scanInformation);
    }

    @Override
    public boolean forcesDependenciesToBeObjects() {
        return true;
    }

    @Override
    public String description() {
        return String.format("polymorphic deserializer for %s", this.typeIdentifier.description());
    }

    @Override
    public Universal schema(SchemaCallback schemaCallback) {
        return SchemaSupport.schemaForPolymorphicParent(this.nameToType, this.typeField, schemaCallback);
    }

    @Generated
    private PolymorphicDeserializer(TypeIdentifier typeIdentifier, BiMap<String, TypeIdentifier> nameToType, String typeField) {
        this.typeIdentifier = typeIdentifier;
        this.nameToType = nameToType;
        this.typeField = typeField;
    }
}

