/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.shared.mapping;

import de.quantummaid.mapmaid.mapper.universal.UniversalBoolean;
import de.quantummaid.mapmaid.mapper.universal.UniversalDouble;
import de.quantummaid.mapmaid.mapper.universal.UniversalLong;
import de.quantummaid.mapmaid.mapper.universal.UniversalPrimitive;
import de.quantummaid.mapmaid.mapper.universal.UniversalString;
import de.quantummaid.mapmaid.shared.mapping.Mapping;
import de.quantummaid.mapmaid.shared.mapping.TypeMappings;
import de.quantummaid.mapmaid.shared.mapping.UniversalTypeMapper;
import de.quantummaid.mapmaid.shared.validators.NotNullValidator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;

public final class CustomPrimitiveMappings {
    private final Map<Class<?>, UniversalTypeMapper> mappings;
    private final TypeMappings typeMappings = TypeMappings.typeMappings(Mapping.mapping(UniversalDouble.class, UniversalDouble.class, Function.identity()), Mapping.mapping(UniversalDouble.class, UniversalLong.class, UniversalLong::universalLongFromUniversalDouble), Mapping.mapping(UniversalDouble.class, UniversalString.class, UniversalString::universalStringFromUniversalDouble), Mapping.mapping(UniversalLong.class, UniversalLong.class, Function.identity()), Mapping.mapping(UniversalLong.class, UniversalDouble.class, UniversalDouble::universalDoubleFromUniversalLong), Mapping.mapping(UniversalLong.class, UniversalString.class, UniversalString::universalStringFromUniversalLong), Mapping.mapping(UniversalString.class, UniversalString.class, Function.identity()), Mapping.mapping(UniversalString.class, UniversalDouble.class, UniversalDouble::universalDoubleFromUniversalString), Mapping.mapping(UniversalString.class, UniversalLong.class, UniversalLong::universalLongFromUniversalString), Mapping.mapping(UniversalString.class, UniversalBoolean.class, UniversalBoolean::universalBooleanFromUniversalString), Mapping.mapping(UniversalBoolean.class, UniversalBoolean.class, Function.identity()), Mapping.mapping(UniversalBoolean.class, UniversalString.class, UniversalString::universalStringFromUniversalBoolean));

    public static CustomPrimitiveMappings customPrimitiveMappings(UniversalTypeMapper ... mappings) {
        NotNullValidator.validateNotNull(mappings, "mappings");
        Map<Class<?>, UniversalTypeMapper> map = Arrays.stream(mappings).collect(Collectors.toMap(UniversalTypeMapper::normalType, Function.identity()));
        return new CustomPrimitiveMappings(map);
    }

    public boolean isPrimitiveType(Class<?> type) {
        NotNullValidator.validateNotNull(type, "type");
        return this.mappings.containsKey(type);
    }

    public UniversalPrimitive toUniversal(Object object) {
        NotNullValidator.validateNotNull(object, "object");
        if (!this.mappings.containsKey(object.getClass())) {
            throw new UnsupportedOperationException(String.format("Type '%s' is not registered as a primitive", object.getClass()));
        }
        UniversalTypeMapper universalTypeMapper = this.mappings.get(object.getClass());
        return universalTypeMapper.toUniversal(object);
    }

    public Object fromUniversal(UniversalPrimitive universal, Class<?> type) {
        NotNullValidator.validateNotNull(universal, "universal");
        NotNullValidator.validateNotNull(type, "type");
        if (!this.mappings.containsKey(type)) {
            throw new UnsupportedOperationException(String.format("Type '%s' is not registered as a primitive", type));
        }
        UniversalTypeMapper universalTypeMapper = this.mappings.get(type);
        Class<? extends UniversalPrimitive> requiredUniversalType = universalTypeMapper.universalType();
        UniversalPrimitive universalPrimitive = this.typeMappings.map(universal, requiredUniversalType).orElseThrow();
        return universalTypeMapper.fromUniversal(universalPrimitive);
    }

    public List<Class<?>> registeredTypes() {
        return new ArrayList(this.mappings.keySet());
    }

    @Generated
    public String toString() {
        return "CustomPrimitiveMappings(mappings=" + this.mappings + ", typeMappings=" + this.typeMappings + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomPrimitiveMappings)) {
            return false;
        }
        CustomPrimitiveMappings other = (CustomPrimitiveMappings)o;
        Map<Class<?>, UniversalTypeMapper> this$mappings = this.mappings;
        Map<Class<?>, UniversalTypeMapper> other$mappings = other.mappings;
        if (this$mappings == null ? other$mappings != null : !((Object)this$mappings).equals(other$mappings)) {
            return false;
        }
        TypeMappings this$typeMappings = this.typeMappings;
        TypeMappings other$typeMappings = other.typeMappings;
        return !(this$typeMappings == null ? other$typeMappings != null : !((Object)this$typeMappings).equals(other$typeMappings));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<Class<?>, UniversalTypeMapper> $mappings = this.mappings;
        result = result * 59 + ($mappings == null ? 43 : ((Object)$mappings).hashCode());
        TypeMappings $typeMappings = this.typeMappings;
        result = result * 59 + ($typeMappings == null ? 43 : ((Object)$typeMappings).hashCode());
        return result;
    }

    @Generated
    private CustomPrimitiveMappings(Map<Class<?>, UniversalTypeMapper> mappings) {
        this.mappings = mappings;
    }
}

