/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.reflectmaid;

import de.quantummaid.reflectmaid.ArrayType;
import de.quantummaid.reflectmaid.ClassType;
import de.quantummaid.reflectmaid.validators.NotNullValidator;
import java.util.List;

public interface ResolvedType {
    public static ResolvedType resolvedType(Class<?> type) {
        NotNullValidator.validateNotNull(type, "type");
        if (type.isArray()) {
            return ArrayType.fromArrayClass(type);
        }
        return ClassType.fromClassWithoutGenerics(type);
    }

    public Class<?> assignableType();

    public List<ResolvedType> typeParameters();

    public boolean isAbstract();

    public boolean isInterface();

    default public boolean isPublic() {
        return true;
    }

    default public boolean isAnonymousClass() {
        return false;
    }

    default public boolean isInnerClass() {
        return false;
    }

    default public boolean isLocalClass() {
        return false;
    }

    default public boolean isStatic() {
        return false;
    }

    default public boolean isAnnotation() {
        return false;
    }

    public boolean isWildcard();

    public String description();

    default public String simpleDescription() {
        return this.description();
    }

    default public boolean isInstantiatable() {
        if (this.isInterface()) {
            return false;
        }
        if (this.isAbstract()) {
            return false;
        }
        if (this.isWildcard()) {
            return false;
        }
        return this.typeParameters().stream().allMatch(ResolvedType::isInstantiatable);
    }
}

