/*
 * Decompiled with CFR 0.152.
 */
package dev.goquick.sqlitenow.gradle;

import dev.goquick.sqlitenow.gradle.DataStructCodeGenerator;
import dev.goquick.sqlitenow.gradle.DatabaseCodeGenerator;
import dev.goquick.sqlitenow.gradle.DeferredStatementExecutor;
import dev.goquick.sqlitenow.gradle.MigrationInspector;
import dev.goquick.sqlitenow.gradle.MigratorCodeGenerator;
import dev.goquick.sqlitenow.gradle.MigratorTempStorage;
import dev.goquick.sqlitenow.gradle.QueryCodeGenerator;
import dev.goquick.sqlitenow.gradle.SQLBatchInspector;
import dev.goquick.sqlitenow.gradle.SchemaInspector;
import dev.goquick.sqlitenow.gradle.StandardErrorHandler;
import dev.goquick.sqlitenow.gradle.TempDatabaseConnector;
import dev.goquick.sqlitenow.gradle.sqlite.SqlSingleStatement;
import java.io.File;
import java.sql.Connection;
import java.sql.Statement;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a8\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"main", "", "generateDatabaseFiles", "dbName", "", "sqlDir", "Ljava/io/File;", "packageName", "outDir", "schemaDatabaseFile", "debug", "", "sqlitenow-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nGenerateDatabaseFilesTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateDatabaseFilesTask.kt\ndev/goquick/sqlitenow/gradle/GenerateDatabaseFilesTaskKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,161:1\n1863#2,2:162\n*S KotlinDebug\n*F\n+ 1 GenerateDatabaseFilesTask.kt\ndev/goquick/sqlitenow/gradle/GenerateDatabaseFilesTaskKt\n*L\n138#1:162,2\n*E\n"})
public final class GenerateDatabaseFilesTaskKt {
    public static final void main() {
        String rootScrDir = "/Users/pochkin/Projects/my/sqlitenow-kmp/sample-kmp/composeApp/src/commonMain/sql";
        String schemaDatabaseDir = "/Users/pochkin/Projects/my/sqlitenow-kmp/sample-kmp/composeApp/tmp";
        GenerateDatabaseFilesTaskKt.generateDatabaseFiles("NowSampleDatabase", new File(rootScrDir + "/NowSampleDatabase"), "dev.goquick.sqlitenow.samplekmp.db", new File("/Users/pochkin/Projects/my/sqlitenow-kmp/sample-kmp/composeApp/build/generated/sqlitenow/code"), new File(schemaDatabaseDir + "/schema.db"), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void generateDatabaseFiles(@NotNull String dbName, @NotNull File sqlDir, @NotNull String packageName, @NotNull File outDir, @Nullable File schemaDatabaseFile, boolean debug) {
        Connection connection;
        Intrinsics.checkNotNullParameter((Object)dbName, (String)"dbName");
        Intrinsics.checkNotNullParameter((Object)sqlDir, (String)"sqlDir");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)outDir, (String)"outDir");
        File schemaDir = FilesKt.resolve((File)sqlDir, (String)"schema");
        File initSqlDir = FilesKt.resolve((File)sqlDir, (String)"init");
        File migrationDir = FilesKt.resolve((File)sqlDir, (String)"migration");
        File queriesDirs = FilesKt.resolve((File)sqlDir, (String)"queries");
        if (schemaDatabaseFile != null) {
            schemaDatabaseFile.delete();
            connection = new TempDatabaseConnector(new MigratorTempStorage.File(schemaDatabaseFile), null, 2, null).getConnection();
        } else {
            connection = new TempDatabaseConnector(MigratorTempStorage.Memory.INSTANCE, null, 2, null).getConnection();
        }
        try (Connection conn = connection;){
            SchemaInspector schemaInspector = new SchemaInspector(schemaDir);
            SQLBatchInspector sqlBatchInspector = new SQLBatchInspector(initSqlDir, false);
            MigrationInspector migrationInspector = new MigrationInspector(migrationDir);
            String string = outDir.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)"/generated/", (boolean)false, (int)2, null)) {
                FilesKt.deleteRecursively((File)outDir);
            }
            MigratorCodeGenerator migratorCodeGenerator = new MigratorCodeGenerator(schemaInspector, sqlBatchInspector, migrationInspector, packageName, outDir, debug);
            MigratorCodeGenerator.generateCode$default(migratorCodeGenerator, null, 1, null);
            List<DeferredStatementExecutor> list = schemaInspector.getStatementExecutors();
            DataStructCodeGenerator dataStructCodeGenerator = new DataStructCodeGenerator(conn, queriesDirs, packageName, outDir, list, null, 32, null);
            dataStructCodeGenerator.generateCode();
            QueryCodeGenerator queryCodeGenerator = new QueryCodeGenerator(dataStructCodeGenerator, packageName, outDir, debug);
            queryCodeGenerator.generateCode();
            List<SqlSingleStatement> allStatements = sqlBatchInspector.getSqlStatements();
            conn.setAutoCommit(true);
            Iterable $this$forEach$iv = allStatements;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SqlSingleStatement it = (SqlSingleStatement)element$iv;
                boolean bl = false;
                AutoCloseable autoCloseable = conn.createStatement();
                Throwable throwable = null;
                try {
                    Statement stmt = (Statement)autoCloseable;
                    boolean bl2 = false;
                    try {
                        stmt.executeUpdate(it.getSql());
                    }
                    catch (Throwable e) {
                        StandardErrorHandler.INSTANCE.handleSqlExecutionError(it.getSql(), e, "GenerateDatabaseFilesTask");
                        throw new KotlinNothingValueException();
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
            }
            DatabaseCodeGenerator dbCodeGen = new DatabaseCodeGenerator(dataStructCodeGenerator.getNsWithStatements(), dataStructCodeGenerator.getCreateTableStatements(), dataStructCodeGenerator.getCreateViewStatements(), packageName, outDir, dbName);
            dbCodeGen.generateDatabaseClass();
        }
    }

    public static /* synthetic */ void main(String[] args) {
        GenerateDatabaseFilesTaskKt.main();
    }
}

