/*
 * Decompiled with CFR 0.152.
 */
package dev.goquick.sqlitenow.gradle;

import com.squareup.kotlinpoet.AnnotationSpec;
import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.CodeBlock;
import com.squareup.kotlinpoet.FileSpec;
import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.TypeSpec;
import dev.goquick.sqlitenow.gradle.MigrationInspector;
import dev.goquick.sqlitenow.gradle.SQLBatchInspector;
import dev.goquick.sqlitenow.gradle.SchemaInspector;
import dev.goquick.sqlitenow.gradle.sqlite.SqlSingleStatement;
import dev.goquick.sqlitenow.gradle.sqlite.SqlTranslatorKt;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Suppress;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u001e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\u001e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\b\u0010\u001e\u001a\u00020\u0013H\u0002J\u0010\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010!\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Ldev/goquick/sqlitenow/gradle/MigratorCodeGenerator;", "", "schemaInspector", "Ldev/goquick/sqlitenow/gradle/SchemaInspector;", "sqlBatchInspector", "Ldev/goquick/sqlitenow/gradle/SQLBatchInspector;", "migrationInspector", "Ldev/goquick/sqlitenow/gradle/MigrationInspector;", "packageName", "", "outputDir", "Ljava/io/File;", "debug", "", "<init>", "(Ldev/goquick/sqlitenow/gradle/SchemaInspector;Ldev/goquick/sqlitenow/gradle/SQLBatchInspector;Ldev/goquick/sqlitenow/gradle/MigrationInspector;Ljava/lang/String;Ljava/io/File;Z)V", "logger", "Lorg/gradle/api/logging/Logger;", "generateApplyMigrationFunction", "Lcom/squareup/kotlinpoet/FunSpec;", "generateMigrateToVersionFunction", "version", "", "statements", "", "Ldev/goquick/sqlitenow/gradle/sqlite/SqlSingleStatement;", "addSqlStatementsToCodeBlock", "", "codeBlockBuilder", "Lcom/squareup/kotlinpoet/CodeBlock$Builder;", "generateExecuteSqlFunction", "generateCode", "Lcom/squareup/kotlinpoet/FileSpec;", "className", "sqlitenow-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nMigratorCodeGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MigratorCodeGenerator.kt\ndev/goquick/sqlitenow/gradle/MigratorCodeGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,195:1\n1863#2,2:196\n1863#2,2:198\n216#3,2:200\n*S KotlinDebug\n*F\n+ 1 MigratorCodeGenerator.kt\ndev/goquick/sqlitenow/gradle/MigratorCodeGenerator\n*L\n68#1:196,2\n106#1:198,2\n165#1:200,2\n*E\n"})
public final class MigratorCodeGenerator {
    @NotNull
    private final SchemaInspector schemaInspector;
    @NotNull
    private final SQLBatchInspector sqlBatchInspector;
    @NotNull
    private final MigrationInspector migrationInspector;
    @NotNull
    private final String packageName;
    @NotNull
    private final File outputDir;
    private final boolean debug;
    @NotNull
    private final Logger logger;

    public MigratorCodeGenerator(@NotNull SchemaInspector schemaInspector, @NotNull SQLBatchInspector sqlBatchInspector, @NotNull MigrationInspector migrationInspector, @NotNull String packageName, @NotNull File outputDir, boolean debug) {
        Intrinsics.checkNotNullParameter((Object)schemaInspector, (String)"schemaInspector");
        Intrinsics.checkNotNullParameter((Object)sqlBatchInspector, (String)"sqlBatchInspector");
        Intrinsics.checkNotNullParameter((Object)migrationInspector, (String)"migrationInspector");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
        this.schemaInspector = schemaInspector;
        this.sqlBatchInspector = sqlBatchInspector;
        this.migrationInspector = migrationInspector;
        this.packageName = packageName;
        this.outputDir = outputDir;
        this.debug = debug;
        Logger logger = Logging.getLogger(MigratorCodeGenerator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    public /* synthetic */ MigratorCodeGenerator(SchemaInspector schemaInspector, SQLBatchInspector sQLBatchInspector, MigrationInspector migrationInspector, String string, File file, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            bl = false;
        }
        this(schemaInspector, sQLBatchInspector, migrationInspector, string, file, bl);
    }

    private final FunSpec generateApplyMigrationFunction() {
        Object[] objectArray = new KModifier[]{KModifier.OVERRIDE, KModifier.SUSPEND};
        FunSpec.Builder builder = FunSpec.Companion.builder("applyMigration").addModifiers((KModifier[])objectArray);
        objectArray = new Object[]{"SameReturnValue"};
        FunSpec.Builder builder2 = builder.addAnnotation(AnnotationSpec.Companion.builder(Reflection.getOrCreateKotlinClass(Suppress.class)).addMember("%S", objectArray).build());
        objectArray = new String[]{"SafeSQLiteConnection"};
        FunSpec.Builder functionBuilder = FunSpec.Builder.returns$default((FunSpec.Builder)builder2.addParameter("conn", (TypeName)new ClassName("dev.goquick.sqlitenow.core", (String[])objectArray), new KModifier[0]).addParameter("currentVersion", Reflection.getOrCreateKotlinClass(Integer.TYPE), new KModifier[0]), (KClass)Reflection.getOrCreateKotlinClass(Integer.TYPE), null, (int)2, null);
        CodeBlock.Builder codeBlockBuilder = CodeBlock.Companion.builder();
        CodeBlock.Builder builder3 = this.debug ? codeBlockBuilder.add("return conn.withContextAndTrace {\n", new Object[0]) : codeBlockBuilder.add("return withContext(conn.dispatcher) {\n", new Object[0]);
        codeBlockBuilder.add("    if (currentVersion == -1) {\n", new Object[0]);
        codeBlockBuilder.add("        executeAllSql(conn)\n", new Object[0]);
        CodeBlock.Builder builder4 = this.debug ? codeBlockBuilder.add("        return@withContextAndTrace " + this.migrationInspector.getLatestVersion() + "\n", new Object[0]) : codeBlockBuilder.add("        return@withContext " + this.migrationInspector.getLatestVersion() + "\n", new Object[0]);
        codeBlockBuilder.add("    }\n", new Object[0]);
        codeBlockBuilder.add("\n", new Object[0]);
        Set<Integer> set = this.migrationInspector.getSqlStatements().keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        Iterable $this$forEach$iv = CollectionsKt.sorted((Iterable)set);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int version = ((Number)element$iv).intValue();
            boolean bl = false;
            codeBlockBuilder.add("    if (currentVersion < " + version + ") {\n", new Object[0]);
            codeBlockBuilder.add("        migrateToVersion" + version + "(conn)\n", new Object[0]);
            codeBlockBuilder.add("    }\n", new Object[0]);
            codeBlockBuilder.add("\n", new Object[0]);
        }
        codeBlockBuilder.add("    " + this.migrationInspector.getLatestVersion() + "\n", new Object[0]);
        codeBlockBuilder.add("}\n", new Object[0]);
        return functionBuilder.addCode(codeBlockBuilder.build()).build();
    }

    private final FunSpec generateMigrateToVersionFunction(int version, List<SqlSingleStatement> statements) {
        Object[] objectArray = new KModifier[]{KModifier.PRIVATE};
        FunSpec.Builder builder = FunSpec.Companion.builder("migrateToVersion" + version).addModifiers(objectArray);
        objectArray = new String[]{"SafeSQLiteConnection"};
        FunSpec.Builder functionBuilder = builder.addParameter("conn", (TypeName)new ClassName("dev.goquick.sqlitenow.core", (String[])objectArray), new KModifier[0]);
        CodeBlock.Builder codeBlockBuilder = CodeBlock.Companion.builder().addStatement("// Execute SQL statements for version " + version, new Object[0]);
        this.addSqlStatementsToCodeBlock(codeBlockBuilder, statements);
        functionBuilder.addCode(codeBlockBuilder.build());
        return functionBuilder.build();
    }

    private final void addSqlStatementsToCodeBlock(CodeBlock.Builder codeBlockBuilder, List<SqlSingleStatement> statements) {
        Iterable $this$forEach$iv = statements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SqlSingleStatement statement = (SqlSingleStatement)element$iv;
            boolean bl = false;
            String formattedSql = SqlTranslatorKt.translateSqliteStatementToKotlin(statement.getSql());
            CodeBlock.Builder builder = StringsKt.contains$default((CharSequence)formattedSql, (CharSequence)"$", (boolean)false, (int)2, null) ? codeBlockBuilder.addStatement("conn.ref.execSQL($$\"\"\"" + formattedSql + "\"\"\".trimMargin())", new Object[0]) : codeBlockBuilder.addStatement("conn.ref.execSQL(\"\"\"" + formattedSql + "\"\"\".trimMargin())", new Object[0]);
        }
    }

    private final FunSpec generateExecuteSqlFunction() {
        Object[] objectArray = new KModifier[]{KModifier.PRIVATE};
        FunSpec.Builder builder = FunSpec.Companion.builder("executeAllSql").addModifiers(objectArray);
        objectArray = new String[]{"SafeSQLiteConnection"};
        FunSpec.Builder functionBuilder = builder.addParameter("conn", (TypeName)new ClassName("dev.goquick.sqlitenow.core", (String[])objectArray), new KModifier[0]);
        CodeBlock.Builder codeBlockBuilder = CodeBlock.Companion.builder().addStatement("// Execute all SQL statements from the schema and batch inspector", new Object[0]);
        List allStatements = CollectionsKt.plus((Collection)this.schemaInspector.getSqlStatements(), (Iterable)this.sqlBatchInspector.getSqlStatements());
        this.addSqlStatementsToCodeBlock(codeBlockBuilder, allStatements);
        functionBuilder.addCode(codeBlockBuilder.build());
        return functionBuilder.build();
    }

    @NotNull
    public final FileSpec generateCode(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        if (!this.outputDir.exists() && !this.outputDir.mkdirs()) {
            throw new RuntimeException("Failed to create output directory: " + this.outputDir.getAbsolutePath());
        }
        String[] stringArray = new String[]{"DatabaseMigrations"};
        TypeSpec.Builder classBuilder = TypeSpec.Builder.addSuperinterface$default((TypeSpec.Builder)TypeSpec.Companion.classBuilder(className), (TypeName)((TypeName)new ClassName("dev.goquick.sqlitenow.core", stringArray)), null, (int)2, null).addFunction(FunSpec.Companion.constructorBuilder().build());
        FunSpec applyMigrationFunction = this.generateApplyMigrationFunction();
        classBuilder.addFunction(applyMigrationFunction);
        Map $this$forEach$iv = this.migrationInspector.getSqlStatements();
        boolean $i$f$forEach = false;
        String[] stringArray2 = $this$forEach$iv.entrySet().iterator();
        while (stringArray2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = stringArray2.next();
            boolean bl = false;
            int version = ((Number)entry.getKey()).intValue();
            List statements = (List)entry.getValue();
            FunSpec versionFunction = this.generateMigrateToVersionFunction(version, statements);
            classBuilder.addFunction(versionFunction);
        }
        FunSpec executeSqlFunction = this.generateExecuteSqlFunction();
        classBuilder.addFunction(executeSqlFunction);
        stringArray2 = new String[]{"SafeSQLiteConnection"};
        FileSpec.Builder builder = FileSpec.Companion.builder(this.packageName, className).addType(classBuilder.build()).addImport("dev.goquick.sqlitenow.core", stringArray2);
        stringArray2 = new String[]{"execSQL"};
        FileSpec.Builder builder2 = builder.addImport("androidx.sqlite", stringArray2);
        stringArray2 = new String[]{"DatabaseMigrations"};
        FileSpec.Builder fileSpecBuilder = builder2.addImport("dev.goquick.sqlitenow.core", stringArray2);
        if (!this.debug) {
            stringArray2 = new String[]{"withContext"};
            fileSpecBuilder.addImport("kotlinx.coroutines", stringArray2);
        }
        FileSpec fileSpec = fileSpecBuilder.build();
        fileSpec.writeTo(this.outputDir);
        return fileSpec;
    }

    public static /* synthetic */ FileSpec generateCode$default(MigratorCodeGenerator migratorCodeGenerator, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "VersionBasedDatabaseMigrations";
        }
        return migratorCodeGenerator.generateCode(string);
    }
}

