/*
 * Decompiled with CFR 0.152.
 */
package dev.goquick.sqlitenow.gradle;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigValue;
import dev.goquick.sqlitenow.gradle.SqliteTypeToKotlinCodeConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\u001a\"\u0010\u0000\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005\u001a\u0016\u0010\u0006\u001a\u00020\u00022\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005H\u0002\u001a$\u0010\u0007\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00010\u00052\u0006\u0010\b\u001a\u00020\u0002H\u0002\u001a\u001e\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00012\u0006\u0010\b\u001a\u00020\u0002H\u0002\u001a.\u0010\n\u001a\u001c\u0012\u0004\u0012\u00020\u0002\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00010\u00012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005\u001a\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0002\u001a\u001c\u0010\u000e\u001a\u00020\u000f2\b\u0010\r\u001a\u0004\u0018\u00010\u00022\b\u0010\u0010\u001a\u0004\u0018\u00010\u0002H\u0002\u001a\u0012\u0010\u0011\u001a\u00020\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u0000\u001a\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0002\u001a\u0010\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0002H\u0002\u00a8\u0006\u0015"}, d2={"extractAnnotations", "", "", "", "comments", "", "cleanedUpComments", "iterateBlockAnnotations", "content", "parseHoconAnnotations", "extractFieldAssociatedAnnotations", "validateAdapterValue", "", "adapterValue", "shouldGenerateCustomAdapter", "", "propertyType", "parseNotNullValue", "value", "isCustomType", "extractBaseTypeName", "sqlitenow-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nAnnotations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Annotations.kt\ndev/goquick/sqlitenow/gradle/AnnotationsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,356:1\n1863#2,2:357\n1557#2:359\n1628#2,3:360\n1863#2,2:363\n*S KotlinDebug\n*F\n+ 1 Annotations.kt\ndev/goquick/sqlitenow/gradle/AnnotationsKt\n*L\n13#1:357,2\n21#1:359\n21#1:360,3\n110#1:363,2\n*E\n"})
public final class AnnotationsKt {
    @NotNull
    public static final Map<String, Object> extractAnnotations(@NotNull List<String> comments) {
        Intrinsics.checkNotNullParameter(comments, (String)"comments");
        String combinedComment = AnnotationsKt.cleanedUpComments(comments);
        Map allAnnotations = new LinkedHashMap();
        List<Map<String, Object>> annotationBlocks = AnnotationsKt.iterateBlockAnnotations(combinedComment);
        Iterable $this$forEach$iv = annotationBlocks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map blockAnnotations = (Map)element$iv;
            boolean bl = false;
            allAnnotations.putAll(blockAnnotations);
        }
        return allAnnotations;
    }

    /*
     * WARNING - void declaration
     */
    private static final String cleanedUpComments(List<String> comments) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = comments;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void comment;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            CharSequence charSequence = (CharSequence)comment;
            Regex regex = new Regex("^\\s*--\\s*");
            String string2 = "";
            charSequence = regex.replace(charSequence, string2);
            regex = new Regex("/\\*|\\*/");
            string2 = "";
            collection.add(((Object)StringsKt.trim((CharSequence)regex.replace(charSequence, string2))).toString());
        }
        List cleanedComments = (List)destination$iv$iv;
        return CollectionsKt.joinToString$default((Iterable)cleanedComments, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }

    private static final List<Map<String, Object>> iterateBlockAnnotations(String content) {
        int endIndex;
        int startIndex;
        int searchStart = 0;
        List allAnnotations = new ArrayList();
        while ((startIndex = StringsKt.indexOf$default((CharSequence)content, (String)"@@{", (int)searchStart, (boolean)false, (int)4, null)) != -1 && (endIndex = StringsKt.indexOf$default((CharSequence)content, (String)"}", (int)startIndex, (boolean)false, (int)4, null)) != -1) {
            String string = content.substring(startIndex + 3, endIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String hoconContent = ((Object)StringsKt.trim((CharSequence)string)).toString();
            Map<String, Object> blockAnnotations = AnnotationsKt.parseHoconAnnotations(hoconContent);
            allAnnotations.add(blockAnnotations);
            searchStart = endIndex + 1;
        }
        return allAnnotations;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<String, Object> parseHoconAnnotations(String content) {
        void var1_1;
        try {
            void var3_4;
            String hoconText = "{ " + content + " }";
            Config config = ConfigFactory.parseString((String)hoconText, (ConfigParseOptions)ConfigParseOptions.defaults().setAllowMissing(false));
            Map annotations = new LinkedHashMap();
            for (Map.Entry entry : config.entrySet()) {
                String key = (String)entry.getKey();
                Object value = ((ConfigValue)entry.getValue()).unwrapped();
                Map map = annotations;
                Object object = value;
                object = object instanceof String || object instanceof Boolean || object instanceof List ? value : (object == null ? null : value.toString());
                map.put(key, object);
            }
            var1_1 = var3_4;
        }
        catch (Exception e) {
            System.err.println(StringsKt.trimIndent((String)("\n            Failed to parse HOCON annotations\n            ---------------------------------\n            " + content + "\n            ---------------------------------\n        ")));
            throw e;
        }
        return var1_1;
    }

    @NotNull
    public static final Map<String, Map<String, Object>> extractFieldAssociatedAnnotations(@NotNull List<String> comments) {
        Intrinsics.checkNotNullParameter(comments, (String)"comments");
        String combinedComment = AnnotationsKt.cleanedUpComments(comments);
        List<Map<String, Object>> annotationBlocks = AnnotationsKt.iterateBlockAnnotations(combinedComment);
        Map result = new LinkedHashMap();
        Iterable $this$forEach$iv = annotationBlocks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String adapterValue;
            String propertyType;
            Object v;
            String string;
            Map blockAnnotations = (Map)element$iv;
            boolean bl = false;
            Object v2 = blockAnnotations.get("field");
            String fieldName = v2 instanceof String ? (String)v2 : null;
            Object v3 = blockAnnotations.get("dynamicField");
            String dynamicFieldName = v3 instanceof String ? (String)v3 : null;
            if (fieldName != null && !StringsKt.isBlank((CharSequence)fieldName) && dynamicFieldName != null && !StringsKt.isBlank((CharSequence)dynamicFieldName)) {
                throw new IllegalArgumentException("Annotation block cannot contain both 'field' and 'dynamicField' annotations");
            }
            if (fieldName != null && !StringsKt.isBlank((CharSequence)fieldName)) {
                string = fieldName;
            } else if (dynamicFieldName != null && !StringsKt.isBlank((CharSequence)dynamicFieldName)) {
                string = dynamicFieldName;
            } else {
                throw new IllegalArgumentException("Annotation block must contain either a 'field' or 'dynamicField' annotation with a non-empty value");
            }
            String targetFieldName = string;
            Map fieldAnnotations = MapsKt.toMutableMap((Map)blockAnnotations);
            fieldAnnotations.remove("field");
            fieldAnnotations.remove("dynamicField");
            if (dynamicFieldName != null) {
                v = fieldAnnotations.get("propertyType");
                String string2 = propertyType = v instanceof String ? (String)v : null;
                if (propertyType == null || StringsKt.isBlank((CharSequence)propertyType)) {
                    throw new IllegalArgumentException("dynamicField annotation requires a 'propertyType' annotation with a non-empty value");
                }
                fieldAnnotations.put("_isDynamicField", true);
            }
            propertyType = (v = fieldAnnotations.get("propertyType")) instanceof String ? (String)v : null;
            Object v4 = fieldAnnotations.get("adapter");
            String string3 = adapterValue = v4 instanceof String ? (String)v4 : null;
            if (fieldAnnotations.containsKey("adapter")) {
                AnnotationsKt.validateAdapterValue(adapterValue);
            }
            if (AnnotationsKt.shouldGenerateCustomAdapter(adapterValue, propertyType)) {
                fieldAnnotations.put("adapter", "custom");
            } else {
                fieldAnnotations.remove("adapter");
            }
            result.put(targetFieldName, fieldAnnotations);
        }
        return result;
    }

    private static final void validateAdapterValue(String adapterValue) {
        if (!Intrinsics.areEqual((Object)adapterValue, (Object)"default") && !Intrinsics.areEqual((Object)adapterValue, (Object)"custom")) {
            throw new IllegalArgumentException("Adapter annotation can be adapter=\"default\" or adapter=\"custom\" only");
        }
    }

    private static final boolean shouldGenerateCustomAdapter(String adapterValue, String propertyType) {
        boolean bl;
        String string = adapterValue;
        if (Intrinsics.areEqual((Object)string, (Object)"custom")) {
            bl = true;
        } else if (Intrinsics.areEqual((Object)string, (Object)"default")) {
            bl = propertyType != null && AnnotationsKt.isCustomType(propertyType);
        } else if (string == null) {
            bl = propertyType != null && AnnotationsKt.isCustomType(propertyType);
        } else {
            throw new IllegalArgumentException("Unexpected adapter value: \"" + adapterValue + "\"");
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean parseNotNullValue(@Nullable Object value) {
        Class<?> clazz = value;
        if (!(clazz instanceof Boolean)) {
            Class<?> clazz2 = value;
            if (!(clazz instanceof String)) throw new IllegalArgumentException("Invalid notNull value type: " + (clazz2 != null && (clazz2 = clazz2.getClass()) != null ? clazz2.getSimpleName() : null) + ". Must be boolean");
            String string = ((String)((Object)value)).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            String string2 = string;
            if (Intrinsics.areEqual((Object)string2, (Object)"true")) {
                return true;
            }
            if (!Intrinsics.areEqual((Object)string2, (Object)"false")) throw new IllegalArgumentException("Invalid notNull value: \"" + value + "\". Must be true or false");
            return false;
        }
        boolean bl = (Boolean)((Object)value);
        return bl;
    }

    private static final boolean isCustomType(String propertyType) {
        String baseType = AnnotationsKt.extractBaseTypeName(propertyType);
        return !SqliteTypeToKotlinCodeConverter.Companion.getKOTLIN_STDLIB_TYPES().contains(baseType);
    }

    private static final String extractBaseTypeName(String propertyType) {
        String withoutNullability = ((Object)StringsKt.trim((CharSequence)StringsKt.removeSuffix((String)propertyType, (CharSequence)"?"))).toString();
        String withoutGenerics = ((Object)StringsKt.trim((CharSequence)StringsKt.substringBefore$default((String)withoutNullability, (char)'<', null, (int)2, null))).toString();
        return StringsKt.substringAfterLast$default((String)withoutGenerics, (char)'.', null, (int)2, null);
    }

    public static final /* synthetic */ void access$validateAdapterValue(String adapterValue) {
        AnnotationsKt.validateAdapterValue(adapterValue);
    }

    public static final /* synthetic */ boolean access$shouldGenerateCustomAdapter(String adapterValue, String propertyType) {
        return AnnotationsKt.shouldGenerateCustomAdapter(adapterValue, propertyType);
    }
}

