/*
 * Decompiled with CFR 0.152.
 */
package dev.goquick.sqlitenow.gradle;

import dev.goquick.sqlitenow.gradle.AnnotatedCreateTableStatement;
import dev.goquick.sqlitenow.gradle.AnnotatedCreateViewStatement;
import dev.goquick.sqlitenow.gradle.AnnotatedStatement;
import dev.goquick.sqlitenow.gradle.CreateTableStatementExecutor;
import dev.goquick.sqlitenow.gradle.CreateViewStatementExecutor;
import dev.goquick.sqlitenow.gradle.DeferredStatementExecutor;
import dev.goquick.sqlitenow.gradle.SqlFileProcessor;
import dev.goquick.sqlitenow.gradle.StandardErrorHandler;
import dev.goquick.sqlitenow.gradle.sqlite.SqlSingleStatement;
import java.io.File;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import net.sf.jsqlparser.statement.create.view.CreateView;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=50, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\f2\u0006\u0010\u0014\u001a\u00020\u0015J\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\f2\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\rH\u0002R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Ldev/goquick/sqlitenow/gradle/SchemaInspector;", "", "schemaDirectory", "Ljava/io/File;", "<init>", "(Ljava/io/File;)V", "statementExecutors", "", "Ldev/goquick/sqlitenow/gradle/DeferredStatementExecutor;", "getStatementExecutors", "()Ljava/util/List;", "sqlStatements", "", "Ldev/goquick/sqlitenow/gradle/sqlite/SqlSingleStatement;", "getSqlStatements", "cachedCreateTableStatements", "Ldev/goquick/sqlitenow/gradle/AnnotatedCreateTableStatement;", "cachedCreateViewStatements", "Ldev/goquick/sqlitenow/gradle/AnnotatedCreateViewStatement;", "getCreateTableStatements", "conn", "Ljava/sql/Connection;", "getCreateViewStatements", "inspect", "", "sqlStatement", "sqlitenow-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nSchemaInspector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchemaInspector.kt\ndev/goquick/sqlitenow/gradle/SchemaInspector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,122:1\n1863#2,2:123\n808#2,11:125\n1557#2:136\n1628#2,3:137\n808#2,11:140\n1557#2:151\n1628#2,3:152\n*S KotlinDebug\n*F\n+ 1 SchemaInspector.kt\ndev/goquick/sqlitenow/gradle/SchemaInspector\n*L\n51#1:123,2\n27#1:125,11\n28#1:136\n28#1:137,3\n36#1:140,11\n37#1:151\n37#1:152,3\n*E\n"})
public final class SchemaInspector {
    @NotNull
    private final List<DeferredStatementExecutor> statementExecutors;
    @NotNull
    private final List<SqlSingleStatement> sqlStatements;
    @Nullable
    private List<AnnotatedCreateTableStatement> cachedCreateTableStatements;
    @Nullable
    private List<AnnotatedCreateViewStatement> cachedCreateViewStatements;

    public SchemaInspector(@NotNull File schemaDirectory) {
        Intrinsics.checkNotNullParameter((Object)schemaDirectory, (String)"schemaDirectory");
        this.statementExecutors = new ArrayList();
        SqlFileProcessor.INSTANCE.validateDirectory(schemaDirectory, "Schema", true);
        this.sqlStatements = SqlFileProcessor.INSTANCE.parseAllSqlFilesInDirectory(schemaDirectory);
        if (this.sqlStatements.isEmpty()) {
            throw new IllegalArgumentException("No .sql files found in Schema directory: " + schemaDirectory.getAbsolutePath());
        }
        Iterable $this$forEach$iv = this.sqlStatements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SqlSingleStatement sqlStatement = (SqlSingleStatement)element$iv;
            boolean bl = false;
            this.inspect(sqlStatement);
        }
    }

    @NotNull
    public final List<DeferredStatementExecutor> getStatementExecutors() {
        return this.statementExecutors;
    }

    @NotNull
    public final List<SqlSingleStatement> getSqlStatements() {
        return this.sqlStatements;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AnnotatedCreateTableStatement> getCreateTableStatements(@NotNull Connection conn) {
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        if (this.cachedCreateTableStatements == null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            Iterable iterable = this.statementExecutors;
            SchemaInspector schemaInspector = this;
            boolean $i$f$filterIsInstance = false;
            void var4_5 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof CreateTableStatementExecutor)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterIsInstanceTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                CreateTableStatementExecutor createTableStatementExecutor = (CreateTableStatementExecutor)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                AnnotatedStatement annotatedStatement = it.execute(conn);
                Intrinsics.checkNotNull((Object)annotatedStatement, (String)"null cannot be cast to non-null type dev.goquick.sqlitenow.gradle.AnnotatedCreateTableStatement");
                collection.add((AnnotatedCreateTableStatement)annotatedStatement);
            }
            schemaInspector.cachedCreateTableStatements = (List)destination$iv$iv;
        }
        List<AnnotatedCreateTableStatement> list = this.cachedCreateTableStatements;
        Intrinsics.checkNotNull(list);
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AnnotatedCreateViewStatement> getCreateViewStatements(@NotNull Connection conn) {
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        if (this.cachedCreateViewStatements == null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            Iterable iterable = this.statementExecutors;
            SchemaInspector schemaInspector = this;
            boolean $i$f$filterIsInstance = false;
            void var4_5 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof CreateViewStatementExecutor)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterIsInstanceTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                CreateViewStatementExecutor createViewStatementExecutor = (CreateViewStatementExecutor)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                AnnotatedStatement annotatedStatement = it.execute(conn);
                Intrinsics.checkNotNull((Object)annotatedStatement, (String)"null cannot be cast to non-null type dev.goquick.sqlitenow.gradle.AnnotatedCreateViewStatement");
                collection.add((AnnotatedCreateViewStatement)annotatedStatement);
            }
            schemaInspector.cachedCreateViewStatements = (List)destination$iv$iv;
        }
        List<AnnotatedCreateViewStatement> list = this.cachedCreateViewStatements;
        Intrinsics.checkNotNull(list);
        return list;
    }

    private final void inspect(SqlSingleStatement sqlStatement) {
        try {
            Statement parsedStatement;
            Statement statement = parsedStatement = CCJSqlParserUtil.parse((String)sqlStatement.getSql());
            if (statement instanceof CreateTable) {
                CreateTableStatementExecutor executor = new CreateTableStatementExecutor(sqlStatement, (CreateTable)parsedStatement);
                this.statementExecutors.add(executor);
            } else if (statement instanceof CreateView) {
                CreateViewStatementExecutor executor = new CreateViewStatementExecutor(sqlStatement, (CreateView)parsedStatement);
                this.statementExecutors.add(executor);
            }
        }
        catch (Exception e) {
            StandardErrorHandler.INSTANCE.handleSqlParsingError(sqlStatement.getSql(), e, "SchemaInspector");
            throw new KotlinNothingValueException();
        }
    }
}

