/*
 * Decompiled with CFR 0.152.
 */
package dev.goquick.sqlitenow.gradle;

import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.FileSpec;
import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.LambdaTypeName;
import com.squareup.kotlinpoet.ParameterSpec;
import com.squareup.kotlinpoet.ParameterizedTypeName;
import com.squareup.kotlinpoet.PropertySpec;
import com.squareup.kotlinpoet.TypeName;
import dev.goquick.sqlitenow.gradle.AdapterConfig;
import dev.goquick.sqlitenow.gradle.AnnotatedCreateTableStatement;
import dev.goquick.sqlitenow.gradle.AnnotatedCreateViewStatement;
import dev.goquick.sqlitenow.gradle.AnnotatedExecuteStatement;
import dev.goquick.sqlitenow.gradle.AnnotatedSelectStatement;
import dev.goquick.sqlitenow.gradle.AnnotatedStatement;
import dev.goquick.sqlitenow.gradle.ColumnLookup;
import dev.goquick.sqlitenow.gradle.DataStructCodeGenerator;
import dev.goquick.sqlitenow.gradle.ParameterBinding;
import dev.goquick.sqlitenow.gradle.PropertyNameGeneratorType;
import dev.goquick.sqlitenow.gradle.SelectFieldCodeGenerator;
import dev.goquick.sqlitenow.gradle.SharedResultTypeUtils;
import dev.goquick.sqlitenow.gradle.SqliteTypeToKotlinCodeConverter;
import dev.goquick.sqlitenow.gradle.StatementProcessor;
import dev.goquick.sqlitenow.gradle.StatementUtils;
import dev.goquick.sqlitenow.gradle.TypeMapping;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.gradle.internal.extensions.stdlib.CharSequenceExtensionsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001QB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0014\u001a\u00020\u0015J \u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0005H\u0002J\u0018\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u001cH\u0002J\u0018\u0010 \u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020!H\u0002J0\u0010\"\u001a\u00020\u00152\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u0005H\u0002J<\u0010'\u001a\u00020\u00152\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u00052\b\b\u0002\u0010(\u001a\u00020)2\b\b\u0002\u0010*\u001a\u00020+H\u0002J(\u0010,\u001a\u00020\u00152\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u0005H\u0002J(\u0010-\u001a\u00020\u00152\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0018\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u0005H\u0002J\u0018\u0010.\u001a\u00020\u00152\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0018\u001a\u00020\u001cH\u0002J.\u0010/\u001a\u00020\u00152\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0018\u001a\u00020\u00192\u0014\b\u0002\u00100\u001a\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020)01H\u0002J\u0018\u00103\u001a\u00020\u00152\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u00104\u001a\u00020\u00152\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J*\u00105\u001a\b\u0012\u0004\u0012\u00020\u0005062\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020)01H\u0002J\u0018\u00107\u001a\u0002082\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u0005H\u0002J\u0018\u00109\u001a\u0002082\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u001cH\u0002J\u0018\u0010:\u001a\u0002082\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u0005H\u0002J$\u0010;\u001a\u000e\u0012\u0004\u0012\u00020=\u0012\u0004\u0012\u00020\u00050<2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0002J\u0018\u0010B\u001a\u00020\u00052\u0006\u0010C\u001a\u00020=2\u0006\u0010@\u001a\u00020AH\u0002J2\u0010D\u001a\u00020\u00152\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u00052\b\b\u0002\u0010\u001d\u001a\u00020\u0005H\u0002J(\u0010E\u001a\u00020\u00152\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u0005H\u0002J(\u0010F\u001a\u00020\u00152\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0018\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u0005H\u0002J6\u0010G\u001a\u00020\u00152\n\u0010H\u001a\u00060Ij\u0002`J2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u00052\b\b\u0002\u0010\u001d\u001a\u00020\u0005H\u0002J6\u0010K\u001a\u00020\u00152\n\u0010H\u001a\u00060Ij\u0002`J2\u0006\u0010\u0018\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u00052\b\b\u0002\u0010\u001d\u001a\u00020\u0005H\u0002J\u0014\u0010L\u001a\u00020\u00152\n\u0010H\u001a\u00060Ij\u0002`JH\u0002J\u0018\u0010M\u001a\u00020\u00052\u0006\u0010>\u001a\u00020?2\u0006\u0010N\u001a\u00020OH\u0002J \u0010P\u001a\u00020\u00052\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020A2\u0006\u0010N\u001a\u00020OH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"Ldev/goquick/sqlitenow/gradle/QueryCodeGenerator;", "", "dataStructCodeGenerator", "Ldev/goquick/sqlitenow/gradle/DataStructCodeGenerator;", "packageName", "", "outputDir", "Ljava/io/File;", "<init>", "(Ldev/goquick/sqlitenow/gradle/DataStructCodeGenerator;Ljava/lang/String;Ljava/io/File;)V", "columnLookup", "Ldev/goquick/sqlitenow/gradle/ColumnLookup;", "typeMapping", "Ldev/goquick/sqlitenow/gradle/TypeMapping;", "parameterBinding", "Ldev/goquick/sqlitenow/gradle/ParameterBinding;", "adapterConfig", "Ldev/goquick/sqlitenow/gradle/AdapterConfig;", "selectFieldGenerator", "Ldev/goquick/sqlitenow/gradle/SelectFieldCodeGenerator;", "generateCode", "", "generateQueryFile", "namespace", "statement", "Ldev/goquick/sqlitenow/gradle/AnnotatedStatement;", "generateSelectQueryFunction", "Lcom/squareup/kotlinpoet/FunSpec;", "Ldev/goquick/sqlitenow/gradle/AnnotatedSelectStatement;", "functionName", "generateBindStatementParamsFunction", "generateReadStatementResultFunction", "generateExecuteQueryFunction", "Ldev/goquick/sqlitenow/gradle/AnnotatedExecuteStatement;", "setupFunctionStructure", "fnBld", "Lcom/squareup/kotlinpoet/FunSpec$Builder;", "className", "functionType", "setupStatementFunctionStructure", "includeParamsParameter", "", "adapterType", "Ldev/goquick/sqlitenow/gradle/QueryCodeGenerator$AdapterType;", "setupBindStatementParamsStructure", "setupReadStatementResultStructure", "addResultConversionAdapterParameters", "addAdapterParameters", "filter", "Lkotlin/Function1;", "Ldev/goquick/sqlitenow/gradle/AdapterConfig$ParamConfig;", "addParameterBindingAdapterParameters", "addAllAdapterParameters", "getFilteredAdapterNames", "", "createResultTypeName", "Lcom/squareup/kotlinpoet/ClassName;", "createSelectResultTypeName", "createParamsTypeName", "getUnderlyingTypeAndGetter", "Lkotlin/Pair;", "Lcom/squareup/kotlinpoet/TypeName;", "field", "Ldev/goquick/sqlitenow/gradle/AnnotatedSelectStatement$Field;", "columnIndex", "", "getGetterCallForKotlinType", "kotlinType", "addSqlStatementProcessing", "addBindStatementParamsProcessing", "addReadStatementResultProcessing", "addSqlExecutionImplementationToCodeBuilder", "codeBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "addSelectExecutionImplementationToCodeBuilder", "addExecuteStatementImplementationToCodeBuilder", "getPropertyName", "propertyNameGenerator", "Ldev/goquick/sqlitenow/gradle/PropertyNameGeneratorType;", "generateGetterCall", "AdapterType", "sqlitenow-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nQueryCodeGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QueryCodeGenerator.kt\ndev/goquick/sqlitenow/gradle/QueryCodeGenerator\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,740:1\n216#2,2:741\n774#3:743\n865#3,2:744\n1863#3,2:746\n774#3:748\n865#3,2:749\n1557#3:751\n1628#3,3:752\n1872#3,3:755\n1872#3,3:758\n*S KotlinDebug\n*F\n+ 1 QueryCodeGenerator.kt\ndev/goquick/sqlitenow/gradle/QueryCodeGenerator\n*L\n35#1:741,2\n373#1:743\n373#1:744,2\n375#1:746,2\n418#1:748\n418#1:749,2\n418#1:751\n418#1:752,3\n531#1:755,3\n568#1:758,3\n*E\n"})
public final class QueryCodeGenerator {
    @NotNull
    private final DataStructCodeGenerator dataStructCodeGenerator;
    @NotNull
    private final String packageName;
    @NotNull
    private final File outputDir;
    @NotNull
    private final ColumnLookup columnLookup;
    @NotNull
    private final TypeMapping typeMapping;
    @NotNull
    private final ParameterBinding parameterBinding;
    @NotNull
    private final AdapterConfig adapterConfig;
    @NotNull
    private final SelectFieldCodeGenerator selectFieldGenerator;

    public QueryCodeGenerator(@NotNull DataStructCodeGenerator dataStructCodeGenerator, @NotNull String packageName, @NotNull File outputDir) {
        Intrinsics.checkNotNullParameter((Object)dataStructCodeGenerator, (String)"dataStructCodeGenerator");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
        this.dataStructCodeGenerator = dataStructCodeGenerator;
        this.packageName = packageName;
        this.outputDir = outputDir;
        this.columnLookup = new ColumnLookup(this.dataStructCodeGenerator.getCreateTableStatements(), this.dataStructCodeGenerator.getCreateViewStatements());
        this.typeMapping = new TypeMapping();
        this.parameterBinding = new ParameterBinding(this.columnLookup, this.typeMapping, this.dataStructCodeGenerator);
        this.adapterConfig = new AdapterConfig(this.columnLookup, this.dataStructCodeGenerator.getCreateTableStatements());
        this.selectFieldGenerator = new SelectFieldCodeGenerator(this.dataStructCodeGenerator.getCreateTableStatements());
    }

    public final void generateCode() {
        Map<String, List<AnnotatedStatement>> $this$forEach$iv = this.dataStructCodeGenerator.getNsWithStatements();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, List<AnnotatedStatement>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, List<AnnotatedStatement>> element$iv;
            Map.Entry<String, List<AnnotatedStatement>> entry = element$iv = iterator.next();
            boolean bl = false;
            String namespace = entry.getKey();
            List<AnnotatedStatement> statements = entry.getValue();
            StatementProcessor statementProcessor = new StatementProcessor(statements);
            statementProcessor.processStatements((Function1<? super AnnotatedSelectStatement, Unit>)((Function1)arg_0 -> QueryCodeGenerator.generateCode$lambda$2$lambda$0(this, namespace, arg_0)), (Function1<? super AnnotatedExecuteStatement, Unit>)((Function1)arg_0 -> QueryCodeGenerator.generateCode$lambda$2$lambda$1(this, namespace, arg_0)));
        }
    }

    private final void generateQueryFile(String namespace, AnnotatedStatement statement, String packageName) {
        AnnotatedStatement readStatementResultFunction;
        String className = statement.getDataClassName();
        String fileName = CharSequenceExtensionsKt.capitalized((CharSequence)namespace) + "_" + className;
        String[] stringArray = new String[]{"jsonEncodeToSqlite"};
        FileSpec.Builder builder = FileSpec.Companion.builder(packageName, fileName).addFileComment("Generated query extension functions for " + namespace + "." + className, new Object[0]).addFileComment("\nDo not modify this file manually", new Object[0]).addImport("dev.goquick.sqlitenow.core.util", stringArray);
        stringArray = new String[]{"withContext"};
        FileSpec.Builder builder2 = builder.addImport("kotlinx.coroutines", stringArray);
        stringArray = new String[]{"Dispatchers"};
        FileSpec.Builder builder3 = builder2.addImport("kotlinx.coroutines", stringArray);
        stringArray = new String[]{"IO"};
        FileSpec.Builder fileSpecBuilder = builder3.addImport("kotlinx.coroutines", stringArray);
        FunSpec bindFunction = this.generateBindStatementParamsFunction(namespace, statement);
        fileSpecBuilder.addFunction(bindFunction);
        if (statement instanceof AnnotatedSelectStatement) {
            readStatementResultFunction = this.generateReadStatementResultFunction(namespace, (AnnotatedSelectStatement)statement);
            fileSpecBuilder.addFunction((FunSpec)readStatementResultFunction);
        }
        if ((readStatementResultFunction = statement) instanceof AnnotatedSelectStatement) {
            FunSpec executeAsListFunction = this.generateSelectQueryFunction(namespace, (AnnotatedSelectStatement)statement, "executeAsList");
            FunSpec executeAsOneFunction = this.generateSelectQueryFunction(namespace, (AnnotatedSelectStatement)statement, "executeAsOne");
            FunSpec executeAsOneOrNullFunction = this.generateSelectQueryFunction(namespace, (AnnotatedSelectStatement)statement, "executeAsOneOrNull");
            fileSpecBuilder.addFunction(executeAsListFunction);
            fileSpecBuilder.addFunction(executeAsOneFunction);
            v3 = fileSpecBuilder.addFunction(executeAsOneOrNullFunction);
        } else if (readStatementResultFunction instanceof AnnotatedExecuteStatement) {
            FunSpec queryFunction = this.generateExecuteQueryFunction(namespace, (AnnotatedExecuteStatement)statement);
            v3 = fileSpecBuilder.addFunction(queryFunction);
        } else {
            if (readStatementResultFunction instanceof AnnotatedCreateTableStatement) {
                return;
            }
            if (readStatementResultFunction instanceof AnnotatedCreateViewStatement) {
                return;
            }
            throw new NoWhenBranchMatchedException();
        }
        FileSpec fileSpec = fileSpecBuilder.build();
        fileSpec.writeTo(this.outputDir);
    }

    private final FunSpec generateSelectQueryFunction(String namespace, AnnotatedSelectStatement statement, String functionName) {
        String className = statement.getDataClassName();
        String kdoc = switch (functionName) {
            case "executeAsList" -> "Executes the " + statement.getName() + " SELECT query and returns results as a list.";
            case "executeAsOne" -> "Executes the " + statement.getName() + " SELECT query and returns exactly one result. Throws an exception if no results are found.";
            case "executeAsOneOrNull" -> "Executes the " + statement.getName() + " SELECT query and returns one result or null if no results are found.";
            default -> "Executes the " + statement.getName() + " SELECT query.";
        };
        KModifier[] kModifierArray = new KModifier[]{KModifier.SUSPEND};
        FunSpec.Builder fnBld = FunSpec.Companion.builder(functionName).addModifiers(kModifierArray).addKdoc(kdoc, new Object[0]);
        this.setupFunctionStructure(fnBld, statement, namespace, className, "execute");
        ClassName resultType = this.createSelectResultTypeName(namespace, statement);
        TypeName returnType = switch (functionName) {
            case "executeAsList" -> {
                String[] var10_9 = new String[]{"List"};
                ClassName v1 = new ClassName("kotlin.collections", var10_9);
                var10_9 = new TypeName[]{resultType};
                yield (TypeName)ParameterizedTypeName.Companion.get(v1, (TypeName[])var10_9);
            }
            case "executeAsOne" -> (TypeName)resultType;
            case "executeAsOneOrNull" -> TypeName.copy$default((TypeName)((TypeName)resultType), (boolean)true, null, (int)2, null);
            default -> (TypeName)resultType;
        };
        FunSpec.Builder.returns$default((FunSpec.Builder)fnBld, (TypeName)returnType, null, (int)2, null);
        this.addSqlStatementProcessing(fnBld, statement, namespace, className, functionName);
        return fnBld.build();
    }

    private final FunSpec generateBindStatementParamsFunction(String namespace, AnnotatedStatement statement) {
        String className = statement.getDataClassName();
        FunSpec.Builder fnBld = FunSpec.Companion.builder("bindStatementParams").addKdoc("Binds parameters to an already prepared SQLiteStatement for the " + statement.getName() + " query.", new Object[0]);
        this.setupBindStatementParamsStructure(fnBld, statement, namespace, className);
        FunSpec.Builder.returns$default((FunSpec.Builder)fnBld, (KClass)Reflection.getOrCreateKotlinClass(Unit.class), null, (int)2, null);
        this.addBindStatementParamsProcessing(fnBld, statement, namespace, className);
        return fnBld.build();
    }

    private final FunSpec generateReadStatementResultFunction(String namespace, AnnotatedSelectStatement statement) {
        String capitalizedNamespace = CharSequenceExtensionsKt.capitalized((CharSequence)namespace);
        String className = statement.getDataClassName();
        FunSpec.Builder fnBld = FunSpec.Companion.builder("readStatementResult").addKdoc("Read statement and convert it to " + capitalizedNamespace + "." + className + ".Result entity", new Object[0]);
        this.setupReadStatementResultStructure(fnBld, statement, namespace, className);
        ClassName resultType = this.createSelectResultTypeName(namespace, statement);
        FunSpec.Builder.returns$default((FunSpec.Builder)fnBld, (TypeName)((TypeName)resultType), null, (int)2, null);
        this.addReadStatementResultProcessing(fnBld, statement, namespace, className);
        return fnBld.build();
    }

    private final FunSpec generateExecuteQueryFunction(String namespace, AnnotatedExecuteStatement statement) {
        String className = statement.getDataClassName();
        KModifier[] kModifierArray = new KModifier[]{KModifier.SUSPEND};
        FunSpec.Builder fnBld = FunSpec.Companion.builder("execute").addModifiers(kModifierArray).addKdoc("Executes the " + statement.getName() + " query.", new Object[0]);
        this.setupFunctionStructure(fnBld, statement, namespace, className, "execute");
        FunSpec.Builder.returns$default((FunSpec.Builder)fnBld, (KClass)Reflection.getOrCreateKotlinClass(Unit.class), null, (int)2, null);
        QueryCodeGenerator.addSqlStatementProcessing$default(this, fnBld, statement, namespace, className, null, 16, null);
        return fnBld.build();
    }

    private final void setupFunctionStructure(FunSpec.Builder fnBld, AnnotatedStatement statement, String namespace, String className, String functionType) {
        String capitalizedNamespace = CharSequenceExtensionsKt.capitalized((CharSequence)namespace);
        String[] stringArray = new String[]{capitalizedNamespace};
        ClassName receiverType = new ClassName(this.packageName, stringArray).nestedClass(className);
        FunSpec.Builder.receiver$default((FunSpec.Builder)fnBld, (TypeName)((TypeName)receiverType), null, (int)2, null);
        String[] stringArray2 = new String[]{"SQLiteConnection"};
        ParameterSpec connectionParam = ParameterSpec.Companion.builder("conn", (TypeName)new ClassName("androidx.sqlite", stringArray2), new KModifier[0]).build();
        fnBld.addParameter(connectionParam);
        if (!((Collection)StatementUtils.INSTANCE.getNamedParameters(statement)).isEmpty()) {
            ClassName paramsType = this.createParamsTypeName(namespace, className);
            ParameterSpec paramsParam = ParameterSpec.Companion.builder("params", (TypeName)paramsType, new KModifier[0]).build();
            fnBld.addParameter(paramsParam);
        }
        if (Intrinsics.areEqual((Object)functionType, (Object)"prepareStatement")) {
            this.addParameterBindingAdapterParameters(fnBld, statement);
        } else {
            this.addAllAdapterParameters(fnBld, statement);
        }
    }

    private final void setupStatementFunctionStructure(FunSpec.Builder fnBld, AnnotatedStatement statement, String namespace, String className, boolean includeParamsParameter, AdapterType adapterType) {
        String capitalizedNamespace = CharSequenceExtensionsKt.capitalized((CharSequence)namespace);
        String[] stringArray = new String[]{capitalizedNamespace};
        ClassName receiverType = new ClassName(this.packageName, stringArray).nestedClass(className);
        FunSpec.Builder.receiver$default((FunSpec.Builder)fnBld, (TypeName)((TypeName)receiverType), null, (int)2, null);
        String[] stringArray2 = new String[]{"SQLiteStatement"};
        ParameterSpec statementParam = ParameterSpec.Companion.builder("statement", (TypeName)new ClassName("androidx.sqlite", stringArray2), new KModifier[0]).build();
        fnBld.addParameter(statementParam);
        if (includeParamsParameter && !((Collection)StatementUtils.INSTANCE.getNamedParameters(statement)).isEmpty()) {
            ClassName paramsType = this.createParamsTypeName(namespace, className);
            ParameterSpec paramsParam = ParameterSpec.Companion.builder("params", (TypeName)paramsType, new KModifier[0]).build();
            fnBld.addParameter(paramsParam);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[adapterType.ordinal()]) {
            case 1: {
                this.addParameterBindingAdapterParameters(fnBld, statement);
                break;
            }
            case 2: {
                Intrinsics.checkNotNull((Object)statement, (String)"null cannot be cast to non-null type dev.goquick.sqlitenow.gradle.AnnotatedSelectStatement");
                this.addResultConversionAdapterParameters(fnBld, (AnnotatedSelectStatement)statement);
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    static /* synthetic */ void setupStatementFunctionStructure$default(QueryCodeGenerator queryCodeGenerator, FunSpec.Builder builder, AnnotatedStatement annotatedStatement, String string, String string2, boolean bl, AdapterType adapterType, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        if ((n & 0x20) != 0) {
            adapterType = AdapterType.NONE;
        }
        queryCodeGenerator.setupStatementFunctionStructure(builder, annotatedStatement, string, string2, bl, adapterType);
    }

    private final void setupBindStatementParamsStructure(FunSpec.Builder fnBld, AnnotatedStatement statement, String namespace, String className) {
        this.setupStatementFunctionStructure(fnBld, statement, namespace, className, true, AdapterType.PARAMETER_BINDING);
    }

    private final void setupReadStatementResultStructure(FunSpec.Builder fnBld, AnnotatedSelectStatement statement, String namespace, String className) {
        this.setupStatementFunctionStructure(fnBld, statement, namespace, className, false, AdapterType.RESULT_CONVERSION);
    }

    private final void addResultConversionAdapterParameters(FunSpec.Builder fnBld, AnnotatedSelectStatement statement) {
        this.addAdapterParameters(fnBld, statement, (Function1<? super AdapterConfig.ParamConfig, Boolean>)((Function1)QueryCodeGenerator::addResultConversionAdapterParameters$lambda$3));
    }

    /*
     * WARNING - void declaration
     */
    private final void addAdapterParameters(FunSpec.Builder fnBld, AnnotatedStatement statement, Function1<? super AdapterConfig.ParamConfig, Boolean> filter) {
        void $this$filterTo$iv$iv;
        List<AdapterConfig.ParamConfig> adapterConfigs = this.adapterConfig.collectAllParamConfigs(statement);
        Iterable $this$filter$iv = adapterConfigs;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)filter.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filteredConfigs = (List)destination$iv$iv;
        Iterable $this$forEach$iv = filteredConfigs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object element$iv$iv;
            AdapterConfig.ParamConfig config = (AdapterConfig.ParamConfig)element$iv;
            boolean bl = false;
            element$iv$iv = new TypeName[]{config.getInputType()};
            LambdaTypeName adapterType = LambdaTypeName.Companion.get$default((LambdaTypeName.Companion)LambdaTypeName.Companion, null, element$iv$iv, (TypeName)config.getOutputType(), (int)1, null);
            ParameterSpec adapterParam = ParameterSpec.Companion.builder(config.getAdapterFunctionName(), (TypeName)adapterType, new KModifier[0]).build();
            fnBld.addParameter(adapterParam);
        }
    }

    static /* synthetic */ void addAdapterParameters$default(QueryCodeGenerator queryCodeGenerator, FunSpec.Builder builder, AnnotatedStatement annotatedStatement, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = QueryCodeGenerator::addAdapterParameters$lambda$4;
        }
        queryCodeGenerator.addAdapterParameters(builder, annotatedStatement, (Function1<? super AdapterConfig.ParamConfig, Boolean>)function1);
    }

    private final void addParameterBindingAdapterParameters(FunSpec.Builder fnBld, AnnotatedStatement statement) {
        this.addAdapterParameters(fnBld, statement, (Function1<? super AdapterConfig.ParamConfig, Boolean>)((Function1)QueryCodeGenerator::addParameterBindingAdapterParameters$lambda$6));
    }

    private final void addAllAdapterParameters(FunSpec.Builder fnBld, AnnotatedStatement statement) {
        QueryCodeGenerator.addAdapterParameters$default(this, fnBld, statement, null, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getFilteredAdapterNames(AnnotatedStatement statement, Function1<? super AdapterConfig.ParamConfig, Boolean> filter) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        List<AdapterConfig.ParamConfig> adapterConfigs = this.adapterConfig.collectAllParamConfigs(statement);
        Iterable $this$filter$iv = adapterConfigs;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)filter.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AdapterConfig.ParamConfig paramConfig = (AdapterConfig.ParamConfig)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getAdapterFunctionName());
        }
        return (List)destination$iv$iv;
    }

    private final ClassName createResultTypeName(String namespace, String className) {
        String capitalizedNamespace = CharSequenceExtensionsKt.capitalized((CharSequence)namespace);
        String[] stringArray = new String[]{capitalizedNamespace};
        return new ClassName(this.packageName, stringArray).nestedClass(className).nestedClass("Result");
    }

    private final ClassName createSelectResultTypeName(String namespace, AnnotatedSelectStatement statement) {
        return SharedResultTypeUtils.INSTANCE.createResultTypeName(this.packageName, namespace, statement);
    }

    private final ClassName createParamsTypeName(String namespace, String className) {
        String capitalizedNamespace = CharSequenceExtensionsKt.capitalized((CharSequence)namespace);
        String[] stringArray = new String[]{capitalizedNamespace};
        return new ClassName(this.packageName, stringArray).nestedClass(className).nestedClass("Params");
    }

    private final Pair<TypeName, String> getUnderlyingTypeAndGetter(AnnotatedSelectStatement.Field field, int columnIndex) {
        TypeName kotlinType = SqliteTypeToKotlinCodeConverter.Companion.mapSqlTypeToKotlinType(field.getSrc().getDataType());
        String baseGetterCall = this.getGetterCallForKotlinType(kotlinType, columnIndex);
        return new Pair((Object)kotlinType, (Object)baseGetterCall);
    }

    private final String getGetterCallForKotlinType(TypeName kotlinType, int columnIndex) {
        return this.typeMapping.getGetterCall(kotlinType, columnIndex);
    }

    private final void addSqlStatementProcessing(FunSpec.Builder fnBld, AnnotatedStatement statement, String namespace, String className, String functionName) {
        String capitalizedNamespace = CharSequenceExtensionsKt.capitalized((CharSequence)namespace);
        StringBuilder codeBuilder = new StringBuilder();
        codeBuilder.append("return withContext(Dispatchers.IO) {\n");
        codeBuilder.append("  val sql = " + capitalizedNamespace + "." + className + ".SQL\n");
        codeBuilder.append("  val statement = conn.prepare(sql)\n");
        List<String> namedParameters = StatementUtils.INSTANCE.getNamedParameters(statement);
        if (!((Collection)namedParameters).isEmpty()) {
            Object[] objectArray = new String[]{"statement", "params"};
            List paramsList = CollectionsKt.mutableListOf((Object[])objectArray);
            List<String> parameterBindingAdapters = this.getFilteredAdapterNames(statement, (Function1<? super AdapterConfig.ParamConfig, Boolean>)((Function1)QueryCodeGenerator::addSqlStatementProcessing$lambda$8));
            paramsList.addAll((Collection)parameterBindingAdapters);
            String paramsString = CollectionsKt.joinToString$default((Iterable)paramsList, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
            codeBuilder.append("  " + capitalizedNamespace + "." + className + ".bindStatementParams(" + paramsString + ")\n");
        }
        this.addSqlExecutionImplementationToCodeBuilder(codeBuilder, statement, namespace, className, functionName);
        codeBuilder.append("}");
        String string = codeBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        fnBld.addStatement(string, new Object[0]);
    }

    static /* synthetic */ void addSqlStatementProcessing$default(QueryCodeGenerator queryCodeGenerator, FunSpec.Builder builder, AnnotatedStatement annotatedStatement, String string, String string2, String string3, int n, Object object) {
        if ((n & 0x10) != 0) {
            string3 = "execute";
        }
        queryCodeGenerator.addSqlStatementProcessing(builder, annotatedStatement, string, string2, string3);
    }

    /*
     * WARNING - void declaration
     */
    private final void addBindStatementParamsProcessing(FunSpec.Builder fnBld, AnnotatedStatement statement, String namespace, String className) {
        List<String> namedParameters = StatementUtils.INSTANCE.getNamedParameters(statement);
        if (!((Collection)namedParameters).isEmpty()) {
            Map processedAdapterVars = new LinkedHashMap();
            Iterable $this$forEachIndexed$iv = namedParameters;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void paramName;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string = (String)item$iv;
                int index = n;
                boolean bl = false;
                String propertyName = statement.getAnnotations().getPropertyNameGenerator().convertToPropertyName((String)paramName);
                this.parameterBinding.generateParameterBinding(fnBld, (String)paramName, index, propertyName, statement, namespace, className, processedAdapterVars);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addReadStatementResultProcessing(FunSpec.Builder fnBld, AnnotatedSelectStatement statement, String namespace, String className) {
        StringBuilder stringBuilder;
        String capitalizedNamespace = CharSequenceExtensionsKt.capitalized((CharSequence)namespace);
        String resultType = SharedResultTypeUtils.INSTANCE.createResultTypeString(namespace, statement);
        StringBuilder $this$addReadStatementResultProcessing_u24lambda_u2411 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$addReadStatementResultProcessing_u24lambda_u2411.append("return " + resultType + "(\n");
        Iterable $this$forEachIndexed$iv = statement.getFields();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void field;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            AnnotatedSelectStatement.Field field2 = (AnnotatedSelectStatement.Field)item$iv;
            int index = n;
            boolean bl2 = false;
            String propertyName = this.getPropertyName((AnnotatedSelectStatement.Field)field, statement.getAnnotations().getPropertyNameGenerator());
            String getterCall = this.generateGetterCall((AnnotatedSelectStatement.Field)field, index, statement.getAnnotations().getPropertyNameGenerator());
            boolean isLast = index == statement.getFields().size() - 1;
            String comma = isLast ? "" : ",";
            $this$addReadStatementResultProcessing_u24lambda_u2411.append("  " + propertyName + " = " + getterCall + comma + "\n");
        }
        $this$addReadStatementResultProcessing_u24lambda_u2411.append(")");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String constructorCall = string;
        fnBld.addStatement(constructorCall, new Object[0]);
    }

    private final void addSqlExecutionImplementationToCodeBuilder(StringBuilder codeBuilder, AnnotatedStatement statement, String namespace, String className, String functionName) {
        AnnotatedStatement annotatedStatement = statement;
        if (annotatedStatement instanceof AnnotatedSelectStatement) {
            this.addSelectExecutionImplementationToCodeBuilder(codeBuilder, (AnnotatedSelectStatement)statement, namespace, className, functionName);
        } else if (annotatedStatement instanceof AnnotatedExecuteStatement) {
            this.addExecuteStatementImplementationToCodeBuilder(codeBuilder);
        } else if (annotatedStatement instanceof AnnotatedCreateTableStatement) {
            codeBuilder.append("  TODO(\"Unimplemented\")\n");
        } else if (annotatedStatement instanceof AnnotatedCreateViewStatement) {
            codeBuilder.append("  TODO(\"Unimplemented\")\n");
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    static /* synthetic */ void addSqlExecutionImplementationToCodeBuilder$default(QueryCodeGenerator queryCodeGenerator, StringBuilder stringBuilder, AnnotatedStatement annotatedStatement, String string, String string2, String string3, int n, Object object) {
        if ((n & 0x10) != 0) {
            string3 = "execute";
        }
        queryCodeGenerator.addSqlExecutionImplementationToCodeBuilder(stringBuilder, annotatedStatement, string, string2, string3);
    }

    private final void addSelectExecutionImplementationToCodeBuilder(StringBuilder codeBuilder, AnnotatedSelectStatement statement, String namespace, String className, String functionName) {
        String capitalizedNamespace = CharSequenceExtensionsKt.capitalized((CharSequence)namespace);
        String resultType = SharedResultTypeUtils.INSTANCE.createResultTypeString(namespace, statement);
        Object[] objectArray = new String[]{"statement"};
        List paramsList = CollectionsKt.mutableListOf((Object[])objectArray);
        List<String> resultConversionAdapters = this.getFilteredAdapterNames(statement, (Function1<? super AdapterConfig.ParamConfig, Boolean>)((Function1)QueryCodeGenerator::addSelectExecutionImplementationToCodeBuilder$lambda$12));
        paramsList.addAll((Collection)resultConversionAdapters);
        String paramsString = CollectionsKt.joinToString$default((Iterable)paramsList, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
        codeBuilder.append("  statement.use { statement ->\n");
        switch (functionName) {
            case "executeAsList": {
                codeBuilder.append("    val results = mutableListOf<" + resultType + ">()\n");
                codeBuilder.append("    while (statement.step()) {\n");
                codeBuilder.append("      results.add(" + capitalizedNamespace + "." + className + ".readStatementResult(" + paramsString + "))\n");
                codeBuilder.append("    }\n");
                codeBuilder.append("    results\n");
                break;
            }
            case "executeAsOne": {
                codeBuilder.append("    if (statement.step()) {\n");
                codeBuilder.append("      " + capitalizedNamespace + "." + className + ".readStatementResult(" + paramsString + ")\n");
                codeBuilder.append("    } else {\n");
                codeBuilder.append("      throw IllegalStateException(\"Query returned no results, but exactly one result was expected\")\n");
                codeBuilder.append("    }\n");
                break;
            }
            case "executeAsOneOrNull": {
                codeBuilder.append("    if (statement.step()) {\n");
                codeBuilder.append("      " + capitalizedNamespace + "." + className + ".readStatementResult(" + paramsString + ")\n");
                codeBuilder.append("    } else {\n");
                codeBuilder.append("      null\n");
                codeBuilder.append("    }\n");
            }
        }
        codeBuilder.append("  }\n");
    }

    static /* synthetic */ void addSelectExecutionImplementationToCodeBuilder$default(QueryCodeGenerator queryCodeGenerator, StringBuilder stringBuilder, AnnotatedSelectStatement annotatedSelectStatement, String string, String string2, String string3, int n, Object object) {
        if ((n & 0x10) != 0) {
            string3 = "executeAsList";
        }
        queryCodeGenerator.addSelectExecutionImplementationToCodeBuilder(stringBuilder, annotatedSelectStatement, string, string2, string3);
    }

    private final void addExecuteStatementImplementationToCodeBuilder(StringBuilder codeBuilder) {
        codeBuilder.append("  statement.use { statement ->\n");
        codeBuilder.append("    statement.step()\n");
        codeBuilder.append("  }\n");
    }

    private final String getPropertyName(AnnotatedSelectStatement.Field field, PropertyNameGeneratorType propertyNameGenerator) {
        return this.adapterConfig.getPropertyName(field, propertyNameGenerator, this.selectFieldGenerator);
    }

    private final String generateGetterCall(AnnotatedSelectStatement.Field field, int columnIndex, PropertyNameGeneratorType propertyNameGenerator) {
        if (this.adapterConfig.hasAdapterAnnotation(field)) {
            String columnName = PropertyNameGeneratorType.LOWER_CAMEL_CASE.convertToPropertyName(field.getSrc().getOriginalColumnName());
            String adapterParamName = this.adapterConfig.getOutputAdapterFunctionName(columnName);
            PropertySpec property = this.selectFieldGenerator.generateProperty(field, PropertyNameGeneratorType.LOWER_CAMEL_CASE);
            boolean inputNullable = property.getType().isNullable();
            String baseGetterCall = StringsKt.replace$default((String)((String)this.getUnderlyingTypeAndGetter(field, columnIndex).getSecond()), (String)"stmt", (String)"statement", (boolean)false, (int)4, null);
            return inputNullable ? "if (statement.isNull(" + columnIndex + ")) " + adapterParamName + "(null) else " + adapterParamName + "(" + baseGetterCall + ")" : adapterParamName + "(" + baseGetterCall + ")";
        }
        PropertySpec property = this.selectFieldGenerator.generateProperty(field, propertyNameGenerator);
        TypeName kotlinType = property.getType();
        String baseGetterCall = StringsKt.replace$default((String)this.getGetterCallForKotlinType(TypeName.copy$default((TypeName)kotlinType, (boolean)false, null, (int)2, null), columnIndex), (String)"stmt", (String)"statement", (boolean)false, (int)4, null);
        return kotlinType.isNullable() ? "if (statement.isNull(" + columnIndex + ")) null else " + baseGetterCall : baseGetterCall;
    }

    private static final Unit generateCode$lambda$2$lambda$0(QueryCodeGenerator this$0, String $namespace, AnnotatedSelectStatement statement) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        this$0.generateQueryFile($namespace, statement, this$0.packageName);
        return Unit.INSTANCE;
    }

    private static final Unit generateCode$lambda$2$lambda$1(QueryCodeGenerator this$0, String $namespace, AnnotatedExecuteStatement statement) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        this$0.generateQueryFile($namespace, statement, this$0.packageName);
        return Unit.INSTANCE;
    }

    private static final boolean addResultConversionAdapterParameters$lambda$3(AdapterConfig.ParamConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        return StringsKt.startsWith$default((String)config.getAdapterFunctionName(), (String)"sqlColumnTo", (boolean)false, (int)2, null);
    }

    private static final boolean addAdapterParameters$lambda$4(AdapterConfig.ParamConfig it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean addParameterBindingAdapterParameters$lambda$6(AdapterConfig.ParamConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        return StringsKt.endsWith$default((String)config.getAdapterFunctionName(), (String)"ToSqlColumn", (boolean)false, (int)2, null);
    }

    private static final boolean addSqlStatementProcessing$lambda$8(AdapterConfig.ParamConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        return StringsKt.endsWith$default((String)config.getAdapterFunctionName(), (String)"ToSqlColumn", (boolean)false, (int)2, null);
    }

    private static final boolean addSelectExecutionImplementationToCodeBuilder$lambda$12(AdapterConfig.ParamConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        return StringsKt.startsWith$default((String)config.getAdapterFunctionName(), (String)"sqlColumnTo", (boolean)false, (int)2, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Ldev/goquick/sqlitenow/gradle/QueryCodeGenerator$AdapterType;", "", "<init>", "(Ljava/lang/String;I)V", "PARAMETER_BINDING", "RESULT_CONVERSION", "NONE", "sqlitenow-gradle-plugin"})
    private static final class AdapterType
    extends Enum<AdapterType> {
        public static final /* enum */ AdapterType PARAMETER_BINDING = new AdapterType();
        public static final /* enum */ AdapterType RESULT_CONVERSION = new AdapterType();
        public static final /* enum */ AdapterType NONE = new AdapterType();
        private static final /* synthetic */ AdapterType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static AdapterType[] values() {
            return (AdapterType[])$VALUES.clone();
        }

        public static AdapterType valueOf(String value) {
            return Enum.valueOf(AdapterType.class, value);
        }

        @NotNull
        public static EnumEntries<AdapterType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = adapterTypeArray = new AdapterType[]{AdapterType.PARAMETER_BINDING, AdapterType.RESULT_CONVERSION, AdapterType.NONE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AdapterType.values().length];
            try {
                nArray[AdapterType.PARAMETER_BINDING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AdapterType.RESULT_CONVERSION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AdapterType.NONE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

