/*
 * Decompiled with CFR 0.152.
 */
package dev.goquick.sqlitenow.gradle;

import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.ParameterSpec;
import com.squareup.kotlinpoet.PropertySpec;
import com.squareup.kotlinpoet.TypeName;
import dev.goquick.sqlitenow.gradle.AnnotatedCreateTableStatement;
import dev.goquick.sqlitenow.gradle.AnnotatedSelectStatement;
import dev.goquick.sqlitenow.gradle.FieldAnnotationOverrides;
import dev.goquick.sqlitenow.gradle.PropertyNameGeneratorType;
import dev.goquick.sqlitenow.gradle.SqliteTypeToKotlinCodeConverter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B#\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ$\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001c\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u00062\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J \u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\"\u0010 \u001a\u0004\u0018\u00010\u00172\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0006H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00040\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Ldev/goquick/sqlitenow/gradle/SelectFieldCodeGenerator;", "", "createTableStatements", "", "Ldev/goquick/sqlitenow/gradle/AnnotatedCreateTableStatement;", "packageName", "", "<init>", "(Ljava/util/List;Ljava/lang/String;)V", "tableMap", "", "generateFieldInfo", "Lkotlin/Pair;", "Lcom/squareup/kotlinpoet/TypeName;", "field", "Ldev/goquick/sqlitenow/gradle/AnnotatedSelectStatement$Field;", "propertyNameGeneratorType", "Ldev/goquick/sqlitenow/gradle/PropertyNameGeneratorType;", "generateProperty", "Lcom/squareup/kotlinpoet/PropertySpec;", "generateParameter", "Lcom/squareup/kotlinpoet/ParameterSpec;", "findColumnForField", "Ldev/goquick/sqlitenow/gradle/AnnotatedCreateTableStatement$Column;", "mapSqlTypeToKotlinType", "sqliteType", "generatePropertyName", "fieldName", "annotations", "Ldev/goquick/sqlitenow/gradle/FieldAnnotationOverrides;", "determineNullability", "", "findColumnInTable", "table", "originalColumnName", "sqlitenow-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nSelectFieldCodeGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SelectFieldCodeGenerator.kt\ndev/goquick/sqlitenow/gradle/SelectFieldCodeGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,221:1\n1202#2,2:222\n1230#2,4:224\n1#3:228\n*S KotlinDebug\n*F\n+ 1 SelectFieldCodeGenerator.kt\ndev/goquick/sqlitenow/gradle/SelectFieldCodeGenerator\n*L\n20#1:222,2\n20#1:224,4\n*E\n"})
public final class SelectFieldCodeGenerator {
    @Nullable
    private final String packageName;
    @NotNull
    private final Map<String, AnnotatedCreateTableStatement> tableMap;

    /*
     * WARNING - void declaration
     */
    public SelectFieldCodeGenerator(@NotNull List<AnnotatedCreateTableStatement> createTableStatements, @Nullable String packageName) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Intrinsics.checkNotNullParameter(createTableStatements, (String)"createTableStatements");
        this.packageName = packageName;
        Iterable iterable = createTableStatements;
        SelectFieldCodeGenerator selectFieldCodeGenerator = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var6_7 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            AnnotatedCreateTableStatement annotatedCreateTableStatement = (AnnotatedCreateTableStatement)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            String string = it.getSrc().getTableName().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            map.put(string, element$iv$iv);
        }
        selectFieldCodeGenerator.tableMap = destination$iv$iv;
    }

    public /* synthetic */ SelectFieldCodeGenerator(List list, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 2) != 0) {
            string = null;
        }
        this(list, string);
    }

    private final Pair<String, TypeName> generateFieldInfo(AnnotatedSelectStatement.Field field, PropertyNameGeneratorType propertyNameGeneratorType) {
        String fieldName = field.getSrc().getFieldName();
        String propertyName = this.generatePropertyName(fieldName, field.getAnnotations(), propertyNameGeneratorType);
        TypeName baseType = this.mapSqlTypeToKotlinType(field.getSrc().getDataType(), field);
        boolean isNullable = this.determineNullability(field);
        TypeName propertyType = SqliteTypeToKotlinCodeConverter.Companion.determinePropertyType(baseType, field.getAnnotations().getPropertyType(), isNullable, this.packageName);
        return new Pair((Object)propertyName, (Object)propertyType);
    }

    @NotNull
    public final PropertySpec generateProperty(@NotNull AnnotatedSelectStatement.Field field, @NotNull PropertyNameGeneratorType propertyNameGeneratorType) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)((Object)propertyNameGeneratorType), (String)"propertyNameGeneratorType");
        Pair<String, TypeName> pair = this.generateFieldInfo(field, propertyNameGeneratorType);
        String propertyName = (String)pair.component1();
        TypeName propertyType = (TypeName)pair.component2();
        return PropertySpec.Companion.builder(propertyName, propertyType, new KModifier[0]).initializer(propertyName, new Object[0]).build();
    }

    public static /* synthetic */ PropertySpec generateProperty$default(SelectFieldCodeGenerator selectFieldCodeGenerator, AnnotatedSelectStatement.Field field, PropertyNameGeneratorType propertyNameGeneratorType, int n, Object object) {
        if ((n & 2) != 0) {
            propertyNameGeneratorType = PropertyNameGeneratorType.LOWER_CAMEL_CASE;
        }
        return selectFieldCodeGenerator.generateProperty(field, propertyNameGeneratorType);
    }

    @NotNull
    public final ParameterSpec generateParameter(@NotNull AnnotatedSelectStatement.Field field, @NotNull PropertyNameGeneratorType propertyNameGeneratorType) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)((Object)propertyNameGeneratorType), (String)"propertyNameGeneratorType");
        Pair<String, TypeName> pair = this.generateFieldInfo(field, propertyNameGeneratorType);
        String propertyName = (String)pair.component1();
        TypeName propertyType = (TypeName)pair.component2();
        return ParameterSpec.Companion.builder(propertyName, propertyType, new KModifier[0]).build();
    }

    public static /* synthetic */ ParameterSpec generateParameter$default(SelectFieldCodeGenerator selectFieldCodeGenerator, AnnotatedSelectStatement.Field field, PropertyNameGeneratorType propertyNameGeneratorType, int n, Object object) {
        if ((n & 2) != 0) {
            propertyNameGeneratorType = PropertyNameGeneratorType.LOWER_CAMEL_CASE;
        }
        return selectFieldCodeGenerator.generateParameter(field, propertyNameGeneratorType);
    }

    private final AnnotatedCreateTableStatement.Column findColumnForField(AnnotatedSelectStatement.Field field) {
        String tableName = field.getSrc().getTableName();
        String fieldName = field.getSrc().getFieldName();
        String originalColumnName = field.getSrc().getOriginalColumnName();
        if (!StringsKt.isBlank((CharSequence)tableName)) {
            AnnotatedCreateTableStatement.Column column;
            String string = tableName.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            AnnotatedCreateTableStatement table = this.tableMap.get(string);
            if (table != null && (column = this.findColumnInTable(table, originalColumnName, fieldName)) != null) {
                return column;
            }
        }
        for (AnnotatedCreateTableStatement table : this.tableMap.values()) {
            AnnotatedCreateTableStatement.Column column = this.findColumnInTable(table, originalColumnName, fieldName);
            if (column == null) continue;
            return column;
        }
        return null;
    }

    private final TypeName mapSqlTypeToKotlinType(String sqliteType, AnnotatedSelectStatement.Field field) {
        AnnotatedCreateTableStatement.Column column;
        String[] stringArray = new String[]{"("};
        String string = ((String)StringsKt.split$default((CharSequence)sqliteType, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0)).toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        String baseType = string;
        TypeName kotlinType = SqliteTypeToKotlinCodeConverter.Companion.mapSqlTypeToKotlinType(baseType);
        if (field != null && (column = this.findColumnForField(field)) != null) {
            String propertyType = column.getAnnotations().get("propertyType");
            if (propertyType != null) {
                return SqliteTypeToKotlinCodeConverter.Companion.determinePropertyType(kotlinType, propertyType, false, this.packageName);
            }
            String string2 = column.getSrc().getDataType().toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            String columnType = string2;
            return SqliteTypeToKotlinCodeConverter.Companion.mapSqlTypeToKotlinType(columnType);
        }
        return kotlinType;
    }

    static /* synthetic */ TypeName mapSqlTypeToKotlinType$default(SelectFieldCodeGenerator selectFieldCodeGenerator, String string, AnnotatedSelectStatement.Field field, int n, Object object) {
        if ((n & 2) != 0) {
            field = null;
        }
        return selectFieldCodeGenerator.mapSqlTypeToKotlinType(string, field);
    }

    private final String generatePropertyName(String fieldName, FieldAnnotationOverrides annotations, PropertyNameGeneratorType propertyNameGeneratorType) {
        String string = annotations.getPropertyName();
        if (string != null) {
            String it = string;
            boolean bl = false;
            return it;
        }
        return propertyNameGeneratorType.convertToPropertyName(fieldName);
    }

    private final boolean determineNullability(AnnotatedSelectStatement.Field field) {
        if (Intrinsics.areEqual((Object)field.getAnnotations().getNonNull(), (Object)true)) {
            return false;
        }
        if (Intrinsics.areEqual((Object)field.getAnnotations().getNullable(), (Object)true)) {
            return true;
        }
        AnnotatedCreateTableStatement.Column column = this.findColumnForField(field);
        if (column != null) {
            return column.isNullable();
        }
        return true;
    }

    private final AnnotatedCreateTableStatement.Column findColumnInTable(AnnotatedCreateTableStatement table, String originalColumnName, String fieldName) {
        AnnotatedCreateTableStatement.Column column = table.findColumnByName(originalColumnName);
        if (column == null) {
            column = table.findColumnByName(fieldName);
        }
        return column;
    }

    public SelectFieldCodeGenerator() {
        this(null, null, 3, null);
    }
}

