package dev.goquick.sqlitenow.gradle.processing

import dev.goquick.sqlitenow.gradle.model.AnnotatedCreateTableStatement
import dev.goquick.sqlitenow.gradle.model.AnnotatedCreateViewStatement
import dev.goquick.sqlitenow.gradle.model.AnnotatedExecuteStatement
import dev.goquick.sqlitenow.gradle.model.AnnotatedSelectStatement
import dev.goquick.sqlitenow.gradle.model.AnnotatedStatement

/**
 * Utility class for common statement operations.
 */
object StatementUtils {

    /**
     * Extracts named parameters from any type of statement.
     */
    fun getNamedParameters(statement: AnnotatedStatement): List<String> {
        return when (statement) {
            is AnnotatedSelectStatement -> statement.src.namedParameters
            is AnnotatedExecuteStatement -> statement.src.namedParameters
            is AnnotatedCreateTableStatement -> statement.src.namedParameters
            is AnnotatedCreateViewStatement -> statement.src.namedParameters
        }
    }

    /**
     * Extracts all named parameters including those from WITH clauses.
     * This is used for comprehensive parameter collection in data class generation.
     */
    fun getAllNamedParameters(statement: AnnotatedStatement): Set<String> {
        val allNamedParameters = mutableSetOf<String>()

        // Add basic named parameters
        allNamedParameters.addAll(getNamedParameters(statement))

        // Add parameters from WITH clauses for execute statements
        if (statement is AnnotatedExecuteStatement) {
            statement.src.withSelectStatements.forEach { withSelectStatement ->
                allNamedParameters.addAll(withSelectStatement.namedParameters)
            }
        }

        return allNamedParameters
    }
}
