/*
 * Decompiled with CFR 0.152.
 */
package dev.goquick.sqlitenow.gradle.sqlite;

import dev.goquick.sqlitenow.gradle.sqlite.SqlSingleStatement;
import dev.goquick.sqlitenow.gradle.sqlite.State;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u00a8\u0006\u0005"}, d2={"parseSqlStatements", "", "Ldev/goquick/sqlitenow/gradle/sqlite/SqlSingleStatement;", "sql", "", "sqlitenow-gradle-plugin"})
public final class SqlStatementParserKt {
    @NotNull
    public static final List<SqlSingleStatement> parseSqlStatements(@NotNull String sql) {
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        List results = new ArrayList();
        List topComments = new ArrayList();
        List innerComments = new ArrayList();
        List pendingTopComments = new ArrayList();
        Ref.ObjectRef stmtStart = new Ref.ObjectRef();
        StringBuilder commentBuf = new StringBuilder();
        Ref.BooleanRef readingStmt = new Ref.BooleanRef();
        State state = State.OUTSIDE;
        int i = 0;
        block10: while (i < sql.length()) {
            char c = sql.charAt(i);
            Character c2 = StringsKt.getOrNull((CharSequence)sql, (int)(i + 1));
            switch (WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
                case 1: {
                    char c3;
                    if (c == '-') {
                        Character c4 = c2;
                        c3 = '-';
                        if (c4 != null && c4.charValue() == c3) {
                            state = State.LINE_COMMENT;
                            StringsKt.clear((StringBuilder)commentBuf);
                            i += 2;
                            continue block10;
                        }
                    }
                    if (c == '/') {
                        Character c5 = c2;
                        c3 = '*';
                        if (c5 != null && c5.charValue() == c3) {
                            state = State.BLOCK_COMMENT;
                            StringsKt.clear((StringBuilder)commentBuf);
                            i += 2;
                            continue block10;
                        }
                    }
                    if (c == '\'') {
                        if (stmtStart.element == null) {
                            stmtStart.element = i;
                        }
                        readingStmt.element = true;
                        state = State.SINGLE_QUOTE;
                        ++i;
                        continue block10;
                    }
                    if (c == '\"') {
                        if (stmtStart.element == null) {
                            stmtStart.element = i;
                        }
                        readingStmt.element = true;
                        state = State.DOUBLE_QUOTE;
                        ++i;
                        continue block10;
                    }
                    if (c == ';') {
                        if (stmtStart.element == null) {
                            stmtStart.element = i;
                        }
                        int endIdx = i + 1;
                        SqlStatementParserKt.parseSqlStatements$flushStatement(sql, (Ref.ObjectRef<Integer>)stmtStart, pendingTopComments, topComments, results, innerComments, readingStmt, endIdx);
                        i = endIdx;
                        continue block10;
                    }
                    if (CharsKt.isWhitespace((char)c) && !readingStmt.element) {
                        ++i;
                        continue block10;
                    }
                    if (stmtStart.element == null) {
                        stmtStart.element = i;
                    }
                    readingStmt.element = true;
                    ++i;
                    continue block10;
                }
                case 2: {
                    switch (c) {
                        case '\n': 
                        case '\r': {
                            String comment = "--" + commentBuf;
                            if (stmtStart.element == null) {
                                ((Collection)pendingTopComments).add(comment);
                            } else if (!readingStmt.element) {
                                ((Collection)topComments).add(comment);
                            } else {
                                ((Collection)innerComments).add(comment);
                            }
                            state = State.OUTSIDE;
                            int n = i++;
                            break;
                        }
                        default: {
                            commentBuf.append(c);
                            int n = i++;
                        }
                    }
                    continue block10;
                }
                case 3: {
                    if (c == '*') {
                        Character c6 = c2;
                        char comment = '/';
                        if (c6 != null && c6.charValue() == comment) {
                            String comment2 = "/*" + commentBuf + "*/";
                            if (stmtStart.element == null) {
                                ((Collection)pendingTopComments).add(comment2);
                            } else if (!readingStmt.element) {
                                ((Collection)topComments).add(comment2);
                            } else {
                                ((Collection)innerComments).add(comment2);
                            }
                            state = State.OUTSIDE;
                            i += 2;
                            continue block10;
                        }
                    }
                    commentBuf.append(c);
                    ++i;
                    continue block10;
                }
                case 4: {
                    if (c == '\'') {
                        Character c7 = c2;
                        char c8 = '\'';
                        if (c7 != null && c7.charValue() == c8) {
                            i += 2;
                            continue block10;
                        }
                    }
                    if (c == '\'') {
                        state = State.OUTSIDE;
                        ++i;
                        continue block10;
                    }
                    ++i;
                    continue block10;
                }
                case 5: {
                    if (c == '\"') {
                        Character c9 = c2;
                        char c10 = '\"';
                        if (c9 != null && c9.charValue() == c10) {
                            i += 2;
                            continue block10;
                        }
                    }
                    if (c == '\"') {
                        state = State.OUTSIDE;
                        ++i;
                        continue block10;
                    }
                    ++i;
                    continue block10;
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        if (state == State.LINE_COMMENT) {
            String comment = "--" + commentBuf;
            if (stmtStart.element == null) {
                if (!((Collection)results).isEmpty()) {
                    SqlSingleStatement lastStatement = (SqlSingleStatement)CollectionsKt.last((List)results);
                    List updatedComments = CollectionsKt.plus((Collection)lastStatement.getInnerComments(), (Object)comment);
                    results.set(results.size() - 1, SqlSingleStatement.copy$default(lastStatement, null, updatedComments, null, 5, null));
                }
            } else if (!readingStmt.element) {
                ((Collection)topComments).add(comment);
            } else {
                ((Collection)innerComments).add(comment);
            }
        }
        if (stmtStart.element != null) {
            SqlStatementParserKt.parseSqlStatements$flushStatement(sql, (Ref.ObjectRef<Integer>)stmtStart, pendingTopComments, topComments, results, innerComments, readingStmt, sql.length());
        }
        return results;
    }

    private static final void parseSqlStatements$flushStatement(String $sql, Ref.ObjectRef<Integer> stmtStart, List<String> pendingTopComments, List<String> topComments, List<SqlSingleStatement> results, List<String> innerComments, Ref.BooleanRef readingStmt, int endIdx) {
        Object object = stmtStart.element;
        Intrinsics.checkNotNull((Object)object);
        String string = $sql.substring(((Number)object).intValue(), endIdx);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String rawSql = string;
        if (!((Collection)pendingTopComments).isEmpty()) {
            topComments.addAll(0, (Collection<String>)pendingTopComments);
            pendingTopComments.clear();
        }
        ((Collection)results).add(new SqlSingleStatement(CollectionsKt.toList((Iterable)topComments), CollectionsKt.toList((Iterable)innerComments), rawSql));
        topComments.clear();
        innerComments.clear();
        stmtStart.element = null;
        readingStmt.element = false;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[State.values().length];
            try {
                nArray[State.OUTSIDE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.LINE_COMMENT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.BLOCK_COMMENT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.SINGLE_QUOTE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.DOUBLE_QUOTE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

