/*
 * Decompiled with CFR 0.152.
 */
package dev.goquick.sqlitenow.gradle.generator.query;

import com.squareup.kotlinpoet.FunSpec;
import dev.goquick.sqlitenow.gradle.generator.query.ParameterBinding;
import dev.goquick.sqlitenow.gradle.generator.query.QueryFunctionScaffolder;
import dev.goquick.sqlitenow.gradle.model.AnnotatedStatement;
import dev.goquick.sqlitenow.gradle.processing.StatementUtils;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ(\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ldev/goquick/sqlitenow/gradle/generator/query/QueryBindEmitter;", "", "parameterBinding", "Ldev/goquick/sqlitenow/gradle/generator/query/ParameterBinding;", "scaffolder", "Ldev/goquick/sqlitenow/gradle/generator/query/QueryFunctionScaffolder;", "debug", "", "<init>", "(Ldev/goquick/sqlitenow/gradle/generator/query/ParameterBinding;Ldev/goquick/sqlitenow/gradle/generator/query/QueryFunctionScaffolder;Z)V", "generateBindStatementParamsFunction", "Lcom/squareup/kotlinpoet/FunSpec;", "namespace", "", "statement", "Ldev/goquick/sqlitenow/gradle/model/AnnotatedStatement;", "addBindStatementParamsProcessing", "", "fnBld", "Lcom/squareup/kotlinpoet/FunSpec$Builder;", "className", "sqlitenow-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nQueryBindEmitter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QueryBindEmitter.kt\ndev/goquick/sqlitenow/gradle/generator/query/QueryBindEmitter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,89:1\n1872#2,3:90\n*S KotlinDebug\n*F\n+ 1 QueryBindEmitter.kt\ndev/goquick/sqlitenow/gradle/generator/query/QueryBindEmitter\n*L\n66#1:90,3\n*E\n"})
public final class QueryBindEmitter {
    @NotNull
    private final ParameterBinding parameterBinding;
    @NotNull
    private final QueryFunctionScaffolder scaffolder;
    private final boolean debug;

    public QueryBindEmitter(@NotNull ParameterBinding parameterBinding, @NotNull QueryFunctionScaffolder scaffolder, boolean debug) {
        Intrinsics.checkNotNullParameter((Object)parameterBinding, (String)"parameterBinding");
        Intrinsics.checkNotNullParameter((Object)scaffolder, (String)"scaffolder");
        this.parameterBinding = parameterBinding;
        this.scaffolder = scaffolder;
        this.debug = debug;
    }

    @NotNull
    public final FunSpec generateBindStatementParamsFunction(@NotNull String namespace, @NotNull AnnotatedStatement statement) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        String className = statement.getDataClassName();
        FunSpec.Builder fnBld = FunSpec.Companion.builder("bindStatementParams").addKdoc("Binds parameters to an already prepared SQLiteStatement for the " + statement.getName() + " query.", new Object[0]);
        this.scaffolder.setupStatementFunctionStructure(fnBld, statement, namespace, className, true, QueryFunctionScaffolder.AdapterType.PARAMETER_BINDING);
        FunSpec.Builder.returns$default((FunSpec.Builder)fnBld, (KClass)Reflection.getOrCreateKotlinClass(Unit.class), null, (int)2, null);
        this.addBindStatementParamsProcessing(fnBld, statement, namespace, className);
        return fnBld.build();
    }

    /*
     * WARNING - void declaration
     */
    private final void addBindStatementParamsProcessing(FunSpec.Builder fnBld, AnnotatedStatement statement, String namespace, String className) {
        List<String> namedParameters = StatementUtils.INSTANCE.getNamedParameters(statement);
        if (namedParameters.isEmpty()) {
            return;
        }
        if (this.debug) {
            fnBld.addStatement("val __paramsLog = mutableListOf<String>()", new Object[0]);
            fnBld.addStatement("val __seenParams = mutableSetOf<String>()", new Object[0]);
        }
        Map processedAdapterVars = new LinkedHashMap();
        Iterable $this$forEachIndexed$iv = namedParameters;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void paramName;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int index = n;
            boolean bl = false;
            String propertyName = statement.getAnnotations().getPropertyNameGenerator().convertToPropertyName((String)paramName);
            this.parameterBinding.generateParameterBinding(fnBld, (String)paramName, index, propertyName, statement, namespace, className, processedAdapterVars);
        }
        if (this.debug) {
            Object[] objectArray = new Object[]{"bind " + this.scaffolder.queryNamespaceName(namespace) + "." + className + " params: ", ", "};
            fnBld.addStatement("sqliteNowLogger.d { %S + __paramsLog.joinToString(%S) }", objectArray);
        }
    }
}

