/*
 * Decompiled with CFR 0.152.
 */
package dev.goquick.sqlitenow.gradle.util;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Ldev/goquick/sqlitenow/gradle/util/GenericTypeParser;", "", "<init>", "()V", "Companion", "sqlitenow-gradle-plugin"})
public final class GenericTypeParser {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b2\u0006\u0010\u0006\u001a\u00020\u0005J\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0005J\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\b2\u0006\u0010\r\u001a\u00020\u0005\u00a8\u0006\u000e"}, d2={"Ldev/goquick/sqlitenow/gradle/util/GenericTypeParser$Companion;", "", "<init>", "()V", "extractFirstTypeArgument", "", "typeString", "extractTypeArguments", "", "extractRawTypeName", "isGenericType", "", "parseTypeArguments", "typeArgumentsString", "sqlitenow-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String extractFirstTypeArgument(@NotNull String typeString) {
            Intrinsics.checkNotNullParameter((Object)typeString, (String)"typeString");
            String trimmed = ((Object)StringsKt.trim((CharSequence)typeString)).toString();
            if (!this.isGenericType(trimmed)) {
                return trimmed;
            }
            List<String> typeArguments = this.extractTypeArguments(trimmed);
            String string = (String)CollectionsKt.firstOrNull(typeArguments);
            if (string == null) {
                string = trimmed;
            }
            return string;
        }

        @NotNull
        public final List<String> extractTypeArguments(@NotNull String typeString) {
            Intrinsics.checkNotNullParameter((Object)typeString, (String)"typeString");
            String trimmed = ((Object)StringsKt.trim((CharSequence)typeString)).toString();
            if (!this.isGenericType(trimmed)) {
                return CollectionsKt.emptyList();
            }
            int openBracket = StringsKt.indexOf$default((CharSequence)trimmed, (char)'<', (int)0, (boolean)false, (int)6, null);
            int closeBracket = StringsKt.lastIndexOf$default((CharSequence)trimmed, (char)'>', (int)0, (boolean)false, (int)6, null);
            if (openBracket == -1 || closeBracket == -1 || openBracket >= closeBracket) {
                return CollectionsKt.emptyList();
            }
            String string = trimmed.substring(openBracket + 1, closeBracket);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String typeArgumentsString = ((Object)StringsKt.trim((CharSequence)string)).toString();
            return this.parseTypeArguments(typeArgumentsString);
        }

        @NotNull
        public final String extractRawTypeName(@NotNull String typeString) {
            String string;
            Intrinsics.checkNotNullParameter((Object)typeString, (String)"typeString");
            String trimmed = ((Object)StringsKt.trim((CharSequence)typeString)).toString();
            if (!this.isGenericType(trimmed)) {
                return trimmed;
            }
            int openBracket = StringsKt.indexOf$default((CharSequence)trimmed, (char)'<', (int)0, (boolean)false, (int)6, null);
            if (openBracket > 0) {
                String string2 = trimmed.substring(0, openBracket);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                string = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            } else {
                string = trimmed;
            }
            return string;
        }

        public final boolean isGenericType(@NotNull String typeString) {
            Intrinsics.checkNotNullParameter((Object)typeString, (String)"typeString");
            String trimmed = ((Object)StringsKt.trim((CharSequence)typeString)).toString();
            if (!StringsKt.contains$default((CharSequence)trimmed, (char)'<', (boolean)false, (int)2, null) || !StringsKt.contains$default((CharSequence)trimmed, (char)'>', (boolean)false, (int)2, null)) {
                return false;
            }
            int openBracket = StringsKt.indexOf$default((CharSequence)trimmed, (char)'<', (int)0, (boolean)false, (int)6, null);
            int closeBracket = StringsKt.lastIndexOf$default((CharSequence)trimmed, (char)'>', (int)0, (boolean)false, (int)6, null);
            return openBracket != -1 && closeBracket != -1 && openBracket < closeBracket;
        }

        @NotNull
        public final List<String> parseTypeArguments(@NotNull String typeArgumentsString) {
            Intrinsics.checkNotNullParameter((Object)typeArgumentsString, (String)"typeArgumentsString");
            if (StringsKt.isBlank((CharSequence)typeArgumentsString)) {
                return CollectionsKt.emptyList();
            }
            List arguments = new ArrayList();
            StringBuilder currentArg = new StringBuilder();
            int bracketDepth = 0;
            int n = typeArgumentsString.length();
            block5: for (int i = 0; i < n; ++i) {
                char c = typeArgumentsString.charAt(i);
                switch (c) {
                    case '<': {
                        ++bracketDepth;
                        StringBuilder stringBuilder = currentArg.append(c);
                        continue block5;
                    }
                    case '>': {
                        --bracketDepth;
                        StringBuilder stringBuilder = currentArg.append(c);
                        continue block5;
                    }
                    case ',': {
                        StringBuilder stringBuilder;
                        if (bracketDepth == 0) {
                            String string = currentArg.toString();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                            String argString = ((Object)StringsKt.trim((CharSequence)string)).toString();
                            if (((CharSequence)argString).length() > 0) {
                                arguments.add(argString);
                            }
                            stringBuilder = StringsKt.clear((StringBuilder)currentArg);
                            continue block5;
                        }
                        stringBuilder = currentArg.append(c);
                        continue block5;
                    }
                    default: {
                        StringBuilder stringBuilder = currentArg.append(c);
                    }
                }
            }
            String string = currentArg.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String lastArgString = ((Object)StringsKt.trim((CharSequence)string)).toString();
            if (((CharSequence)lastArgString).length() > 0) {
                arguments.add(lastArgString);
            }
            return arguments;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

