/*
 * Decompiled with CFR 0.152.
 */
package dev.goquick.sqlitenow.gradle.processing;

import dev.goquick.sqlitenow.gradle.LoggerKt;
import dev.goquick.sqlitenow.gradle.SqlFileProcessor;
import dev.goquick.sqlitenow.gradle.model.AnnotatedCreateViewStatement;
import dev.goquick.sqlitenow.gradle.model.AnnotatedExecuteStatement;
import dev.goquick.sqlitenow.gradle.model.AnnotatedSelectStatement;
import dev.goquick.sqlitenow.gradle.model.AnnotatedStatement;
import dev.goquick.sqlitenow.gradle.processing.AnnotationsKt;
import dev.goquick.sqlitenow.gradle.processing.DynamicFieldMapper;
import dev.goquick.sqlitenow.gradle.processing.FieldAnnotationMerger;
import dev.goquick.sqlitenow.gradle.processing.FieldAnnotationOverrides;
import dev.goquick.sqlitenow.gradle.processing.FieldAnnotationResolver;
import dev.goquick.sqlitenow.gradle.processing.StatementAnnotationOverrides;
import dev.goquick.sqlitenow.gradle.processing.StatementProcessingHelperKt;
import dev.goquick.sqlitenow.gradle.sqlinspect.DeleteStatement;
import dev.goquick.sqlitenow.gradle.sqlinspect.ExecuteStatement;
import dev.goquick.sqlitenow.gradle.sqlinspect.InsertStatement;
import dev.goquick.sqlitenow.gradle.sqlinspect.SelectStatement;
import dev.goquick.sqlitenow.gradle.sqlinspect.UpdateStatement;
import dev.goquick.sqlitenow.gradle.sqlite.SqlSingleStatement;
import dev.goquick.sqlitenow.gradle.util.AliasPathUtils;
import java.io.File;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.update.Update;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u00018B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\t2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000eJ\"\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u000b0\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000b2\u0006\u0010\u0016\u001a\u00020\nH\u0002J(\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u000eH\u0002J \u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\n0\u000b2\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\nH\u0002J\u001e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\n0\u000b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010#\u001a\u00020\nH\u0002J*\u0010$\u001a\b\u0012\u0004\u0012\u00020\n0\u000b2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\n0\u000b2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\n0\u000bH\u0002J\u0018\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020 H\u0002J,\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u000b2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u00052\f\u00100\u001a\b\u0012\u0004\u0012\u00020\n0\u000bH\u0002J(\u00101\u001a\u0002022\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u000eH\u0002JD\u00103\u001a\u0002042\u0006\u0010)\u001a\u00020(2 \u00105\u001a\u001c\u0012\u0004\u0012\u00020\n\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\t0\t2\u0006\u0010\u001f\u001a\u00020 2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002J\u0010\u00106\u001a\u00020\n2\u0006\u00107\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Ldev/goquick/sqlitenow/gradle/processing/StatementProcessingHelper;", "", "conn", "Ljava/sql/Connection;", "annotationResolver", "Ldev/goquick/sqlitenow/gradle/processing/FieldAnnotationResolver;", "<init>", "(Ljava/sql/Connection;Ldev/goquick/sqlitenow/gradle/processing/FieldAnnotationResolver;)V", "processQueriesDirectory", "", "", "", "Ldev/goquick/sqlitenow/gradle/model/AnnotatedStatement;", "queriesDir", "Ljava/io/File;", "processQueryFile", "file", "scanQueriesByNamespace", "validateSqlStatements", "", "sqlStatements", "Ldev/goquick/sqlitenow/gradle/sqlite/SqlSingleStatement;", "fileName", "createAnnotatedSelectStatement", "Ldev/goquick/sqlitenow/gradle/model/AnnotatedSelectStatement;", "stmtName", "parsedStatement", "Lnet/sf/jsqlparser/statement/select/PlainSelect;", "sqlStatement", "sourceFile", "computeAliasPathForSelectField", "selectStatement", "Ldev/goquick/sqlitenow/gradle/sqlinspect/SelectStatement;", "sourceAlias", "computeAliasPathForAlias", "alias", "mergeAliasPaths", "prefix", "suffix", "enrichFieldSourceWithViewExpression", "Ldev/goquick/sqlitenow/gradle/sqlinspect/SelectStatement$FieldSource;", "column", "stmt", "collectTransitiveDynamicFields", "Ldev/goquick/sqlitenow/gradle/processing/StatementProcessingHelper$DynamicFieldDescriptor;", "view", "Ldev/goquick/sqlitenow/gradle/model/AnnotatedCreateViewStatement;", "resolver", "aliasPath", "createAnnotatedExecuteStatement", "Ldev/goquick/sqlitenow/gradle/model/AnnotatedExecuteStatement;", "mergeFieldAnnotations", "Ldev/goquick/sqlitenow/gradle/processing/FieldAnnotationOverrides;", "selectFieldAnnotations", "normalizeSelectForParser", "sql", "DynamicFieldDescriptor", "sqlitenow-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nStatementProcessingHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StatementProcessingHelper.kt\ndev/goquick/sqlitenow/gradle/processing/StatementProcessingHelper\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,575:1\n126#2:576\n153#2,2:577\n155#2:583\n216#2,2:600\n216#2:606\n217#2:620\n216#2,2:669\n1557#3:579\n1628#3,3:580\n1053#3:587\n1187#3,2:588\n1261#3,2:590\n1053#3:595\n1264#3:596\n1863#3:597\n1864#3:599\n1557#3:602\n1628#3,3:603\n1557#3:607\n1628#3,3:608\n1557#3:611\n1628#3,3:612\n1863#3:615\n1755#3,3:616\n1864#3:619\n1368#3:621\n1454#3,2:622\n1557#3:624\n1628#3,3:625\n1456#3,3:628\n1498#3:631\n1528#3,3:632\n1531#3,3:642\n1246#3,4:647\n1872#3,3:651\n1755#3,3:654\n1863#3,2:657\n1863#3,2:659\n1863#3,2:661\n1863#3:663\n295#3,2:664\n1864#3:666\n1863#3,2:667\n1863#3:671\n295#3,2:672\n295#3,2:674\n1864#3:676\n3829#4:584\n4344#4,2:585\n3829#4:592\n4344#4,2:593\n1#5:598\n381#6,7:635\n462#6:645\n412#6:646\n*S KotlinDebug\n*F\n+ 1 StatementProcessingHelper.kt\ndev/goquick/sqlitenow/gradle/processing/StatementProcessingHelper\n*L\n58#1:576\n58#1:577,2\n58#1:583\n210#1:600,2\n237#1:606\n237#1:620\n453#1:669,2\n59#1:579\n59#1:580,3\n129#1:587\n130#1:588,2\n130#1:590,2\n135#1:595\n130#1:596\n180#1:597\n180#1:599\n235#1:602\n235#1:603,3\n249#1:607\n249#1:608,3\n258#1:611\n258#1:612,3\n260#1:615\n263#1:616,3\n260#1:619\n295#1:621\n295#1:622,2\n296#1:624\n296#1:625,3\n295#1:628,3\n298#1:631\n298#1:632,3\n298#1:642,3\n299#1:647,4\n301#1:651,3\n313#1:654,3\n397#1:657,2\n415#1:659,2\n418#1:661,2\n423#1:663\n425#1:664,2\n423#1:666\n444#1:667,2\n523#1:671\n534#1:672,2\n537#1:674,2\n523#1:676\n127#1:584\n127#1:585,2\n133#1:592\n133#1:593,2\n298#1:635,7\n299#1:645\n299#1:646\n*E\n"})
public final class StatementProcessingHelper {
    @NotNull
    private final Connection conn;
    @Nullable
    private final FieldAnnotationResolver annotationResolver;

    public StatementProcessingHelper(@NotNull Connection conn, @Nullable FieldAnnotationResolver annotationResolver) {
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        this.conn = conn;
        this.annotationResolver = annotationResolver;
    }

    public /* synthetic */ StatementProcessingHelper(Connection connection, FieldAnnotationResolver fieldAnnotationResolver, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            fieldAnnotationResolver = null;
        }
        this(connection, fieldAnnotationResolver);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, List<AnnotatedStatement>> processQueriesDirectory(@NotNull File queriesDir) {
        void $this$mapTo$iv$iv;
        Map<String, List<File>> nsWithFiles;
        Intrinsics.checkNotNullParameter((Object)queriesDir, (String)"queriesDir");
        Map<String, List<File>> $this$map$iv = nsWithFiles = this.scanQueriesByNamespace(queriesDir);
        boolean $i$f$map = false;
        Map<String, List<File>> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String namespace = (String)entry.getKey();
            List files = (List)entry.getValue();
            Iterable iterable = files;
            String string = namespace;
            boolean $i$f$map2 = false;
            void var17_17 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                AnnotatedStatement annotatedStatement;
                void file;
                File file2 = (File)item$iv$iv2;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                try {
                    annotatedStatement = this.processQueryFile((File)file);
                }
                catch (Exception e) {
                    LoggerKt.getLogger().error("*** FAILED TO PROCESS SQL FILE ***");
                    LoggerKt.getLogger().error("File: " + file.getAbsolutePath());
                    LoggerKt.getLogger().error("Namespace: " + namespace);
                    LoggerKt.getLogger().error("Error: " + e.getMessage());
                    if (e.getCause() != null) {
                        Throwable throwable = e.getCause();
                        LoggerKt.getLogger().error("Caused by: " + (throwable != null ? throwable.getMessage() : null));
                    }
                    throw new RuntimeException("Failed to process SQL file '" + file.getName() + "' in namespace '" + namespace + "'", e);
                }
                collection2.add(annotatedStatement);
            }
            collection.add(TuplesKt.to((Object)string, (Object)((List)destination$iv$iv2)));
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public final AnnotatedStatement processQueryFile(@NotNull File file) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String stmtName = FilesKt.getNameWithoutExtension((File)file);
        List<SqlSingleStatement> sqlStatements = SqlFileProcessor.INSTANCE.parseAllSqlFiles(CollectionsKt.listOf((Object)file));
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this.validateSqlStatements(sqlStatements, string);
        SqlSingleStatement sqlStatement = (SqlSingleStatement)CollectionsKt.first(sqlStatements);
        Statement parsedStatement = CCJSqlParserUtil.parse((String)this.normalizeSelectForParser(sqlStatement.getSql()));
        try {
            AnnotatedStatement annotatedStatement;
            object = parsedStatement;
            if (object instanceof PlainSelect) {
                annotatedStatement = this.createAnnotatedSelectStatement(stmtName, (PlainSelect)parsedStatement, sqlStatement, file);
            } else if (object instanceof Insert || object instanceof Delete || object instanceof Update) {
                annotatedStatement = this.createAnnotatedExecuteStatement(stmtName, parsedStatement, sqlStatement, file);
            } else {
                throw new RuntimeException("Unsupported statement type in " + file.getName());
            }
            object = annotatedStatement;
        }
        catch (Exception e) {
            LoggerKt.getLogger().error("Failed to process SQL statement in file: " + file.getAbsolutePath());
            LoggerKt.getLogger().error("Statement name: " + stmtName);
            LoggerKt.getLogger().error("SQL content:");
            LoggerKt.getLogger().error(CollectionsKt.joinToString$default((Iterable)sqlStatement.getTopComments(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
            LoggerKt.getLogger().error(sqlStatement.getSql());
            LoggerKt.getLogger().error("Parse error: " + e.getMessage());
            throw new RuntimeException("Failed to parse SQL statement '" + stmtName + "' in file '" + file.getName() + "'", e);
        }
        return object;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Map<String, List<File>> scanQueriesByNamespace(File queriesDir) {
        block9: {
            block8: {
                if (!queriesDir.exists() || !queriesDir.isDirectory()) {
                    return MapsKt.emptyMap();
                }
                var2_2 = queriesDir.listFiles();
                if (var2_2 == null) break block8;
                $this$filter$iv = var2_2;
                $i$f$filter = false;
                var5_6 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                var9_14 = ((void)$this$filterTo$iv$iv).length;
                for (var8_12 = 0; var8_12 < var9_14; ++var8_12) {
                    it = element$iv$iv = $this$filterTo$iv$iv[var8_12];
                    $i$a$-filter-StatementProcessingHelper$scanQueriesByNamespace$1 = false;
                    if (!it.isDirectory()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $i$f$filter = (List)destination$iv$iv;
                $i$f$sortedBy = false;
                var3_3 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        File it = (File)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)it.getName());
                        it = (File)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
                    }
                });
                if (var3_3 == null) break block8;
                $i$f$sortedBy = var3_3;
                $i$f$associate = false;
                capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                var8_13 = $this$associate$iv;
                destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                $i$f$associateTo = false;
                for (T element$iv$iv : $this$associateTo$iv$iv) {
                    var13_21 = destination$iv$iv;
                    namespaceDir = (File)element$iv$iv;
                    $i$a$-associate-StatementProcessingHelper$scanQueriesByNamespace$3 = false;
                    namespace = namespaceDir.getName();
                    var17_25 = namespaceDir.listFiles();
                    if (var17_25 == null) ** GOTO lbl-1000
                    var18_26 /* !! */  = var17_25;
                    $i$f$filter = false;
                    var20_30 = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterTo = false;
                    var24_34 = ((void)$this$filterTo$iv$iv).length;
                    for (var23_33 = 0; var23_33 < var24_34; ++var23_33) {
                        it = element$iv$iv = $this$filterTo$iv$iv[var23_33];
                        $i$a$-filter-StatementProcessingHelper$scanQueriesByNamespace$3$sqlFiles$1 = false;
                        if (!it.isFile()) ** GOTO lbl-1000
                        Intrinsics.checkNotNull((Object)it);
                        if (Intrinsics.areEqual((Object)FilesKt.getExtension((File)it), (Object)"sql")) {
                            v0 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v0 = false;
                        }
                        if (!v0) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $i$f$filter = (List)destination$iv$iv;
                    $i$f$sortedBy = false;
                    var18_26 /* !! */  = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            File it = (File)a;
                            boolean bl = false;
                            Comparable comparable = (Comparable)((Object)it.getName());
                            it = (File)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
                        }
                    });
                    if (var18_26 /* !! */  != null) {
                        v1 /* !! */  = var18_26 /* !! */ ;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 /* !! */  = CollectionsKt.emptyList();
                    }
                    sqlFiles = v1 /* !! */ ;
                    var14_22 = TuplesKt.to((Object)namespace, (Object)sqlFiles);
                    var13_21.put(var14_22.getFirst(), var14_22.getSecond());
                }
                v2 = destination$iv$iv;
                break block9;
            }
            v2 = MapsKt.emptyMap();
        }
        return v2;
    }

    private final void validateSqlStatements(List<SqlSingleStatement> sqlStatements, String fileName) {
        if (sqlStatements.isEmpty()) {
            throw new RuntimeException("No SQL statements found in file: " + fileName);
        }
        if (sqlStatements.size() > 1) {
            throw new RuntimeException("Only one SQL statement per file is supported: " + fileName);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final AnnotatedSelectStatement createAnnotatedSelectStatement(String stmtName, PlainSelect parsedStatement, SqlSingleStatement sqlStatement, File sourceFile) {
        boolean bl;
        List dynamicFields;
        List fields;
        StatementAnnotationOverrides statementAnnotations;
        SelectStatement stmt;
        block39: {
            void $this$mapValues$iv;
            Object value$iv$iv$iv;
            Iterator $this$groupBy$iv;
            Object list$iv$iv;
            Iterable $this$flatMap$iv;
            SelectStatement.FieldSource element$iv;
            Iterable containerPaths;
            Object object;
            Object dummyFieldSource;
            Object columnWithNullability;
            String it;
            Object element$iv22;
            stmt = SelectStatement.Companion.parse(this.conn, parsedStatement);
            statementAnnotations = null;
            statementAnnotations = StatementAnnotationOverrides.Companion.parse$default(StatementAnnotationOverrides.Companion, AnnotationsKt.extractAnnotations(sqlStatement.getTopComments()), null, 2, null);
            Map<String, Map<String, Object>> fieldAnnotations = AnnotationsKt.extractFieldAssociatedAnnotations(sqlStatement.getInnerComments());
            fields = new ArrayList();
            Iterable $this$forEach$iv = stmt.getFields();
            boolean $i$f$forEach = false;
            for (Object element$iv22 : $this$forEach$iv) {
                Object object2;
                FieldAnnotationOverrides annotations;
                block43: {
                    block42: {
                        Object object3;
                        Boolean bl2;
                        Object columnWithHint;
                        SelectStatement.FieldSource fieldSource;
                        block41: {
                            Object object4;
                            SelectStatement.FieldSource enrichedColumn;
                            block40: {
                                String string;
                                fieldSource = (SelectStatement.FieldSource)element$iv22;
                                boolean bl3 = false;
                                enrichedColumn = this.enrichFieldSourceWithViewExpression(fieldSource, stmt);
                                annotations = this.mergeFieldAnnotations(enrichedColumn, fieldAnnotations, stmt, this.annotationResolver);
                                object4 = annotations.getSqlTypeHint();
                                if (object4 == null) break block40;
                                it = string = object4;
                                boolean bl4 = false;
                                object4 = !StringsKt.isBlank((CharSequence)it) ? string : null;
                                if (object4 == null) break block40;
                                Object hint = object4;
                                boolean bl5 = false;
                                Object object5 = hint;
                                Locale locale = Locale.ROOT;
                                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
                                String string2 = ((String)object5).toUpperCase(locale);
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
                                SelectStatement.FieldSource fieldSource2 = SelectStatement.FieldSource.copy$default(enrichedColumn, null, null, null, string2, null, false, 55, null);
                                object4 = fieldSource2;
                                if (fieldSource2 != null) break block41;
                            }
                            object4 = columnWithHint = enrichedColumn;
                        }
                        if (Intrinsics.areEqual((Object)(bl2 = annotations.getNotNull()), (Object)true)) {
                            object3 = SelectStatement.FieldSource.copy$default((SelectStatement.FieldSource)columnWithHint, null, null, null, null, null, false, 31, null);
                        } else if (Intrinsics.areEqual((Object)bl2, (Object)false)) {
                            object3 = SelectStatement.FieldSource.copy$default((SelectStatement.FieldSource)columnWithHint, null, null, null, null, null, true, 31, null);
                        } else if (bl2 == null) {
                            object3 = columnWithHint;
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                        columnWithNullability = object3;
                        String it2 = it = fieldSource.getTableName();
                        boolean bl6 = false;
                        object2 = !StringsKt.isBlank((CharSequence)it2) ? it : null;
                        if (object2 == null) break block42;
                        String alias = object2;
                        boolean bl7 = false;
                        List<String> list = this.computeAliasPathForAlias(stmt, alias);
                        object2 = list;
                        if (list != null) break block43;
                    }
                    object2 = CollectionsKt.emptyList();
                }
                List<String> aliasPath = object2;
                fields.add(new AnnotatedSelectStatement.Field((SelectStatement.FieldSource)columnWithNullability, annotations, aliasPath));
            }
            dynamicFields = new ArrayList();
            Map<String, Map<String, Object>> $this$forEach$iv2 = fieldAnnotations;
            boolean $i$f$forEach2 = false;
            element$iv22 = $this$forEach$iv2.entrySet().iterator();
            while (element$iv22.hasNext()) {
                Map.Entry entry;
                Map.Entry bl3 = entry = (Map.Entry)element$iv22.next();
                boolean bl8 = false;
                String fieldName = (String)bl3.getKey();
                Map annotations = (Map)bl3.getValue();
                if (!Intrinsics.areEqual(annotations.get("_isDynamicField"), (Object)true)) continue;
                dummyFieldSource = new SelectStatement.FieldSource(fieldName, "", fieldName, "DYNAMIC", null, false, 32, null);
                FieldAnnotationOverrides fieldAnnotationOverrides = FieldAnnotationOverrides.Companion.parse(annotations);
                List<String> aliasPath = this.computeAliasPathForSelectField(stmt, fieldAnnotationOverrides.getSourceTable());
                AnnotatedSelectStatement.Field dynamicField = new AnnotatedSelectStatement.Field((SelectStatement.FieldSource)dummyFieldSource, fieldAnnotationOverrides, aliasPath);
                dynamicFields.add(dynamicField);
                fields.add(dynamicField);
            }
            if (this.annotationResolver != null) {
                Iterable $this$map$iv = dynamicFields;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo22 = false;
                for (Object item$iv$iv : iterable) {
                    dummyFieldSource = (AnnotatedSelectStatement.Field)item$iv$iv;
                    object = destination$iv$iv;
                    boolean bl9 = false;
                    object.add(((AnnotatedSelectStatement.Field)((Object)it)).getSrc().getFieldName());
                }
                Set declaredDynamicNames = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
                Map<String, String> $this$forEach$iv3 = stmt.getTableAliases();
                boolean $i$f$forEach3 = false;
                Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv3.entrySet().iterator();
                while (iterator.hasNext()) {
                    Iterator $this$mapTo$iv$iv2;
                    List mergedAliasPath;
                    Iterator df;
                    Collection collection;
                    void $this$mapTo$iv$iv3;
                    Map.Entry<String, String> element$iv4;
                    Map.Entry<String, String> $i$f$mapTo22 = element$iv4 = iterator.next();
                    boolean bl10 = false;
                    String alias = $i$f$mapTo22.getKey();
                    String tableOrViewName = $i$f$mapTo22.getValue();
                    AnnotatedCreateViewStatement view = this.annotationResolver.findView(tableOrViewName);
                    if (view == null) continue;
                    if (statementAnnotations.getCollectionKey() == null && view.getAnnotations().getCollectionKey() != null) {
                        statementAnnotations = StatementAnnotationOverrides.copy$default(statementAnnotations, null, null, null, view.getAnnotations().getCollectionKey(), false, null, null, null, 247, null);
                    }
                    List<DynamicFieldDescriptor> inheritedDynamicFields = this.collectTransitiveDynamicFields(view, this.annotationResolver, CollectionsKt.emptyList());
                    List<String> aliasPrefix = this.computeAliasPathForAlias(stmt, alias);
                    Iterable $this$map$iv2 = inheritedDynamicFields;
                    boolean $i$f$map2 = false;
                    columnWithNullability = $this$map$iv2;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo2232 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                        DynamicFieldDescriptor dynamicFieldDescriptor = (DynamicFieldDescriptor)item$iv$iv;
                        collection = destination$iv$iv2;
                        boolean bl11 = false;
                        mergedAliasPath = this.mergeAliasPaths(aliasPrefix, ((DynamicFieldDescriptor)((Object)df)).getAliasPath());
                        collection.add(TuplesKt.to((Object)df, mergedAliasPath));
                    }
                    List preparedDynamicFields = (List)destination$iv$iv2;
                    Iterable $this$map$iv3 = containerPaths = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)preparedDynamicFields), StatementProcessingHelper::createAnnotatedSelectStatement$lambda$3$1), StatementProcessingHelper::createAnnotatedSelectStatement$lambda$3$2), StatementProcessingHelper::createAnnotatedSelectStatement$lambda$3$3));
                    boolean $i$f$map3 = false;
                    Iterable $i$f$mapTo2232 = $this$map$iv3;
                    Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                    boolean $i$f$mapTo3 = false;
                    df = $this$mapTo$iv$iv2.iterator();
                    while (df.hasNext()) {
                        void it3;
                        Object item$iv$iv = df.next();
                        mergedAliasPath = (List)item$iv$iv;
                        collection = destination$iv$iv3;
                        boolean bl12 = false;
                        collection.add(AliasPathUtils.INSTANCE.lowercase((List<String>)it3));
                    }
                    List containerPathsLower = (List)destination$iv$iv3;
                    Iterable $this$forEach$iv4 = preparedDynamicFields;
                    boolean $i$f$forEach4 = false;
                    $this$mapTo$iv$iv2 = $this$forEach$iv4.iterator();
                    while ($this$mapTo$iv$iv2.hasNext()) {
                        boolean bl3;
                        DynamicFieldDescriptor df2;
                        block38: {
                            element$iv = $this$mapTo$iv$iv2.next();
                            Pair pair = (Pair)element$iv;
                            boolean bl14 = false;
                            df2 = (DynamicFieldDescriptor)pair.component1();
                            mergedAliasPath = (List)pair.component2();
                            if (declaredDynamicNames.contains(df2.getName())) continue;
                            List<String> mergedLower = AliasPathUtils.INSTANCE.lowercase(mergedAliasPath);
                            Iterable $this$any$iv = containerPathsLower;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl3 = false;
                            } else {
                                for (Object element$iv5 : $this$any$iv) {
                                    List containerLower = (List)element$iv5;
                                    boolean bl15 = false;
                                    if (!(mergedLower.size() > containerLower.size() && AliasPathUtils.INSTANCE.startsWith(mergedLower, containerLower))) continue;
                                    bl3 = true;
                                    break block38;
                                }
                                bl3 = false;
                            }
                        }
                        boolean hasContainerAncestor = bl3;
                        FieldAnnotationOverrides adapted = FieldAnnotationOverrides.copy$default(df2.getAnnotations(), null, null, null, null, false, null, null, null, alias, null, null, df2.getAnnotations().getSuppressProperty() || hasContainerAncestor, 1791, null);
                        SelectStatement.FieldSource dummyFieldSource2 = new SelectStatement.FieldSource(df2.getName(), "", df2.getName(), "DYNAMIC", null, false, 32, null);
                        AnnotatedSelectStatement.Field dynField = new AnnotatedSelectStatement.Field(dummyFieldSource2, adapted, mergedAliasPath);
                        dynamicFields.add(dynField);
                        fields.add(dynField);
                        declaredDynamicNames.add(df2.getName());
                    }
                }
            }
            Iterable $this$forEach$iv3 = DynamicFieldMapper.Companion.createDynamicFieldMappings(stmt, fields);
            boolean $i$f$flatMap = false;
            void var13_25 = $this$flatMap$iv;
            Iterator destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : var13_25) {
                void $this$mapTo$iv$iv4;
                DynamicFieldMapper.DynamicFieldMapping mapping = (DynamicFieldMapper.DynamicFieldMapping)element$iv$iv;
                boolean bl16 = false;
                Iterable $this$map$iv = mapping.getColumns();
                boolean $i$f$map = false;
                containerPaths = $this$map$iv;
                Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv4) {
                    void column;
                    element$iv = (SelectStatement.FieldSource)item$iv$iv;
                    Collection collection = destination$iv$iv4;
                    boolean bl17 = false;
                    collection.add(TuplesKt.to((Object)column.getFieldName(), mapping.getAliasPath()));
                }
                list$iv$iv = (List)destination$iv$iv4;
                CollectionsKt.addAll((Collection)((Object)destination$iv$iv), (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)((Object)destination$iv$iv);
            boolean $i$f$groupBy = false;
            void var13_26 = $this$groupBy$iv;
            destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : var13_26) {
                void it4;
                Object object6;
                it = (Pair)element$iv$iv;
                boolean $i$a$-groupBy-StatementProcessingHelper$createAnnotatedSelectStatement$aliasPathHints$432 = false;
                String key$iv$iv = (String)it.getFirst();
                Iterator $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl18 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object6 = answer$iv$iv$iv;
                } else {
                    object6 = value$iv$iv$iv;
                }
                list$iv$iv = (List)object6;
                Pair $i$a$-groupBy-StatementProcessingHelper$createAnnotatedSelectStatement$aliasPathHints$432 = (Pair)element$iv$iv;
                object = list$iv$iv;
                boolean bl19 = false;
                object.add((List)it4.getSecond());
            }
            $this$groupBy$iv = destination$iv$iv;
            boolean $i$f$mapValues = false;
            void var13_27 = $this$mapValues$iv;
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = var13_27.entrySet();
            boolean $i$f$associateByTo22 = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void entry;
                void it$iv$iv;
                Map.Entry key$iv$iv = (Map.Entry)element$iv$iv$iv;
                Iterator $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean bl20 = false;
                value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                object = $this$getOrPut$iv$iv$iv;
                boolean bl21 = false;
                List list = CollectionsKt.toMutableList((Collection)((Collection)entry.getValue()));
                object.put(k, list);
            }
            Iterator aliasPathHints = destination$iv$iv;
            Iterable $this$forEachIndexed$iv = fields;
            boolean $i$f$forEachIndexed = false;
            boolean bl4 = false;
            for (Object item$iv : $this$forEachIndexed$iv) {
                List queue;
                void field;
                void var13_29;
                if (($this$associateByTo$iv$iv$iv = ++var13_29) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                AnnotatedSelectStatement.Field $i$f$associateByTo22 = (AnnotatedSelectStatement.Field)item$iv;
                void index = $this$associateByTo$iv$iv$iv;
                boolean bl22 = false;
                if (field.getAnnotations().isDynamicField() || !field.getAliasPath().isEmpty()) continue;
                List list = queue = (List)aliasPathHints.get(field.getSrc().getFieldName());
                List hint = list != null ? (List)CollectionsKt.firstOrNull((List)list) : null;
                if (hint == null || !(!((Collection)hint).isEmpty())) continue;
                fields.set((int)index, AnnotatedSelectStatement.Field.copy$default((AnnotatedSelectStatement.Field)field, null, null, hint, 3, null));
                queue.remove(0);
            }
            Iterable $this$any$iv = dynamicFields;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv6 : $this$any$iv) {
                    AnnotatedSelectStatement.Field it5 = (AnnotatedSelectStatement.Field)element$iv6;
                    boolean bl23 = false;
                    if (!(it5.getAnnotations().getMappingType() != null)) continue;
                    bl = true;
                    break block39;
                }
                bl = false;
            }
        }
        if (bl) {
            DynamicFieldMapper.Companion.validateAliasColumnFormat(stmt, dynamicFields);
        }
        return new AnnotatedSelectStatement(stmtName, stmt, statementAnnotations, fields, StatementProcessingHelperKt.access$normalizedPath(sourceFile));
    }

    private final List<String> computeAliasPathForSelectField(SelectStatement selectStatement, String sourceAlias) {
        List list;
        block8: {
            Object object;
            block10: {
                block9: {
                    String primaryAlias;
                    CharSequence charSequence = sourceAlias;
                    if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) break block8;
                    String string = (String)CollectionsKt.firstOrNull((Iterable)selectStatement.getTableAliases().keySet());
                    if (string == null) {
                        string = selectStatement.getFromTable();
                    }
                    if ((object = (primaryAlias = string)) == null) break block9;
                    String it = object;
                    boolean bl = false;
                    List list2 = CollectionsKt.listOf((Object)it);
                    object = list2;
                    if (list2 != null) break block10;
                }
                object = CollectionsKt.emptyList();
            }
            return object;
        }
        List<String> aliasPath = this.computeAliasPathForAlias(selectStatement, sourceAlias);
        if (!((Collection)aliasPath).isEmpty()) {
            return aliasPath;
        }
        String string = (String)CollectionsKt.firstOrNull((Iterable)selectStatement.getTableAliases().keySet());
        if (string == null) {
            string = selectStatement.getFromTable();
        }
        String primaryAlias = string;
        List $this$computeAliasPathForSelectField_u24lambda_u241 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        CharSequence charSequence = primaryAlias;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            $this$computeAliasPathForSelectField_u24lambda_u241.add(primaryAlias);
        }
        if ($this$computeAliasPathForSelectField_u24lambda_u241.isEmpty() || !Intrinsics.areEqual((Object)CollectionsKt.last((List)$this$computeAliasPathForSelectField_u24lambda_u241), (Object)sourceAlias)) {
            $this$computeAliasPathForSelectField_u24lambda_u241.add(sourceAlias);
        }
        return CollectionsKt.build((List)list);
    }

    private final List<String> computeAliasPathForAlias(SelectStatement selectStatement, String alias) {
        List list;
        boolean containsAlias;
        String primaryAlias;
        if (StringsKt.isBlank((CharSequence)alias)) {
            return CollectionsKt.emptyList();
        }
        Map<String, String> tableAliases = selectStatement.getTableAliases();
        String string = (String)CollectionsKt.firstOrNull((Iterable)tableAliases.keySet());
        if (string == null) {
            string = primaryAlias = selectStatement.getFromTable();
        }
        if (!(containsAlias = tableAliases.containsKey(alias))) {
            List list2;
            List $this$computeAliasPathForAlias_u24lambda_u240 = list2 = CollectionsKt.createListBuilder();
            boolean bl = false;
            CharSequence charSequence = primaryAlias;
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                $this$computeAliasPathForAlias_u24lambda_u240.add(primaryAlias);
            }
            if ($this$computeAliasPathForAlias_u24lambda_u240.isEmpty() || !Intrinsics.areEqual((Object)CollectionsKt.last((List)$this$computeAliasPathForAlias_u24lambda_u240), (Object)alias)) {
                $this$computeAliasPathForAlias_u24lambda_u240.add(alias);
            }
            return CollectionsKt.build((List)list2);
        }
        List $this$computeAliasPathForAlias_u24lambda_u241 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        CharSequence charSequence = primaryAlias;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            $this$computeAliasPathForAlias_u24lambda_u241.add(primaryAlias);
        }
        if (!Intrinsics.areEqual((Object)primaryAlias, (Object)alias)) {
            $this$computeAliasPathForAlias_u24lambda_u241.add(alias);
        }
        return CollectionsKt.build((List)list);
    }

    private final List<String> mergeAliasPaths(List<String> prefix, List<String> suffix) {
        if (prefix.isEmpty()) {
            return suffix;
        }
        if (suffix.isEmpty()) {
            return prefix;
        }
        List merged = CollectionsKt.toMutableList((Collection)prefix);
        Iterable $this$forEach$iv = suffix;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String alias = (String)element$iv;
            boolean bl = false;
            if (!merged.isEmpty() && Intrinsics.areEqual((Object)CollectionsKt.last((List)merged), (Object)alias)) continue;
            ((Collection)merged).add(alias);
        }
        return merged;
    }

    private final SelectStatement.FieldSource enrichFieldSourceWithViewExpression(SelectStatement.FieldSource column, SelectStatement stmt) {
        LinkedHashSet<Object> linkedHashSet;
        if (column.getExpression() != null || this.annotationResolver == null) {
            return column;
        }
        LinkedHashSet<Object> $this$enrichFieldSourceWithViewExpression_u24lambda_u240 = linkedHashSet = new LinkedHashSet<Object>();
        boolean bl = false;
        Iterator<Object> iterator = stmt.getFromTable();
        if (iterator != null) {
            Iterator iterator2 = iterator;
            Object it = iterator2;
            boolean bl2 = false;
            iterator = !StringsKt.isBlank((CharSequence)((CharSequence)it)) ? iterator2 : null;
            if (iterator != null) {
                it = iterator;
                boolean bl3 = false;
                $this$enrichFieldSourceWithViewExpression_u24lambda_u240.add(it);
            }
        }
        Iterable $this$forEach$iv = stmt.getTableAliases().values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String value = (String)element$iv;
            boolean bl4 = false;
            if (!(!StringsKt.isBlank((CharSequence)value))) continue;
            $this$enrichFieldSourceWithViewExpression_u24lambda_u240.add(value);
        }
        $this$forEach$iv = stmt.getJoinTables();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String table = (String)element$iv;
            boolean bl5 = false;
            if (!(!StringsKt.isBlank((CharSequence)table))) continue;
            $this$enrichFieldSourceWithViewExpression_u24lambda_u240.add(table);
        }
        LinkedHashSet<Object> candidateViewNames = linkedHashSet;
        Iterable $this$forEach$iv2 = candidateViewNames;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            AnnotatedCreateViewStatement.Field matchedField;
            Object object;
            Object v1;
            block7: {
                AnnotatedCreateViewStatement view;
                String viewName = (String)element$iv;
                boolean bl6 = false;
                if (this.annotationResolver.findView(viewName) == null) continue;
                Iterable $this$firstOrNull$iv = view.getFields();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv2 : $this$firstOrNull$iv) {
                    AnnotatedCreateViewStatement.Field viewField = (AnnotatedCreateViewStatement.Field)element$iv2;
                    boolean bl7 = false;
                    if (!StringsKt.equals((String)viewField.getSrc().getFieldName(), (String)column.getFieldName(), (boolean)true)) continue;
                    v1 = element$iv2;
                    break block7;
                }
                v1 = null;
            }
            if (((object = (matchedField = (AnnotatedCreateViewStatement.Field)v1)) != null && (object = ((AnnotatedCreateViewStatement.Field)object).getSrc()) != null ? ((SelectStatement.FieldSource)object).getExpression() : null) == null) continue;
            return SelectStatement.FieldSource.copy$default(column, null, null, null, null, matchedField.getSrc().getExpression(), false, 47, null);
        }
        return column;
    }

    private final List<DynamicFieldDescriptor> collectTransitiveDynamicFields(AnnotatedCreateViewStatement view, FieldAnnotationResolver resolver, List<String> aliasPath) {
        Object element$iv;
        List result = new ArrayList();
        Object $this$forEach$iv = view.getDynamicFields();
        boolean $i$f$forEach = false;
        Iterator<Object> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            AnnotatedCreateViewStatement.DynamicField df = (AnnotatedCreateViewStatement.DynamicField)element$iv;
            boolean bl = false;
            CharSequence charSequence = df.getAnnotations().getSourceTable();
            List path = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? CollectionsKt.plus((Collection)aliasPath, (Object)df.getAnnotations().getSourceTable()) : aliasPath;
            ((Collection)result).add(new DynamicFieldDescriptor(df.getName(), df.getAnnotations(), path));
        }
        $this$forEach$iv = view.getSrc().getSelectStatement().getTableAliases();
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object = element$iv = (Map.Entry)iterator.next();
            boolean bl = false;
            String childAlias = (String)object.getKey();
            String name = (String)object.getValue();
            AnnotatedCreateViewStatement child = resolver.findView(name);
            if (child == null) continue;
            result.addAll((Collection)this.collectTransitiveDynamicFields(child, resolver, CollectionsKt.plus((Collection)aliasPath, (Object)childAlias)));
        }
        return result;
    }

    private final AnnotatedExecuteStatement createAnnotatedExecuteStatement(String stmtName, Object parsedStatement, SqlSingleStatement sqlStatement, File sourceFile) {
        ExecuteStatement executeStatement;
        Object object = parsedStatement;
        if (object instanceof Insert) {
            executeStatement = InsertStatement.Companion.parse((Insert)parsedStatement, this.conn);
        } else if (object instanceof Delete) {
            executeStatement = DeleteStatement.Companion.parse((Delete)parsedStatement, this.conn);
        } else if (object instanceof Update) {
            executeStatement = UpdateStatement.Companion.parse((Update)parsedStatement, this.conn);
        } else {
            throw new UnsupportedOperationException("Unsupported statement type");
        }
        ExecuteStatement stmt = executeStatement;
        return AnnotatedExecuteStatement.Companion.parse(stmtName, stmt, sqlStatement.getTopComments());
    }

    private final FieldAnnotationOverrides mergeFieldAnnotations(SelectStatement.FieldSource column, Map<String, ? extends Map<String, ? extends Object>> selectFieldAnnotations, SelectStatement selectStatement, FieldAnnotationResolver annotationResolver) {
        Map map;
        Map mergedAnnotations = new LinkedHashMap();
        if (annotationResolver != null) {
            String it;
            LinkedHashSet candidateSources = new LinkedHashSet();
            String tableAlias = column.getTableName();
            if (!StringsKt.isBlank((CharSequence)tableAlias)) {
                ((Collection)candidateSources).add(tableAlias);
                String string = selectStatement.getTableAliases().get(tableAlias);
                if (string != null) {
                    it = string;
                    boolean bl = false;
                    ((Collection)candidateSources).add(it);
                }
            } else {
                CollectionsKt.addAll((Collection)candidateSources, (Iterable)selectStatement.getTableAliases().values());
            }
            String string = selectStatement.getFromTable();
            if (string != null) {
                it = string;
                boolean bl = false;
                ((Collection)candidateSources).add(it);
            }
            Iterable $this$forEach$iv = candidateSources;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AnnotatedCreateViewStatement.Field viewField;
                AnnotatedCreateViewStatement.Field field;
                Object v3;
                AnnotatedCreateViewStatement.Field field2;
                boolean $i$f$firstOrNull;
                Iterable $this$firstOrNull$iv;
                AnnotatedCreateViewStatement view;
                block12: {
                    FieldAnnotationOverrides resolvedAnnotations;
                    String sourceName = (String)element$iv;
                    boolean bl = false;
                    FieldAnnotationOverrides fieldAnnotationOverrides = annotationResolver.getFieldAnnotations(sourceName, column.getFieldName());
                    if (fieldAnnotationOverrides == null) {
                        fieldAnnotationOverrides = annotationResolver.getFieldAnnotations(sourceName, column.getOriginalColumnName());
                    }
                    if ((resolvedAnnotations = fieldAnnotationOverrides) != null) {
                        FieldAnnotationMerger.INSTANCE.mergeFieldAnnotations(mergedAnnotations, resolvedAnnotations);
                        continue;
                    }
                    view = annotationResolver.findView(sourceName);
                    if (view == null) continue;
                    $this$firstOrNull$iv = view.getFields();
                    $i$f$firstOrNull = false;
                    for (Object element$iv2 : $this$firstOrNull$iv) {
                        field2 = (AnnotatedCreateViewStatement.Field)element$iv2;
                        boolean bl2 = false;
                        if (!(StringsKt.equals((String)field2.getSrc().getFieldName(), (String)column.getFieldName(), (boolean)true) || StringsKt.equals((String)field2.getSrc().getOriginalColumnName(), (String)column.getFieldName(), (boolean)true))) continue;
                        v3 = element$iv2;
                        break block12;
                    }
                    v3 = null;
                }
                if ((field = (AnnotatedCreateViewStatement.Field)v3) == null) {
                    Object v5;
                    block13: {
                        $this$firstOrNull$iv = view.getFields();
                        $i$f$firstOrNull = false;
                        for (Object element$iv2 : $this$firstOrNull$iv) {
                            field2 = (AnnotatedCreateViewStatement.Field)element$iv2;
                            boolean bl = false;
                            if (!(StringsKt.equals((String)field2.getSrc().getFieldName(), (String)column.getOriginalColumnName(), (boolean)true) || StringsKt.equals((String)field2.getSrc().getOriginalColumnName(), (String)column.getOriginalColumnName(), (boolean)true))) continue;
                            v5 = element$iv2;
                            break block13;
                        }
                        v5 = null;
                    }
                    field = v5;
                }
                if ((viewField = field) == null) continue;
                FieldAnnotationMerger.INSTANCE.mergeFieldAnnotations(mergedAnnotations, viewField.getAnnotations());
            }
        }
        if ((map = selectFieldAnnotations.get(column.getFieldName())) == null) {
            map = MapsKt.emptyMap();
        }
        Map selectAnnotations = map;
        mergedAnnotations.putAll(selectAnnotations);
        return FieldAnnotationOverrides.Companion.parse(mergedAnnotations);
    }

    private final String normalizeSelectForParser(String sql) {
        CharSequence charSequence = sql;
        Regex regex = new Regex("(?m)(?:\\r?\\n[ \t]*){2,}");
        String string = "\n";
        String collapsed = regex.replace(charSequence, string);
        return ((Object)StringsKt.trim((CharSequence)collapsed)).toString();
    }

    private static final boolean createAnnotatedSelectStatement$lambda$3$1(Pair pair) {
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        DynamicFieldDescriptor descriptor = (DynamicFieldDescriptor)pair.component1();
        CharSequence charSequence = descriptor.getAnnotations().getMappingType();
        return !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence));
    }

    private static final List createAnnotatedSelectStatement$lambda$3$2(Pair pair) {
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        List mergedPath = (List)pair.component2();
        return mergedPath;
    }

    private static final boolean createAnnotatedSelectStatement$lambda$3$3(List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.size() > 1;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007H\u00c6\u0003J-\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007H\u00c6\u0001J\u0014\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0017\u001a\u00020\u0018H\u00d6\u0081\u0004J\n\u0010\u0019\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Ldev/goquick/sqlitenow/gradle/processing/StatementProcessingHelper$DynamicFieldDescriptor;", "", "name", "", "annotations", "Ldev/goquick/sqlitenow/gradle/processing/FieldAnnotationOverrides;", "aliasPath", "", "<init>", "(Ljava/lang/String;Ldev/goquick/sqlitenow/gradle/processing/FieldAnnotationOverrides;Ljava/util/List;)V", "getName", "()Ljava/lang/String;", "getAnnotations", "()Ldev/goquick/sqlitenow/gradle/processing/FieldAnnotationOverrides;", "getAliasPath", "()Ljava/util/List;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "sqlitenow-gradle-plugin"})
    private static final class DynamicFieldDescriptor {
        @NotNull
        private final String name;
        @NotNull
        private final FieldAnnotationOverrides annotations;
        @NotNull
        private final List<String> aliasPath;

        public DynamicFieldDescriptor(@NotNull String name, @NotNull FieldAnnotationOverrides annotations, @NotNull List<String> aliasPath) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)annotations, (String)"annotations");
            Intrinsics.checkNotNullParameter(aliasPath, (String)"aliasPath");
            this.name = name;
            this.annotations = annotations;
            this.aliasPath = aliasPath;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final FieldAnnotationOverrides getAnnotations() {
            return this.annotations;
        }

        @NotNull
        public final List<String> getAliasPath() {
            return this.aliasPath;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final FieldAnnotationOverrides component2() {
            return this.annotations;
        }

        @NotNull
        public final List<String> component3() {
            return this.aliasPath;
        }

        @NotNull
        public final DynamicFieldDescriptor copy(@NotNull String name, @NotNull FieldAnnotationOverrides annotations, @NotNull List<String> aliasPath) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)annotations, (String)"annotations");
            Intrinsics.checkNotNullParameter(aliasPath, (String)"aliasPath");
            return new DynamicFieldDescriptor(name, annotations, aliasPath);
        }

        public static /* synthetic */ DynamicFieldDescriptor copy$default(DynamicFieldDescriptor dynamicFieldDescriptor, String string, FieldAnnotationOverrides fieldAnnotationOverrides, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string = dynamicFieldDescriptor.name;
            }
            if ((n & 2) != 0) {
                fieldAnnotationOverrides = dynamicFieldDescriptor.annotations;
            }
            if ((n & 4) != 0) {
                list = dynamicFieldDescriptor.aliasPath;
            }
            return dynamicFieldDescriptor.copy(string, fieldAnnotationOverrides, list);
        }

        @NotNull
        public String toString() {
            return "DynamicFieldDescriptor(name=" + this.name + ", annotations=" + this.annotations + ", aliasPath=" + this.aliasPath + ")";
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + this.annotations.hashCode();
            result = result * 31 + ((Object)this.aliasPath).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DynamicFieldDescriptor)) {
                return false;
            }
            DynamicFieldDescriptor dynamicFieldDescriptor = (DynamicFieldDescriptor)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)dynamicFieldDescriptor.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.annotations, (Object)dynamicFieldDescriptor.annotations)) {
                return false;
            }
            return Intrinsics.areEqual(this.aliasPath, dynamicFieldDescriptor.aliasPath);
        }
    }
}

