/*
 * Decompiled with CFR 0.152.
 */
package dev.goquick.sqlitenow.gradle;

import dev.goquick.sqlitenow.gradle.MigratorTempStorage;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0006\u0010\u000f\u001a\u00020\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Ldev/goquick/sqlitenow/gradle/TempDatabaseConnector;", "", "storage", "Ldev/goquick/sqlitenow/gradle/MigratorTempStorage;", "logger", "Lorg/gradle/api/logging/Logger;", "<init>", "(Ldev/goquick/sqlitenow/gradle/MigratorTempStorage;Lorg/gradle/api/logging/Logger;)V", "connection", "Ljava/sql/Connection;", "getConnection", "()Ljava/sql/Connection;", "createDatabaseWithJdbcUrl", "jdbcUrl", "", "close", "", "sqlitenow-gradle-plugin"})
public final class TempDatabaseConnector {
    @NotNull
    private final Connection connection;

    public TempDatabaseConnector(@NotNull MigratorTempStorage storage, @NotNull Logger logger) {
        Connection connection;
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        MigratorTempStorage migratorTempStorage = storage;
        if (migratorTempStorage instanceof MigratorTempStorage.Memory) {
            connection = this.createDatabaseWithJdbcUrl("jdbc:sqlite::memory:");
        } else if (migratorTempStorage instanceof MigratorTempStorage.File) {
            File dbFile = ((MigratorTempStorage.File)storage).getFile();
            if (dbFile.exists()) {
                dbFile.delete();
            }
            logger.lifecycle("Creating database file: " + dbFile.getAbsolutePath());
            connection = this.createDatabaseWithJdbcUrl("jdbc:sqlite:" + dbFile.getAbsolutePath());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.connection = connection;
    }

    public /* synthetic */ TempDatabaseConnector(MigratorTempStorage migratorTempStorage, Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            Logger logger2 = Logging.getLogger(TempDatabaseConnector.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
            logger = logger2;
        }
        this(migratorTempStorage, logger);
    }

    @NotNull
    public final Connection getConnection() {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Connection createDatabaseWithJdbcUrl(String jdbcUrl) {
        Class.forName("org.sqlite.JDBC");
        Connection connection = DriverManager.getConnection(jdbcUrl);
        Intrinsics.checkNotNullExpressionValue((Object)connection, (String)"getConnection(...)");
        Connection conn = connection;
        conn.setAutoCommit(false);
        AutoCloseable autoCloseable = conn.createStatement();
        Throwable throwable = null;
        try {
            Statement stmt = (Statement)autoCloseable;
            boolean bl = false;
            boolean bl2 = stmt.execute("PRAGMA foreign_keys = ON;");
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return conn;
    }

    public final void close() {
        this.connection.close();
    }
}

