/*
 * Decompiled with CFR 0.152.
 */
package dev.goquick.sqlitenow.gradle.generator.data;

import com.squareup.kotlinpoet.AnnotationSpec;
import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.FileSpec;
import com.squareup.kotlinpoet.TypeSpec;
import dev.goquick.sqlitenow.gradle.context.GeneratorContext;
import dev.goquick.sqlitenow.gradle.generator.data.DataStructJoinedEmitter;
import dev.goquick.sqlitenow.gradle.generator.data.DataStructResultEmitter;
import dev.goquick.sqlitenow.gradle.model.AnnotatedCreateTableStatement;
import dev.goquick.sqlitenow.gradle.model.AnnotatedExecuteStatement;
import dev.goquick.sqlitenow.gradle.model.AnnotatedSelectStatement;
import dev.goquick.sqlitenow.gradle.processing.ReturningColumnsResolver;
import dev.goquick.sqlitenow.gradle.util.StringUtilsKt;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011J\u001e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011J\u001e\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Ldev/goquick/sqlitenow/gradle/generator/data/DataStructResultFileEmitter;", "", "generatorContext", "Ldev/goquick/sqlitenow/gradle/context/GeneratorContext;", "joinedEmitter", "Ldev/goquick/sqlitenow/gradle/generator/data/DataStructJoinedEmitter;", "resultEmitter", "Ldev/goquick/sqlitenow/gradle/generator/data/DataStructResultEmitter;", "outputDir", "Ljava/io/File;", "<init>", "(Ldev/goquick/sqlitenow/gradle/context/GeneratorContext;Ldev/goquick/sqlitenow/gradle/generator/data/DataStructJoinedEmitter;Ldev/goquick/sqlitenow/gradle/generator/data/DataStructResultEmitter;Ljava/io/File;)V", "writeSelectResultFile", "", "statement", "Ldev/goquick/sqlitenow/gradle/model/AnnotatedSelectStatement;", "namespace", "", "packageName", "writeExecuteResultFile", "Ldev/goquick/sqlitenow/gradle/model/AnnotatedExecuteStatement;", "writeJoinedClassFile", "createFileSpec", "Lcom/squareup/kotlinpoet/FileSpec$Builder;", "className", "sqlitenow-gradle-plugin"})
public final class DataStructResultFileEmitter {
    @NotNull
    private final GeneratorContext generatorContext;
    @NotNull
    private final DataStructJoinedEmitter joinedEmitter;
    @NotNull
    private final DataStructResultEmitter resultEmitter;
    @NotNull
    private final File outputDir;

    public DataStructResultFileEmitter(@NotNull GeneratorContext generatorContext, @NotNull DataStructJoinedEmitter joinedEmitter, @NotNull DataStructResultEmitter resultEmitter, @NotNull File outputDir) {
        Intrinsics.checkNotNullParameter((Object)generatorContext, (String)"generatorContext");
        Intrinsics.checkNotNullParameter((Object)joinedEmitter, (String)"joinedEmitter");
        Intrinsics.checkNotNullParameter((Object)resultEmitter, (String)"resultEmitter");
        Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
        this.generatorContext = generatorContext;
        this.joinedEmitter = joinedEmitter;
        this.resultEmitter = resultEmitter;
        this.outputDir = outputDir;
    }

    public final void writeSelectResultFile(@NotNull AnnotatedSelectStatement statement, @NotNull String namespace, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Object object = statement.getAnnotations().getQueryResult();
        if (object == null) {
            object = StringUtilsKt.pascalize(namespace) + statement.getDataClassName() + "Result";
        }
        String className = object;
        TypeSpec resultDataClass = this.resultEmitter.generateSelectResult(statement, className);
        this.createFileSpec(packageName, className).addType(resultDataClass).build().writeTo(this.outputDir);
    }

    public final void writeExecuteResultFile(@NotNull AnnotatedExecuteStatement statement, @NotNull String namespace, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Object object = statement.getAnnotations().getQueryResult();
        if (object == null) {
            object = StringUtilsKt.pascalize(namespace) + statement.getDataClassName() + "Result";
        }
        String className = object;
        List<AnnotatedCreateTableStatement.Column> columnsToInclude = ReturningColumnsResolver.INSTANCE.resolveColumns(this.generatorContext, statement);
        TypeSpec resultDataClass = this.resultEmitter.generateExecuteResult(statement, className, columnsToInclude);
        this.createFileSpec(packageName, className).addType(resultDataClass).build().writeTo(this.outputDir);
    }

    public final void writeJoinedClassFile(@NotNull AnnotatedSelectStatement statement, @NotNull String namespace, @NotNull String packageName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        if (statement.getAnnotations().getQueryResult() != null) {
            string = statement.getAnnotations().getQueryResult() + "_Joined";
        } else {
            String queryClassName = statement.getDataClassName();
            string = StringUtilsKt.pascalize(namespace) + queryClassName + "Result_Joined";
        }
        String joinedClassName = string;
        TypeSpec joinedDataClass = this.joinedEmitter.generateJoinedDataClass(joinedClassName, statement.getFields(), statement.getAnnotations().getPropertyNameGenerator());
        this.createFileSpec(packageName, joinedClassName).addType(joinedDataClass).build().writeTo(this.outputDir);
    }

    private final FileSpec.Builder createFileSpec(String packageName, String className) {
        Object[] objectArray = new String[]{"Suppress"};
        ClassName className2 = new ClassName("kotlin", (String[])objectArray);
        objectArray = new Object[]{"UNNECESSARY_NOT_NULL_ASSERTION"};
        FileSpec.Builder builder = FileSpec.Companion.builder(packageName, className).addFileComment("Generated code for " + packageName + "." + className, new Object[0]).addFileComment("\nDo not modify this file manually", new Object[0]).addAnnotation(AnnotationSpec.Companion.builder(className2).addMember("%S", objectArray).build());
        objectArray = new String[]{"OptIn"};
        ClassName className3 = new ClassName("kotlin", (String[])objectArray);
        objectArray = new Object[1];
        String[] stringArray = new String[]{"ExperimentalUuidApi"};
        objectArray[0] = new ClassName("kotlin.uuid", stringArray);
        return builder.addAnnotation(AnnotationSpec.Companion.builder(className3).addMember("%T::class", objectArray).build());
    }
}

