/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.nbtapi;

import dev.jorel.commandapi.nbtapi.NBTCompoundList;
import dev.jorel.commandapi.nbtapi.NBTItem;
import dev.jorel.commandapi.nbtapi.NBTList;
import dev.jorel.commandapi.nbtapi.NBTListCompound;
import dev.jorel.commandapi.nbtapi.NBTReflectionUtil;
import dev.jorel.commandapi.nbtapi.NBTType;
import dev.jorel.commandapi.nbtapi.NbtApiException;
import dev.jorel.commandapi.nbtapi.iface.ReadWriteNBT;
import dev.jorel.commandapi.nbtapi.iface.ReadableNBT;
import dev.jorel.commandapi.nbtapi.utils.MinecraftVersion;
import dev.jorel.commandapi.nbtapi.utils.nmsmappings.Forge1710Mappings;
import dev.jorel.commandapi.nbtapi.utils.nmsmappings.ReflectionMethod;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.bukkit.inventory.ItemStack;

public class NBTCompound
implements ReadWriteNBT {
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private String compundName;
    private NBTCompound parent;

    protected NBTCompound(NBTCompound owner, String name) {
        this.compundName = name;
        this.parent = owner;
    }

    protected Lock getReadLock() {
        return this.readLock;
    }

    protected Lock getWriteLock() {
        return this.writeLock;
    }

    protected void saveCompound() {
        if (this.parent != null) {
            this.parent.saveCompound();
        }
    }

    public String getName() {
        return this.compundName;
    }

    public Object getCompound() {
        return this.parent.getCompound();
    }

    protected void setCompound(Object compound) {
        this.parent.setCompound(compound);
    }

    public NBTCompound getParent() {
        return this.parent;
    }

    public void mergeCompound(NBTCompound comp) {
        try {
            this.writeLock.lock();
            NBTReflectionUtil.mergeOtherNBTCompound(this, comp);
            this.saveCompound();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void mergeCompound(ReadableNBT comp) {
        if (!(comp instanceof NBTCompound)) {
            throw new NbtApiException("Unknown NBT object: " + comp);
        }
        this.mergeCompound((NBTCompound)comp);
    }

    @Override
    public void setString(String key, String value) {
        try {
            this.writeLock.lock();
            NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_STRING, key, value);
            this.saveCompound();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public String getString(String key) {
        try {
            this.readLock.lock();
            String string = (String)NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_STRING, key);
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    protected String getContent(String key) {
        return NBTReflectionUtil.getContent(this, key);
    }

    @Override
    public void setInteger(String key, Integer value) {
        try {
            this.writeLock.lock();
            NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_INT, key, value);
            this.saveCompound();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Integer getInteger(String key) {
        try {
            this.readLock.lock();
            Integer n = (Integer)NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_INT, key);
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void setDouble(String key, Double value) {
        try {
            this.writeLock.lock();
            NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_DOUBLE, key, value);
            this.saveCompound();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Double getDouble(String key) {
        try {
            this.readLock.lock();
            Double d2 = (Double)NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_DOUBLE, key);
            return d2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void setByte(String key, Byte value) {
        try {
            this.writeLock.lock();
            NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_BYTE, key, value);
            this.saveCompound();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Byte getByte(String key) {
        try {
            this.readLock.lock();
            Byte by = (Byte)NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_BYTE, key);
            return by;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void setShort(String key, Short value) {
        try {
            this.writeLock.lock();
            NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_SHORT, key, value);
            this.saveCompound();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Short getShort(String key) {
        try {
            this.readLock.lock();
            Short s = (Short)NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_SHORT, key);
            return s;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void setLong(String key, Long value) {
        try {
            this.writeLock.lock();
            NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_LONG, key, value);
            this.saveCompound();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Long getLong(String key) {
        try {
            this.readLock.lock();
            Long l = (Long)NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_LONG, key);
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void setFloat(String key, Float value) {
        try {
            this.writeLock.lock();
            NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_FLOAT, key, value);
            this.saveCompound();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Float getFloat(String key) {
        try {
            this.readLock.lock();
            Float f = (Float)NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_FLOAT, key);
            return f;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void setByteArray(String key, byte[] value) {
        try {
            this.writeLock.lock();
            NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_BYTEARRAY, key, value);
            this.saveCompound();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public byte[] getByteArray(String key) {
        try {
            this.readLock.lock();
            byte[] byArray = (byte[])NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_BYTEARRAY, key);
            return byArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void setIntArray(String key, int[] value) {
        try {
            this.writeLock.lock();
            NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_INTARRAY, key, value);
            this.saveCompound();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public int[] getIntArray(String key) {
        try {
            this.readLock.lock();
            int[] nArray = (int[])NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_INTARRAY, key);
            return nArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void setBoolean(String key, Boolean value) {
        try {
            this.writeLock.lock();
            NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_BOOLEAN, key, value);
            this.saveCompound();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void set(String key, Object val) {
        NBTReflectionUtil.set(this, key, val);
        this.saveCompound();
    }

    @Override
    public Boolean getBoolean(String key) {
        try {
            this.readLock.lock();
            Boolean bl = (Boolean)NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_BOOLEAN, key);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Deprecated
    public void setObject(String key, Object value) {
        try {
            this.writeLock.lock();
            NBTReflectionUtil.setObject(this, key, value);
            this.saveCompound();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public <T> T getObject(String key, Class<T> type) {
        try {
            this.readLock.lock();
            T t = NBTReflectionUtil.getObject(this, key, type);
            return t;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void setItemStack(String key, ItemStack item) {
        try {
            this.writeLock.lock();
            this.removeKey(key);
            this.addCompound(key).mergeCompound(NBTItem.convertItemtoNBT(item));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ItemStack getItemStack(String key) {
        try {
            this.readLock.lock();
            NBTCompound comp = this.getCompound(key);
            if (comp == null) {
                ItemStack itemStack = null;
                return itemStack;
            }
            ItemStack itemStack = NBTItem.convertNBTtoItem(comp);
            return itemStack;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void setItemStackArray(String key, ItemStack[] items) {
        try {
            this.writeLock.lock();
            this.removeKey(key);
            this.addCompound(key).mergeCompound(NBTItem.convertItemArraytoNBT(items));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ItemStack[] getItemStackArray(String key) {
        try {
            this.readLock.lock();
            NBTCompound comp = this.getCompound(key);
            if (comp == null) {
                ItemStack[] itemStackArray = null;
                return itemStackArray;
            }
            ItemStack[] itemStackArray = NBTItem.convertNBTtoItemArray(comp);
            return itemStackArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void setUUID(String key, UUID value) {
        try {
            this.writeLock.lock();
            if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_16_R1)) {
                NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_UUID, key, value);
            } else {
                this.setString(key, value.toString());
            }
            this.saveCompound();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public UUID getUUID(String key) {
        try {
            this.readLock.lock();
            if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_16_R1) && this.getType(key) == NBTType.NBTTagIntArray) {
                UUID uUID = (UUID)NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_UUID, key);
                return uUID;
            }
            if (this.getType(key) == NBTType.NBTTagString) {
                try {
                    UUID uUID = UUID.fromString(this.getString(key));
                    return uUID;
                }
                catch (IllegalArgumentException ex) {
                    UUID uUID = null;
                    this.readLock.unlock();
                    return uUID;
                }
            }
            UUID uUID = null;
            return uUID;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Deprecated
    public Boolean hasKey(String key) {
        return this.hasTag(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasTag(String key) {
        try {
            this.readLock.lock();
            Boolean b2 = (Boolean)NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_HAS_KEY, key);
            if (b2 == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = b2;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void removeKey(String key) {
        try {
            this.writeLock.lock();
            NBTReflectionUtil.remove(this, key);
            this.saveCompound();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Set<String> getKeys() {
        try {
            this.readLock.lock();
            HashSet<String> hashSet = new HashSet<String>(NBTReflectionUtil.getKeys(this));
            return hashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NBTCompound addCompound(String name) {
        try {
            this.writeLock.lock();
            if (this.getType(name) == NBTType.NBTTagCompound) {
                NBTCompound nBTCompound = this.getCompound(name);
                return nBTCompound;
            }
            NBTReflectionUtil.addNBTTagCompound(this, name);
            NBTCompound comp = this.getCompound(name);
            if (comp == null) {
                throw new NbtApiException("Error while adding Compound, got null!");
            }
            this.saveCompound();
            NBTCompound nBTCompound = comp;
            return nBTCompound;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NBTCompound getCompound(String name) {
        try {
            this.readLock.lock();
            if (this.getType(name) != NBTType.NBTTagCompound) {
                NBTCompound nBTCompound = null;
                return nBTCompound;
            }
            NBTCompound next = new NBTCompound(this, name);
            if (NBTReflectionUtil.valideCompound(next).booleanValue()) {
                NBTCompound nBTCompound = next;
                return nBTCompound;
            }
            NBTCompound nBTCompound = null;
            return nBTCompound;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public NBTCompound getOrCreateCompound(String name) {
        return this.addCompound(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NBTList<String> getStringList(String name) {
        try {
            this.writeLock.lock();
            NBTList<String> list = NBTReflectionUtil.getList(this, name, NBTType.NBTTagString, String.class);
            this.saveCompound();
            NBTList<String> nBTList = list;
            return nBTList;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NBTList<Integer> getIntegerList(String name) {
        try {
            this.writeLock.lock();
            NBTList<Integer> list = NBTReflectionUtil.getList(this, name, NBTType.NBTTagInt, Integer.class);
            this.saveCompound();
            NBTList<Integer> nBTList = list;
            return nBTList;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NBTList<int[]> getIntArrayList(String name) {
        try {
            this.writeLock.lock();
            NBTList<int[]> list = NBTReflectionUtil.getList(this, name, NBTType.NBTTagIntArray, int[].class);
            this.saveCompound();
            NBTList<int[]> nBTList = list;
            return nBTList;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NBTList<UUID> getUUIDList(String name) {
        try {
            this.writeLock.lock();
            NBTList<UUID> list = NBTReflectionUtil.getList(this, name, NBTType.NBTTagIntArray, UUID.class);
            this.saveCompound();
            NBTList<UUID> nBTList = list;
            return nBTList;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NBTList<Float> getFloatList(String name) {
        try {
            this.writeLock.lock();
            NBTList<Float> list = NBTReflectionUtil.getList(this, name, NBTType.NBTTagFloat, Float.class);
            this.saveCompound();
            NBTList<Float> nBTList = list;
            return nBTList;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NBTList<Double> getDoubleList(String name) {
        try {
            this.writeLock.lock();
            NBTList<Double> list = NBTReflectionUtil.getList(this, name, NBTType.NBTTagDouble, Double.class);
            this.saveCompound();
            NBTList<Double> nBTList = list;
            return nBTList;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NBTList<Long> getLongList(String name) {
        try {
            this.writeLock.lock();
            NBTList<Long> list = NBTReflectionUtil.getList(this, name, NBTType.NBTTagLong, Long.class);
            this.saveCompound();
            NBTList<Long> nBTList = list;
            return nBTList;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public NBTType getListType(String name) {
        try {
            this.readLock.lock();
            if (this.getType(name) != NBTType.NBTTagList) {
                NBTType nBTType = null;
                return nBTType;
            }
            NBTType nBTType = NBTReflectionUtil.getListType(this, name);
            return nBTType;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NBTCompoundList getCompoundList(String name) {
        try {
            this.writeLock.lock();
            NBTCompoundList list = (NBTCompoundList)NBTReflectionUtil.getList(this, name, NBTType.NBTTagCompound, NBTListCompound.class);
            this.saveCompound();
            NBTCompoundList nBTCompoundList = list;
            return nBTCompoundList;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public <T> T getOrDefault(String key, T defaultValue) {
        if (defaultValue == null) {
            throw new NullPointerException("Default type in getOrDefault can't be null!");
        }
        if (!this.hasTag(key)) {
            return defaultValue;
        }
        Class<?> clazz = defaultValue.getClass();
        if (clazz == Byte.class) {
            return (T)this.getByte(key);
        }
        if (clazz == Short.class) {
            return (T)this.getShort(key);
        }
        if (clazz == Integer.class) {
            return (T)this.getInteger(key);
        }
        if (clazz == Long.class) {
            return (T)this.getLong(key);
        }
        if (clazz == Float.class) {
            return (T)this.getFloat(key);
        }
        if (clazz == Double.class) {
            return (T)this.getDouble(key);
        }
        if (clazz == byte[].class) {
            return (T)this.getByteArray(key);
        }
        if (clazz == int[].class) {
            return (T)this.getIntArray(key);
        }
        if (clazz == String.class) {
            return (T)this.getString(key);
        }
        if (clazz == UUID.class) {
            UUID uuid = this.getUUID(key);
            return (T)(uuid == null ? defaultValue : uuid);
        }
        if (clazz.isEnum()) {
            Object obj = this.getEnum(key, defaultValue.getClass());
            return (T)(obj == null ? defaultValue : obj);
        }
        throw new NbtApiException("Unsupported type for getOrDefault: " + clazz.getName());
    }

    @Override
    public <T> T getOrNull(String key, Class<?> type) {
        if (type == null) {
            throw new NullPointerException("Default type in getOrNull can't be null!");
        }
        if (!this.hasTag(key)) {
            return null;
        }
        if (type == Byte.class) {
            return (T)this.getByte(key);
        }
        if (type == Short.class) {
            return (T)this.getShort(key);
        }
        if (type == Integer.class) {
            return (T)this.getInteger(key);
        }
        if (type == Long.class) {
            return (T)this.getLong(key);
        }
        if (type == Float.class) {
            return (T)this.getFloat(key);
        }
        if (type == Double.class) {
            return (T)this.getDouble(key);
        }
        if (type == byte[].class) {
            return (T)this.getByteArray(key);
        }
        if (type == int[].class) {
            return (T)this.getIntArray(key);
        }
        if (type == String.class) {
            return (T)this.getString(key);
        }
        if (type == UUID.class) {
            return (T)this.getUUID(key);
        }
        if (type.isEnum()) {
            return (T)this.getEnum(key, type);
        }
        throw new NbtApiException("Unsupported type for getOrNull: " + type.getName());
    }

    @Override
    public <E extends Enum<?>> void setEnum(String key, E value) {
        if (value == null) {
            this.removeKey(key);
            return;
        }
        this.setString(key, value.name());
    }

    @Override
    public <E extends Enum<E>> E getEnum(String key, Class<E> type) {
        if (key == null || type == null) {
            return null;
        }
        String name = this.getString(key);
        if (name == null) {
            return null;
        }
        try {
            return Enum.valueOf(type, name);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NBTType getType(String name) {
        try {
            this.readLock.lock();
            if (MinecraftVersion.getVersion() == MinecraftVersion.MC1_7_R4) {
                Object nbtbase = NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET, name);
                if (nbtbase == null) {
                    NBTType nBTType = null;
                    return nBTType;
                }
                NBTType nBTType = NBTType.valueOf(((Byte)ReflectionMethod.COMPOUND_OWN_TYPE.run(nbtbase, new Object[0])).byteValue());
                return nBTType;
            }
            Object o = NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_TYPE, name);
            if (o == null) {
                NBTType nBTType = null;
                return nBTType;
            }
            NBTType nBTType = NBTType.valueOf(((Byte)o).byteValue());
            return nBTType;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void writeCompound(OutputStream stream) {
        try {
            this.writeLock.lock();
            NBTReflectionUtil.writeApiNBT(this, stream);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public String toString() {
        return this.asNBTString();
    }

    @Deprecated
    public String toString(String key) {
        return this.asNBTString();
    }

    @Override
    public void clearNBT() {
        for (String key : this.getKeys()) {
            this.removeKey(key);
        }
    }

    @Deprecated
    public String asNBTString() {
        try {
            this.readLock.lock();
            Object comp = NBTReflectionUtil.gettoCompount(this.getCompound(), this);
            if (comp == null) {
                String string = "{}";
                return string;
            }
            if (MinecraftVersion.isForgePresent() && MinecraftVersion.getVersion() == MinecraftVersion.MC1_7_R4) {
                String string = Forge1710Mappings.toString(comp);
                return string;
            }
            String string = comp.toString();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof NBTCompound) {
            NBTCompound other = (NBTCompound)obj;
            if (this.getKeys().equals(other.getKeys())) {
                for (String key : this.getKeys()) {
                    if (NBTCompound.isEqual(this, other, key)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    protected static boolean isEqual(NBTCompound compA, NBTCompound compB, String key) {
        if (compA.getType(key) != compB.getType(key)) {
            return false;
        }
        switch (compA.getType(key)) {
            case NBTTagByte: {
                return compA.getByte(key).equals(compB.getByte(key));
            }
            case NBTTagByteArray: {
                return Arrays.equals(compA.getByteArray(key), compB.getByteArray(key));
            }
            case NBTTagCompound: {
                return compA.getCompound(key).equals(compB.getCompound(key));
            }
            case NBTTagDouble: {
                return compA.getDouble(key).equals(compB.getDouble(key));
            }
            case NBTTagEnd: {
                return true;
            }
            case NBTTagFloat: {
                return compA.getFloat(key).equals(compB.getFloat(key));
            }
            case NBTTagInt: {
                return compA.getInteger(key).equals(compB.getInteger(key));
            }
            case NBTTagIntArray: {
                return Arrays.equals(compA.getIntArray(key), compB.getIntArray(key));
            }
            case NBTTagList: {
                return NBTReflectionUtil.getEntry(compA, key).toString().equals(NBTReflectionUtil.getEntry(compB, key).toString());
            }
            case NBTTagLong: {
                return compA.getLong(key).equals(compB.getLong(key));
            }
            case NBTTagShort: {
                return compA.getShort(key).equals(compB.getShort(key));
            }
            case NBTTagString: {
                return compA.getString(key).equals(compB.getString(key));
            }
        }
        return false;
    }
}

