/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.config;

import dev.jorel.commandapi.config.ConfigurationAdapter;
import dev.jorel.commandapi.config.DefaultBukkitConfig;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public final class BukkitConfigurationAdapter
extends Record
implements ConfigurationAdapter<YamlConfiguration> {
    private final YamlConfiguration config;
    private final File configFile;

    public BukkitConfigurationAdapter(YamlConfiguration config, File configFile) {
        this.config = config;
        this.configFile = configFile;
    }

    public static BukkitConfigurationAdapter createMinimalInstance(File configFile) {
        return new BukkitConfigurationAdapter(null, configFile);
    }

    @Override
    public void setValue(String key, Object value) {
        this.config.set(key, value);
    }

    @Override
    public void setComment(String key, String[] comment) {
        this.config.setComments(key, Arrays.asList(comment));
    }

    @Override
    public Object getValue(String key) {
        return this.config.get(key);
    }

    @Override
    public String[] getComment(String key) {
        ArrayList<String> comments = new ArrayList<String>(this.config.getComments(key));
        comments.removeIf(Objects::isNull);
        return comments.toArray(new String[0]);
    }

    @Override
    public Set<String> getKeys() {
        HashSet<String> keys = new HashSet<String>(this.config.getKeys(true));
        keys.removeIf(arg_0 -> ((YamlConfiguration)this.config).isConfigurationSection(arg_0));
        return keys;
    }

    @Override
    public boolean contains(String key) {
        return this.config.contains(key);
    }

    @Override
    public void tryCreateSection(String key) {
        if (!key.contains(".")) {
            return;
        }
        Set keys = this.config.getKeys(true);
        keys.removeIf(k -> !this.config.isConfigurationSection(k));
        String[] sectionCandidates = key.split("\\.");
        sectionCandidates = Arrays.copyOf(sectionCandidates, sectionCandidates.length - 1);
        ConfigurationSection section = null;
        for (String sectionCandidate : sectionCandidates) {
            ConfigurationSection currentSection;
            section = keys.contains(sectionCandidate) && section == null ? this.config.getConfigurationSection(sectionCandidate) : (section == null ? this.config.createSection(sectionCandidate) : ((currentSection = section.getConfigurationSection(sectionCandidate)) == null ? section.createSection(sectionCandidate) : currentSection));
        }
    }

    @Override
    public ConfigurationAdapter<YamlConfiguration> complete() {
        String[] configStrings = this.config.saveToString().split("\n");
        StringBuilder configBuilder = new StringBuilder();
        for (String configString : configStrings) {
            configBuilder.append(configString).append("\n");
            if (configString.contains("#")) continue;
            configBuilder.append("\n");
        }
        try {
            this.config.loadFromString(configBuilder.toString());
        }
        catch (InvalidConfigurationException e) {
            e.printStackTrace(System.err);
        }
        return this;
    }

    @Override
    public ConfigurationAdapter<YamlConfiguration> createNew() {
        return new BukkitConfigurationAdapter(new YamlConfiguration(), this.configFile);
    }

    @Override
    public DefaultBukkitConfig createDefaultConfig() {
        return DefaultBukkitConfig.createDefault();
    }

    @Override
    public ConfigurationAdapter<YamlConfiguration> loadFromFile() {
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.configFile);
        return new BukkitConfigurationAdapter(config, this.configFile);
    }

    @Override
    public void saveToFile() throws IOException {
        this.config.save(this.configFile);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{BukkitConfigurationAdapter.class, "config;configFile", "config", "configFile"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{BukkitConfigurationAdapter.class, "config;configFile", "config", "configFile"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{BukkitConfigurationAdapter.class, "config;configFile", "config", "configFile"}, this, o);
    }

    @Override
    public YamlConfiguration config() {
        return this.config;
    }

    public File configFile() {
        return this.configFile;
    }
}

