/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.arguments;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.CommandAPIArgumentType;
import dev.jorel.commandapi.exceptions.BadLiteralException;
import dev.jorel.commandapi.nms.NMS;

public class LiteralArgument
extends Argument<String> {
    private String literal;

    public LiteralArgument(String literal) {
        super(literal, null);
        if (literal == null) {
            throw new BadLiteralException(true);
        }
        if (literal.isEmpty()) {
            throw new BadLiteralException(false);
        }
        this.literal = literal;
        this.setListed(false);
    }

    @Override
    public Class<String> getPrimitiveType() {
        return String.class;
    }

    public String getLiteral() {
        return this.literal;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.LITERAL;
    }

    @Override
    public <CommandListenerWrapper> String parseArgument(NMS<CommandListenerWrapper> nms, CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return this.literal;
    }
}

