/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi;

import java.util.Optional;

public class CommandPermission {
    public static CommandPermission OP = new CommandPermission(PermissionNode.OP);
    public static CommandPermission NONE = new CommandPermission(PermissionNode.NONE);
    private String permission;
    private PermissionNode permissionNode;
    private boolean negated = false;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.negated ? 1231 : 1237);
        result = 31 * result + (this.permission == null ? 0 : this.permission.hashCode());
        result = 31 * result + (this.permissionNode == null ? 0 : this.permissionNode.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CommandPermission other = (CommandPermission)obj;
        if (this.negated != other.negated) {
            return false;
        }
        if (this.permission == null ? other.permission != null : !this.permission.equals(other.permission)) {
            return false;
        }
        return this.permissionNode == other.permissionNode;
    }

    public static CommandPermission fromString(String permission) {
        return new CommandPermission(permission);
    }

    private CommandPermission(String permission) {
        this.permission = permission;
        this.permissionNode = null;
    }

    private CommandPermission(PermissionNode permissionNode) {
        this.permission = null;
        this.permissionNode = permissionNode;
    }

    Optional<String> getPermission() {
        return Optional.ofNullable(this.permission);
    }

    PermissionNode getPermissionNode() {
        return this.permissionNode;
    }

    boolean isNegated() {
        return this.negated;
    }

    CommandPermission negate() {
        this.negated = true;
        return this;
    }

    public String toString() {
        String result = this.permissionNode != null ? (this.permissionNode == PermissionNode.OP ? "OP" : "NONE") : this.permission;
        return (this.negated ? "not " : "") + result;
    }

    private static enum PermissionNode {
        OP,
        NONE;

    }
}

