/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi;

import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.CommandMetaData;
import dev.jorel.commandapi.CommandPermission;
import dev.jorel.commandapi.Executable;
import java.util.Optional;
import java.util.function.Predicate;

public abstract class ExecutableCommand<Impl extends ExecutableCommand<Impl, CommandSender>, CommandSender>
extends Executable<Impl, CommandSender> {
    protected final CommandMetaData<CommandSender> meta;

    ExecutableCommand(String commandName) {
        this.meta = new CommandMetaData(commandName);
    }

    protected ExecutableCommand(CommandMetaData<CommandSender> meta) {
        this.meta = meta;
    }

    public String getName() {
        return this.meta.commandName;
    }

    public Impl withPermission(CommandPermission permission) {
        this.meta.permission = permission;
        return (Impl)((ExecutableCommand)this.instance());
    }

    public Impl withPermission(String permission) {
        this.meta.permission = CommandPermission.fromString(permission);
        return (Impl)((ExecutableCommand)this.instance());
    }

    public Impl withoutPermission(CommandPermission permission) {
        this.meta.permission = permission.negate();
        return (Impl)((ExecutableCommand)this.instance());
    }

    public Impl withoutPermission(String permission) {
        this.meta.permission = CommandPermission.fromString(permission).negate();
        return (Impl)((ExecutableCommand)this.instance());
    }

    public Impl withRequirement(Predicate<CommandSender> requirement) {
        this.meta.requirements = this.meta.requirements.and(requirement);
        return (Impl)((ExecutableCommand)this.instance());
    }

    public Impl withAliases(String ... aliases) {
        this.meta.aliases = aliases;
        return (Impl)((ExecutableCommand)this.instance());
    }

    public CommandPermission getPermission() {
        return this.meta.permission;
    }

    public void setPermission(CommandPermission permission) {
        this.meta.permission = permission;
    }

    public String[] getAliases() {
        return this.meta.aliases;
    }

    public void setAliases(String[] aliases) {
        this.meta.aliases = aliases;
    }

    public Predicate<CommandSender> getRequirements() {
        return this.meta.requirements;
    }

    public void setRequirements(Predicate<CommandSender> requirements) {
        this.meta.requirements = requirements;
    }

    public String getShortDescription() {
        return this.meta.shortDescription.orElse(null);
    }

    public Impl withShortDescription(String description) {
        this.meta.shortDescription = Optional.ofNullable(description);
        return (Impl)((ExecutableCommand)this.instance());
    }

    public String getFullDescription() {
        return this.meta.fullDescription.orElse(null);
    }

    public Impl withFullDescription(String description) {
        this.meta.fullDescription = Optional.ofNullable(description);
        return (Impl)((ExecutableCommand)this.instance());
    }

    public Impl withUsage(String ... usage) {
        this.meta.usageDescription = Optional.ofNullable(usage);
        return (Impl)((ExecutableCommand)this.instance());
    }

    public String[] getUsage() {
        return this.meta.usageDescription.orElse(null);
    }

    public Impl withHelp(String shortDescription, String fullDescription) {
        this.meta.shortDescription = Optional.ofNullable(shortDescription);
        this.meta.fullDescription = Optional.ofNullable(fullDescription);
        return (Impl)((ExecutableCommand)this.instance());
    }

    public void override() {
        CommandAPI.unregister(this.meta.commandName, true);
        this.register();
    }

    public void register() {
        this.register(CommandAPI.getConfiguration().getNamespace());
    }

    public abstract void register(String var1);
}

