/*
 * Decompiled with CFR 0.152.
 */
import be.seeseemelk.mockbukkit.WorldMock;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import dev.jorel.commandapi.arguments.SuggestionProviders;
import dev.jorel.commandapi.nms.NMS;
import dev.jorel.commandapi.wrappers.ParticleData;
import dev.jorel.commandapi.wrappers.SimpleFunctionWrapper;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.SharedConstants;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.Advancements;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.commands.arguments.ArgumentAngle;
import net.minecraft.commands.arguments.ArgumentChat;
import net.minecraft.commands.arguments.ArgumentChatComponent;
import net.minecraft.commands.arguments.ArgumentChatFormat;
import net.minecraft.commands.arguments.ArgumentCriterionValue;
import net.minecraft.commands.arguments.ArgumentDimension;
import net.minecraft.commands.arguments.ArgumentEnchantment;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentEntitySummon;
import net.minecraft.commands.arguments.ArgumentInventorySlot;
import net.minecraft.commands.arguments.ArgumentMathOperation;
import net.minecraft.commands.arguments.ArgumentMinecraftKeyRegistered;
import net.minecraft.commands.arguments.ArgumentMobEffect;
import net.minecraft.commands.arguments.ArgumentNBTBase;
import net.minecraft.commands.arguments.ArgumentNBTKey;
import net.minecraft.commands.arguments.ArgumentNBTTag;
import net.minecraft.commands.arguments.ArgumentParticle;
import net.minecraft.commands.arguments.ArgumentProfile;
import net.minecraft.commands.arguments.ArgumentScoreboardCriteria;
import net.minecraft.commands.arguments.ArgumentScoreboardObjective;
import net.minecraft.commands.arguments.ArgumentScoreboardSlot;
import net.minecraft.commands.arguments.ArgumentScoreboardTeam;
import net.minecraft.commands.arguments.ArgumentScoreholder;
import net.minecraft.commands.arguments.ArgumentTime;
import net.minecraft.commands.arguments.ArgumentUUID;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.commands.arguments.ResourceOrTagLocationArgument;
import net.minecraft.commands.arguments.TemplateMirrorArgument;
import net.minecraft.commands.arguments.TemplateRotationArgument;
import net.minecraft.commands.arguments.blocks.ArgumentBlockPredicate;
import net.minecraft.commands.arguments.blocks.ArgumentTile;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.commands.arguments.coordinates.ArgumentRotation;
import net.minecraft.commands.arguments.coordinates.ArgumentRotationAxis;
import net.minecraft.commands.arguments.coordinates.ArgumentVec2;
import net.minecraft.commands.arguments.coordinates.ArgumentVec2I;
import net.minecraft.commands.arguments.coordinates.ArgumentVec3;
import net.minecraft.commands.arguments.item.ArgumentItemPredicate;
import net.minecraft.commands.arguments.item.ArgumentItemStack;
import net.minecraft.commands.arguments.item.ArgumentTag;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.SingletonArgumentInfo;
import net.minecraft.commands.synchronization.brigadier.ArgumentSerializerString;
import net.minecraft.commands.synchronization.brigadier.DoubleArgumentInfo;
import net.minecraft.commands.synchronization.brigadier.FloatArgumentInfo;
import net.minecraft.commands.synchronization.brigadier.IntegerArgumentInfo;
import net.minecraft.commands.synchronization.brigadier.LongArgumentInfo;
import net.minecraft.core.BlockPosition;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.AdvancementDataWorld;
import net.minecraft.server.DispenserRegistry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.players.UserCache;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftPlayer;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.help.HelpTopic;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffectType;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class MockNMS
extends ArgumentNMS {
    CommandDispatcher<CommandListenerWrapper> dispatcher;
    List<EntityPlayer> players = new ArrayList<EntityPlayer>();
    PlayerList playerListMock;

    public MockNMS(NMS<?> baseNMS) {
        super(baseNMS);
        try {
            this.initializeArgumentsInArgumentTypeInfos();
            SharedConstants.a();
            this.unregisterAllEnchantments();
            this.unregisterAllPotionEffects();
            DispenserRegistry.a();
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
    }

    private void unregisterAllPotionEffects() {
        PotionEffectType[] byId = (PotionEffectType[])this.getField(PotionEffectType.class, "byId", null);
        for (int i = 0; i < 34; ++i) {
            byId[i] = null;
        }
        Map byName = (Map)this.getField(PotionEffectType.class, "byName", null);
        byName.clear();
        Map byKey = (Map)this.getField(PotionEffectType.class, "byKey", null);
        byKey.clear();
        try {
            Field field = PotionEffectType.class.getDeclaredField("acceptingNew");
            field.setAccessible(true);
            field.set(null, true);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
    }

    private void unregisterAllEnchantments() {
        Map byName = (Map)this.getField(Enchantment.class, "byName", null);
        byName.clear();
        Map byKey = (Map)this.getField(Enchantment.class, "byKey", null);
        byKey.clear();
        try {
            Field field = Enchantment.class.getDeclaredField("acceptingNew");
            field.setAccessible(true);
            field.set(null, true);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
    }

    public String[] compatibleVersions() {
        return new String[]{"1.19"};
    }

    public CommandDispatcher<CommandListenerWrapper> getBrigadierDispatcher() {
        if (this.dispatcher == null) {
            this.dispatcher = new CommandDispatcher();
        }
        return this.dispatcher;
    }

    public CommandListenerWrapper getCLWFromCommandSender(CommandSender sender) {
        CommandListenerWrapper clw = (CommandListenerWrapper)Mockito.mock(CommandListenerWrapper.class);
        Mockito.when((Object)clw.getBukkitSender()).thenReturn((Object)sender);
        if (sender instanceof Player) {
            Player player = (Player)sender;
            Location loc = player.getLocation();
            Mockito.when((Object)clw.e()).thenReturn((Object)new Vec3D(loc.getX(), loc.getY(), loc.getZ()));
            WorldServer worldServerMock = (WorldServer)Mockito.mock(WorldServer.class);
            Mockito.when((Object)clw.f()).thenReturn((Object)worldServerMock);
            Mockito.when((Object)clw.f().E((BlockPosition)ArgumentMatchers.any(BlockPosition.class))).thenReturn((Object)true);
            Mockito.when((Object)clw.f().j((BlockPosition)ArgumentMatchers.any(BlockPosition.class))).thenReturn((Object)true);
            MinecraftServer minecraftServerMock = (MinecraftServer)Mockito.mock(MinecraftServer.class);
            Mockito.when((Object)minecraftServerMock.az()).thenReturn((Object)this.mockAdvancementDataWorld());
            Mockito.when((Object)clw.m()).thenReturn((Object)minecraftServerMock);
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                EntityPlayer entityPlayerMock = (EntityPlayer)Mockito.mock(EntityPlayer.class);
                CraftPlayer craftPlayerMock = (CraftPlayer)Mockito.mock(CraftPlayer.class);
                Mockito.when((Object)craftPlayerMock.getName()).thenReturn((Object)onlinePlayer.getName());
                Mockito.when((Object)craftPlayerMock.getUniqueId()).thenReturn((Object)onlinePlayer.getUniqueId());
                Mockito.when((Object)entityPlayerMock.getBukkitEntity()).thenReturn((Object)craftPlayerMock);
                this.players.add(entityPlayerMock);
            }
            if (this.playerListMock == null) {
                this.playerListMock = (PlayerList)Mockito.mock(PlayerList.class);
                Mockito.when((Object)this.playerListMock.a(ArgumentMatchers.anyString())).thenAnswer(invocation -> {
                    String playerName = (String)invocation.getArgument(0);
                    for (EntityPlayer onlinePlayer : this.players) {
                        if (!onlinePlayer.getBukkitEntity().getName().equals(playerName)) continue;
                        return onlinePlayer;
                    }
                    return null;
                });
            }
            Mockito.when((Object)minecraftServerMock.ac()).thenReturn((Object)this.playerListMock);
            Mockito.when((Object)minecraftServerMock.ac().t()).thenReturn(this.players);
            UserCache userCacheMock = (UserCache)Mockito.mock(UserCache.class);
            Mockito.when((Object)userCacheMock.a(ArgumentMatchers.anyString())).thenAnswer(invocation -> {
                String playerName = (String)invocation.getArgument(0);
                for (EntityPlayer onlinePlayer : this.players) {
                    if (!onlinePlayer.getBukkitEntity().getName().equals(playerName)) continue;
                    return Optional.of(new GameProfile(onlinePlayer.getBukkitEntity().getUniqueId(), playerName));
                }
                return Optional.empty();
            });
            Mockito.when((Object)minecraftServerMock.ap()).thenReturn((Object)userCacheMock);
        }
        return clw;
    }

    public AdvancementDataWorld mockAdvancementDataWorld() {
        AdvancementDataWorld advancementDataWorld = new AdvancementDataWorld(null);
        Advancements advancements = (Advancements)this.getField(AdvancementDataWorld.class, "c", advancementDataWorld);
        advancements.b.put(new MinecraftKey("my:advancement"), new Advancement(new MinecraftKey("my:advancement"), null, null, null, new HashMap(), null));
        advancements.b.put(new MinecraftKey("my:advancement2"), new Advancement(new MinecraftKey("my:advancement2"), null, null, null, new HashMap(), null));
        return advancementDataWorld;
    }

    public Object getField(Class<?> className, String fieldName, Object instance) {
        try {
            Field field = className.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(instance);
        }
        catch (ReflectiveOperationException e) {
            return null;
        }
    }

    public CommandSender getCommandSenderFromCSS(CommandListenerWrapper clw) {
        try {
            return clw.getBukkitSender();
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }

    public CommandSender getSenderForCommand(CommandContext<CommandListenerWrapper> cmdCtx, boolean forceNative) {
        CommandListenerWrapper css = (CommandListenerWrapper)cmdCtx.getSource();
        return css.getBukkitSender();
    }

    public void createDispatcherFile(File file, CommandDispatcher<CommandListenerWrapper> dispatcher) throws IOException {
        Files.asCharSink((File)file, (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)DispatcherUtil.toJSON(dispatcher, dispatcher.getRoot())));
    }

    private void initializeArgumentsInArgumentTypeInfos() throws ReflectiveOperationException {
        Field f = ArgumentTypeInfos.class.getDeclaredField("a");
        f.setAccessible(true);
        Map map = (Map)f.get(null);
        map.put(BoolArgumentType.class, SingletonArgumentInfo.a(BoolArgumentType::bool));
        map.put(FloatArgumentType.class, new FloatArgumentInfo());
        map.put(DoubleArgumentType.class, new DoubleArgumentInfo());
        map.put(IntegerArgumentType.class, new IntegerArgumentInfo());
        map.put(LongArgumentType.class, new LongArgumentInfo());
        map.put(StringArgumentType.class, new ArgumentSerializerString());
        map.put(ArgumentEntity.class, new ArgumentEntity.Info());
        map.put(ArgumentProfile.class, SingletonArgumentInfo.a(ArgumentProfile::a));
        map.put(ArgumentPosition.class, SingletonArgumentInfo.a(ArgumentPosition::a));
        map.put(ArgumentVec2I.class, SingletonArgumentInfo.a(ArgumentVec2I::a));
        map.put(ArgumentVec3.class, SingletonArgumentInfo.a(ArgumentVec3::a));
        map.put(ArgumentVec2.class, SingletonArgumentInfo.a(ArgumentVec2::a));
        map.put(ArgumentTile.class, SingletonArgumentInfo.a(ArgumentTile::a));
        map.put(ArgumentBlockPredicate.class, SingletonArgumentInfo.a(ArgumentBlockPredicate::a));
        map.put(ArgumentItemStack.class, SingletonArgumentInfo.a(ArgumentItemStack::a));
        map.put(ArgumentItemPredicate.class, SingletonArgumentInfo.a(ArgumentItemPredicate::a));
        map.put(ArgumentChatFormat.class, SingletonArgumentInfo.a(ArgumentChatFormat::a));
        map.put(ArgumentChatComponent.class, SingletonArgumentInfo.a(ArgumentChatComponent::a));
        map.put(ArgumentChat.class, SingletonArgumentInfo.a(ArgumentChat::a));
        map.put(ArgumentNBTTag.class, SingletonArgumentInfo.a(ArgumentNBTTag::a));
        map.put(ArgumentNBTBase.class, SingletonArgumentInfo.a(ArgumentNBTBase::a));
        map.put(ArgumentNBTKey.class, SingletonArgumentInfo.a(ArgumentNBTKey::a));
        map.put(ArgumentScoreboardObjective.class, SingletonArgumentInfo.a(ArgumentScoreboardObjective::a));
        map.put(ArgumentScoreboardCriteria.class, SingletonArgumentInfo.a(ArgumentScoreboardCriteria::a));
        map.put(ArgumentMathOperation.class, SingletonArgumentInfo.a(ArgumentMathOperation::a));
        map.put(ArgumentParticle.class, SingletonArgumentInfo.a(ArgumentParticle::a));
        map.put(ArgumentAngle.class, SingletonArgumentInfo.a(ArgumentAngle::a));
        map.put(ArgumentRotation.class, SingletonArgumentInfo.a(ArgumentRotation::a));
        map.put(ArgumentScoreboardSlot.class, SingletonArgumentInfo.a(ArgumentScoreboardSlot::a));
        map.put(ArgumentScoreholder.class, new ArgumentScoreholder.a());
        map.put(ArgumentRotationAxis.class, SingletonArgumentInfo.a(ArgumentRotationAxis::a));
        map.put(ArgumentScoreboardTeam.class, SingletonArgumentInfo.a(ArgumentScoreboardTeam::a));
        map.put(ArgumentInventorySlot.class, SingletonArgumentInfo.a(ArgumentInventorySlot::a));
        map.put(ArgumentMinecraftKeyRegistered.class, SingletonArgumentInfo.a(ArgumentMinecraftKeyRegistered::a));
        map.put(ArgumentMobEffect.class, SingletonArgumentInfo.a(ArgumentMobEffect::a));
        map.put(ArgumentTag.class, SingletonArgumentInfo.a(ArgumentTag::a));
        map.put(ArgumentAnchor.class, SingletonArgumentInfo.a(ArgumentAnchor::a));
        map.put(ArgumentCriterionValue.b.class, SingletonArgumentInfo.a(ArgumentCriterionValue::a));
        map.put(ArgumentCriterionValue.a.class, SingletonArgumentInfo.a(ArgumentCriterionValue::b));
        map.put(ArgumentEnchantment.class, SingletonArgumentInfo.a(ArgumentEnchantment::a));
        map.put(ArgumentEntitySummon.class, SingletonArgumentInfo.a(ArgumentEntitySummon::a));
        map.put(ArgumentDimension.class, SingletonArgumentInfo.a(ArgumentDimension::a));
        map.put(ArgumentTime.class, SingletonArgumentInfo.a(ArgumentTime::a));
        map.put(ResourceOrTagLocationArgument.class, new ResourceOrTagLocationArgument.a());
        map.put(ResourceKeyArgument.class, new ResourceKeyArgument.a());
        map.put(TemplateMirrorArgument.class, SingletonArgumentInfo.a(TemplateMirrorArgument::a));
        map.put(TemplateRotationArgument.class, SingletonArgumentInfo.a(TemplateRotationArgument::a));
        map.put(ArgumentUUID.class, SingletonArgumentInfo.a(ArgumentUUID::a));
    }

    public World getWorldForCSS(CommandListenerWrapper clw) {
        return new WorldMock();
    }

    public SimpleCommandMap getSimpleCommandMap() {
        return null;
    }

    public void addToHelpMap(Map<String, HelpTopic> helpTopicsToAdd) {
    }

    public String convert(ItemStack is) {
        return null;
    }

    public String convert(ParticleData<?> particle) {
        return null;
    }

    public HelpTopic generateHelpTopic(String commandName, String shortDescription, String fullDescription, String permission) {
        return null;
    }

    public SuggestionProvider<CommandListenerWrapper> getSuggestionProvider(SuggestionProviders provider) {
        return null;
    }

    public boolean isVanillaCommandWrapper(Command command) {
        return false;
    }

    public void reloadDataPacks() {
    }

    public void resendPackets(Player player) {
    }

    public SimpleFunctionWrapper getFunction(NamespacedKey key) {
        return null;
    }

    public Set<NamespacedKey> getFunctions() {
        return null;
    }

    public SimpleFunctionWrapper[] getTag(NamespacedKey key) {
        return null;
    }

    public Set<NamespacedKey> getTags() {
        return null;
    }
}

