/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.arguments;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.arguments.CommandAPIArgumentType;
import dev.jorel.commandapi.arguments.LocationType;
import dev.jorel.commandapi.arguments.SafeOverrideableArgument;
import dev.jorel.commandapi.nms.NMS;
import dev.jorel.commandapi.wrappers.Location2D;

public class Location2DArgument
extends SafeOverrideableArgument<Location2D> {
    private final boolean isPrecise;

    public Location2DArgument(String nodeName) {
        this(nodeName, LocationType.PRECISE_POSITION);
    }

    public Location2DArgument(String nodeName, LocationType type) {
        super(nodeName, type == LocationType.BLOCK_POSITION ? CommandAPIHandler.getInstance().getNMS()._ArgumentPosition2D() : CommandAPIHandler.getInstance().getNMS()._ArgumentVec2(), type == LocationType.BLOCK_POSITION ? l -> l.getBlockX() + " " + l.getBlockZ() : l -> l.getX() + " " + l.getZ());
        this.isPrecise = type == LocationType.PRECISE_POSITION;
    }

    public LocationType getLocationType() {
        return this.isPrecise ? LocationType.PRECISE_POSITION : LocationType.BLOCK_POSITION;
    }

    @Override
    public Class<?> getPrimitiveType() {
        return Location2D.class;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.LOCATION_2D;
    }

    public <CommandListenerWrapper> Object parseArgument(NMS<CommandListenerWrapper> nms, CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return this.isPrecise ? nms.getLocation2DPrecise(cmdCtx, key) : nms.getLocation2DBlock(cmdCtx, key);
    }
}

