/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.arguments;

import dev.jorel.commandapi.IStringTooltip;
import dev.jorel.commandapi.SuggestionInfo;
import dev.jorel.commandapi.Tooltip;
import dev.jorel.commandapi.arguments.ArgumentSuggestions;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

@FunctionalInterface
public interface SafeSuggestions<S> {
    public ArgumentSuggestions toSuggestions(Function<S, String> var1);

    public static <T> SafeSuggestions<T> empty() {
        return mapper -> ArgumentSuggestions.empty();
    }

    @SafeVarargs
    public static <T> SafeSuggestions<T> suggest(T ... suggestions) {
        return mapper -> ArgumentSuggestions.strings(SafeSuggestions.toStrings(mapper, suggestions));
    }

    public static <T> SafeSuggestions<T> suggest(Function<SuggestionInfo, T[]> suggestions) {
        return mapper -> ArgumentSuggestions.strings(info -> SafeSuggestions.toStrings(mapper, (Object[])suggestions.apply((SuggestionInfo)info)));
    }

    public static <T> SafeSuggestions<T> suggestAsync(Function<SuggestionInfo, CompletableFuture<T[]>> suggestions) {
        return mapper -> ArgumentSuggestions.stringsAsync(info -> ((CompletableFuture)suggestions.apply((SuggestionInfo)info)).thenApply(items -> SafeSuggestions.toStrings(mapper, items)));
    }

    @SafeVarargs
    public static <T> SafeSuggestions<T> tooltips(Tooltip<T> ... suggestions) {
        return mapper -> ArgumentSuggestions.stringsWithTooltips(SafeSuggestions.toStringsWithTooltips(mapper, suggestions));
    }

    public static <T> SafeSuggestions<T> tooltips(Function<SuggestionInfo, Tooltip<T>[]> suggestions) {
        return mapper -> ArgumentSuggestions.stringsWithTooltips(info -> SafeSuggestions.toStringsWithTooltips(mapper, (Tooltip[])suggestions.apply((SuggestionInfo)info)));
    }

    public static <T> SafeSuggestions<T> tooltipsAsync(Function<SuggestionInfo, CompletableFuture<Tooltip<T>[]>> suggestions) {
        return mapper -> ArgumentSuggestions.stringsWithTooltipsAsync(info -> ((CompletableFuture)suggestions.apply((SuggestionInfo)info)).thenApply(items -> SafeSuggestions.toStringsWithTooltips(mapper, items)));
    }

    @SafeVarargs
    private static <T> String[] toStrings(Function<T, String> mapper, T ... suggestions) {
        String[] strings = new String[suggestions.length];
        for (int i = 0; i < suggestions.length; ++i) {
            strings[i] = mapper.apply(suggestions[i]);
        }
        return strings;
    }

    @SafeVarargs
    private static <T> IStringTooltip[] toStringsWithTooltips(Function<T, String> mapper, Tooltip<T> ... suggestions) {
        IStringTooltip[] stringsWithTooltips = new IStringTooltip[suggestions.length];
        for (int i = 0; i < suggestions.length; ++i) {
            stringsWithTooltips[i] = Tooltip.build(mapper).apply(suggestions[i]);
        }
        return stringsWithTooltips;
    }
}

