/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi;

import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.exceptions.UnsupportedVersionException;
import dev.jorel.commandapi.nms.NMS;
import dev.jorel.commandapi.nms.NMS_1_17_R1;
import dev.jorel.commandapi.nms.NMS_1_18_R1;
import dev.jorel.commandapi.nms.NMS_1_18_R2;

public interface CommandAPIVersionHandler {
    public static NMS<?> getNMS(String version) {
        if (CommandAPI.getConfiguration().shouldUseLatestNMSVersion()) {
            return new NMS_1_18_R2();
        }
        switch (version) {
            case "1.17": 
            case "1.17.1": {
                return new NMS_1_17_R1();
            }
            case "1.18": 
            case "1.18.1": {
                return new NMS_1_18_R1();
            }
            case "1.18.2": {
                return new NMS_1_18_R2();
            }
        }
        throw new UnsupportedVersionException("This version of Minecraft is unsupported: " + version);
    }
}

