/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.arguments;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.jorel.commandapi.IStringTooltip;
import dev.jorel.commandapi.StringTooltip;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.ArgumentSuggestions;
import dev.jorel.commandapi.arguments.CommandAPIArgumentType;
import dev.jorel.commandapi.arguments.IGreedyArgument;
import dev.jorel.commandapi.nms.NMS;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.bukkit.command.CommandSender;

public class ListArgument<T>
extends Argument<List>
implements IGreedyArgument {
    private final String delimiter;
    private final boolean allowDuplicates;
    private final Function<CommandSender, Collection<T>> supplier;
    private final Function<T, IStringTooltip> mapper;

    ListArgument(String nodeName, String delimiter, boolean allowDuplicates, Function<CommandSender, Collection<T>> supplier, Function<T, IStringTooltip> suggestionsMapper) {
        super(nodeName, (ArgumentType<?>)StringArgumentType.greedyString());
        this.delimiter = delimiter;
        this.allowDuplicates = allowDuplicates;
        this.supplier = supplier;
        this.mapper = suggestionsMapper;
        this.applySuggestions();
    }

    private void applySuggestions() {
        this.replaceSuggestions(ArgumentSuggestions.stringsWithTooltips(info -> {
            String currentArg = info.currentArg();
            HashSet<IStringTooltip> values = new HashSet<IStringTooltip>();
            for (Object object : this.supplier.apply(info.sender())) {
                values.add(this.mapper.apply(object));
            }
            ArrayList<T> currentArgList = new ArrayList<T>();
            for (T t : currentArg.split(Pattern.quote(this.delimiter))) {
                currentArgList.add(t);
            }
            if (!this.allowDuplicates) {
                for (String str : currentArgList) {
                    IStringTooltip valueToRemove = null;
                    for (IStringTooltip value : values) {
                        if (!value.getSuggestion().equals(str)) continue;
                        valueToRemove = value;
                        break;
                    }
                    if (valueToRemove == null) continue;
                    values.remove(valueToRemove);
                }
            }
            if (currentArg.endsWith(this.delimiter)) {
                IStringTooltip[] returnValues = new IStringTooltip[values.size()];
                int i = 0;
                for (IStringTooltip iStringTooltip : values) {
                    returnValues[i] = StringTooltip.of(currentArg + iStringTooltip.getSuggestion(), iStringTooltip.getTooltip());
                    ++i;
                }
                return returnValues;
            }
            String valueStart = (String)currentArgList.remove(currentArgList.size() - 1);
            String suggestionBase = currentArgList.isEmpty() ? "" : String.join((CharSequence)this.delimiter, currentArgList) + this.delimiter;
            ArrayList<StringTooltip> returnValues = new ArrayList<StringTooltip>();
            for (IStringTooltip str : values) {
                if (!str.getSuggestion().startsWith(valueStart)) continue;
                returnValues.add(StringTooltip.of(suggestionBase + str.getSuggestion(), str.getTooltip()));
            }
            return returnValues.toArray(new IStringTooltip[0]);
        }));
    }

    @Override
    public Class<List> getPrimitiveType() {
        return List.class;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.LIST;
    }

    @Override
    public <CommandListenerWrapper> List<T> parseArgument(NMS<CommandListenerWrapper> nms, CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        String[] strArr;
        HashMap<IStringTooltip, T> values = new HashMap<IStringTooltip, T>();
        for (T object : this.supplier.apply(nms.getCommandSenderFromCSS(cmdCtx.getSource()))) {
            values.put(this.mapper.apply(object), object);
        }
        ArrayList list = new ArrayList();
        for (String str : strArr = ((String)cmdCtx.getArgument(key, String.class)).split(Pattern.quote(this.delimiter))) {
            for (IStringTooltip value : values.keySet()) {
                if (!value.getSuggestion().equals(str)) continue;
                if (this.allowDuplicates) {
                    list.add(values.get(value));
                    continue;
                }
                if (list.contains(values.get(value))) continue;
                list.add(values.get(value));
            }
        }
        return list;
    }
}

