/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi;

import dev.jorel.commandapi.AdvancedConverter;
import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.Converter;
import dev.jorel.commandapi.InternalConfig;
import dev.jorel.commandapi.nbtapi.NBTContainer;
import dev.jorel.commandapi.nbtapi.utils.MinecraftVersion;
import java.io.File;
import java.util.Map;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class CommandAPIMain
extends JavaPlugin {
    public void onLoad() {
        MinecraftVersion.disableBStats();
        MinecraftVersion.disableUpdateCheck();
        this.saveDefaultConfig();
        CommandAPI.config = new InternalConfig(this.getConfig(), NBTContainer.class, NBTContainer::new, new File(this.getDataFolder(), "command_registration.json"));
        CommandAPI.logger = this.getLogger();
        CommandAPIHandler.getInstance().checkDependencies();
        for (Map.Entry<JavaPlugin, String[]> pluginToConvert : CommandAPI.config.getPluginsToConvert()) {
            if (pluginToConvert.getValue().length == 0) {
                Converter.convert(pluginToConvert.getKey());
                continue;
            }
            for (String command : pluginToConvert.getValue()) {
                new AdvancedConverter(pluginToConvert.getKey(), command).convert();
            }
        }
        for (String commandName : CommandAPI.config.getCommandsToConvert()) {
            new AdvancedConverter(commandName).convertCommand();
        }
    }

    public void onEnable() {
        CommandAPI.onEnable((Plugin)this);
    }
}

