/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.CommandMetaData;
import dev.jorel.commandapi.ExecutableCommand;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.IGreedyArgument;
import dev.jorel.commandapi.arguments.MultiLiteralArgument;
import dev.jorel.commandapi.exceptions.GreedyArgumentException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CommandAPICommand
extends ExecutableCommand<CommandAPICommand> {
    private List<Argument<?>> args = new ArrayList();
    private List<CommandAPICommand> subcommands = new ArrayList<CommandAPICommand>();
    private boolean isConverted = false;

    public CommandAPICommand(String commandName) {
        super(commandName);
    }

    protected CommandAPICommand(CommandMetaData metaData) {
        super(metaData);
    }

    public CommandAPICommand withArguments(List<Argument<?>> args) {
        this.args.addAll(args);
        return this;
    }

    public CommandAPICommand withArguments(Argument<?> ... args) {
        this.args.addAll(Arrays.asList(args));
        return this;
    }

    public CommandAPICommand withSubcommand(CommandAPICommand subcommand) {
        this.subcommands.add(subcommand);
        return this;
    }

    public CommandAPICommand withSubcommands(CommandAPICommand ... subcommands) {
        this.subcommands.addAll(Arrays.asList(subcommands));
        return this;
    }

    public List<Argument<?>> getArguments() {
        return this.args;
    }

    public void setArguments(List<Argument<?>> args) {
        this.args = args;
    }

    public List<CommandAPICommand> getSubcommands() {
        return this.subcommands;
    }

    public void setSubcommands(List<CommandAPICommand> subcommands) {
        this.subcommands = subcommands;
    }

    public boolean isConverted() {
        return this.isConverted;
    }

    CommandAPICommand setConverted(boolean isConverted) {
        this.isConverted = isConverted;
        return this;
    }

    private void flatten(CommandAPICommand rootCommand, List<Argument<?>> prevArguments, CommandAPICommand subcommand) {
        String[] literals = new String[subcommand.meta.aliases.length + 1];
        literals[0] = subcommand.meta.commandName;
        System.arraycopy(subcommand.meta.aliases, 0, literals, 1, subcommand.meta.aliases.length);
        MultiLiteralArgument literal = (MultiLiteralArgument)new MultiLiteralArgument(literals).withPermission(subcommand.meta.permission).withRequirement(subcommand.meta.requirements).setListed(false);
        prevArguments.add(literal);
        if (subcommand.executor.hasAnyExecutors()) {
            rootCommand.args = prevArguments;
            rootCommand.withArguments(subcommand.args);
            rootCommand.executor = subcommand.executor;
            rootCommand.subcommands = new ArrayList<CommandAPICommand>();
            rootCommand.register();
        }
        for (CommandAPICommand subsubcommand : new ArrayList<CommandAPICommand>(subcommand.subcommands)) {
            this.flatten(rootCommand, new ArrayList(prevArguments), subsubcommand);
        }
    }

    @Override
    public void register() {
        if (!CommandAPI.canRegister()) {
            CommandAPI.logWarning("Command /" + this.meta.commandName + " is being registered after the server had loaded. Undefined behavior ahead!");
        }
        try {
            Argument[] argumentsArr = this.args == null ? new Argument[]{} : this.args.toArray(new Argument[0]);
            int numGreedyArgs = 0;
            for (int i = 0; i < argumentsArr.length; ++i) {
                if (!(argumentsArr[i] instanceof IGreedyArgument) || ++numGreedyArgs <= 1 && i == argumentsArr.length - 1) continue;
                throw new GreedyArgumentException(argumentsArr);
            }
            for (Argument argument : argumentsArr) {
                if (argument.getArgumentPermission() != null) continue;
                argument.withPermission(this.meta.permission);
            }
            if (this.executor.hasAnyExecutors()) {
                CommandAPIHandler.getInstance().register(this.meta, argumentsArr, this.executor, this.isConverted);
            }
            for (CommandAPICommand subcommand : this.subcommands) {
                this.flatten(this, new ArrayList(), subcommand);
            }
        }
        catch (CommandSyntaxException | IOException e) {
            e.printStackTrace();
        }
    }
}

