/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi;

import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.nms.NMS;
import io.papermc.paper.event.server.ServerResourcesReloadedEvent;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandMap;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class PaperImplementations {
    private final boolean isPaperPresent;
    private final NMS<?> nmsInstance;

    public PaperImplementations(boolean isPaperPresent, NMS<?> nmsInstance) {
        this.isPaperPresent = isPaperPresent;
        this.nmsInstance = nmsInstance;
    }

    public void registerReloadHandler(Plugin plugin) {
        if (this.isPaperPresent) {
            Bukkit.getServer().getPluginManager().registerEvents(new Listener(){

                @EventHandler
                public void onServerReloadResources(ServerResourcesReloadedEvent event) {
                    CommandAPI.logNormal("/minecraft:reload detected. Reloading CommandAPI commands!");
                    PaperImplementations.this.nmsInstance.reloadDataPacks();
                }
            }, plugin);
        }
    }

    public CommandMap getCommandMap() {
        if (this.isPaperPresent) {
            return Bukkit.getServer().getCommandMap();
        }
        return this.nmsInstance.getSimpleCommandMap();
    }

    public boolean isPresent() {
        return this.isPaperPresent;
    }
}

