/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.jorel.commandapi.IStringTooltip;
import dev.jorel.commandapi.StringTooltip;
import dev.jorel.commandapi.SuggestionInfo;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.CommandAPIArgumentType;
import dev.jorel.commandapi.arguments.IGreedyArgument;
import dev.jorel.commandapi.nms.NMS;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.bukkit.command.CommandSender;

public class ListArgument<T>
extends Argument<List>
implements IGreedyArgument {
    private final String delimiter;
    private final boolean allowDuplicates;
    private final Function<CommandSender, Collection<T>> supplier;
    private final Function<T, IStringTooltip> mapper;

    ListArgument(String nodeName, String delimiter, boolean allowDuplicates, Function<CommandSender, Collection<T>> supplier, Function<T, IStringTooltip> suggestionsMapper) {
        super(nodeName, (ArgumentType<?>)StringArgumentType.greedyString());
        this.delimiter = delimiter;
        this.allowDuplicates = allowDuplicates;
        this.supplier = supplier;
        this.mapper = suggestionsMapper;
        this.applySuggestions();
    }

    private void applySuggestions() {
        this.replaceSuggestions((SuggestionInfo info, SuggestionsBuilder builder) -> {
            String currentArg = info.currentArg();
            HashSet<IStringTooltip> values = new HashSet<IStringTooltip>();
            for (T object : this.supplier.apply(info.sender())) {
                values.add(this.mapper.apply(object));
            }
            String[] splitArguments = currentArg.split(Pattern.quote(this.delimiter));
            String lastArgument = splitArguments[splitArguments.length - 1];
            if (!currentArg.endsWith(this.delimiter)) {
                if (values.stream().map(IStringTooltip::getSuggestion).anyMatch(lastArgument::equals)) {
                    values.add(StringTooltip.of(lastArgument + this.delimiter, null));
                }
            }
            if (!this.allowDuplicates) {
                for (String str : splitArguments) {
                    IStringTooltip valueToRemove = null;
                    for (IStringTooltip value : values) {
                        if (!value.getSuggestion().equals(str)) continue;
                        valueToRemove = value;
                        break;
                    }
                    if (valueToRemove == null) continue;
                    values.remove(valueToRemove);
                }
            }
            if (currentArg.contains(this.delimiter)) {
                builder = builder.createOffset(builder.getStart() + currentArg.lastIndexOf(this.delimiter) + this.delimiter.length());
            }
            for (IStringTooltip str : values) {
                if (!str.getSuggestion().startsWith(builder.getRemaining())) continue;
                if (str.getTooltip() == null) {
                    builder.suggest(str.getSuggestion());
                    continue;
                }
                builder.suggest(str.getSuggestion(), (Message)new LiteralMessage(str.getTooltip()));
            }
            return builder.buildFuture();
        });
    }

    @Override
    public Class<List> getPrimitiveType() {
        return List.class;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.LIST;
    }

    @Override
    public <CommandListenerWrapper> List<T> parseArgument(NMS<CommandListenerWrapper> nms, CommandContext<CommandListenerWrapper> cmdCtx, String key, Object[] previousArgs) throws CommandSyntaxException {
        HashMap<IStringTooltip, T> values = new HashMap<IStringTooltip, T>();
        for (T object : this.supplier.apply(nms.getCommandSenderFromCSS(cmdCtx.getSource()))) {
            values.put(this.mapper.apply(object), object);
        }
        ArrayList list = new ArrayList();
        String argument = (String)cmdCtx.getArgument(key, String.class);
        String[] strArr = argument.split(Pattern.quote(this.delimiter));
        StringReader context = new StringReader(argument);
        int cursor = 0;
        for (String str : strArr) {
            boolean addedItem = false;
            for (IStringTooltip value : values.keySet()) {
                if (!value.getSuggestion().equals(str)) continue;
                if (this.allowDuplicates) {
                    list.add(values.get(value));
                } else if (!list.contains(values.get(value))) {
                    list.add(values.get(value));
                } else {
                    context.setCursor(cursor);
                    throw new SimpleCommandExceptionType((Message)new LiteralMessage("Duplicate arguments are not allowed")).createWithContext((ImmutableStringReader)context);
                }
                addedItem = true;
            }
            if (!addedItem) {
                context.setCursor(cursor);
                throw new SimpleCommandExceptionType((Message)new LiteralMessage("Item is not allowed in list")).createWithContext((ImmutableStringReader)context);
            }
            cursor += str.length() + this.delimiter.length();
        }
        return list;
    }
}

