/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.nms;

import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.arguments.PreviewInfo;
import dev.jorel.commandapi.exceptions.WrapperCommandSyntaxException;
import dev.jorel.commandapi.nms.NMS;
import dev.jorel.commandapi.wrappers.PreviewableFunction;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.ChatPreviewCache;
import net.minecraft.network.chat.ChatPreviewThrottler;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundChatPreviewPacket;
import net.minecraft.network.protocol.game.ServerboundChatPreviewPacket;
import net.minecraft.server.network.PlayerConnection;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class NMS_1_19_1_R1_ChatPreviewHandler
extends ChannelDuplexHandler {
    private final NMS<CommandListenerWrapper> nms;
    private final Plugin plugin;
    private final Player player;
    private final NetworkManager connection;
    ChatPreviewThrottler throttler;

    public NMS_1_19_1_R1_ChatPreviewHandler(NMS<CommandListenerWrapper> nms, Plugin plugin, Player player) {
        this.nms = nms;
        this.plugin = plugin;
        this.player = player;
        this.connection = ((CraftPlayer)player).getHandle().b.b;
        try {
            Field f = PlayerConnection.class.getDeclaredField("M");
            f.setAccessible(true);
            this.throttler = (ChatPreviewThrottler)f.get(((CraftPlayer)player).getHandle().b);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ServerboundChatPreviewPacket chatPreview;
        if (msg instanceof ServerboundChatPreviewPacket && !(chatPreview = (ServerboundChatPreviewPacket)msg).c().isEmpty() && chatPreview.c().charAt(0) == '/') {
            this.throttler.a(new ChatPreviewThrottler.a(){

                public CompletableFuture<?> run() {
                    int i = chatPreview.b();
                    String s = chatPreview.c();
                    return NMS_1_19_1_R1_ChatPreviewHandler.this.generateComponentToSend(s).thenAccept(component -> NMS_1_19_1_R1_ChatPreviewHandler.this.connection.a((Packet)new ClientboundChatPreviewPacket(i, component), PacketSendListener.a(() -> new ClientboundChatPreviewPacket(i, null))));
                }
            });
            return;
        }
        super.channelRead(ctx, msg);
    }

    private CompletableFuture<IChatBaseComponent> generateComponentToSend(String chatPreviewQuery) {
        CompletableFuture<IChatBaseComponent> result = new CompletableFuture<IChatBaseComponent>();
        Bukkit.getScheduler().runTask(this.plugin, () -> {
            String fullInput = chatPreviewQuery.substring(1);
            ParseResults results = this.nms.getBrigadierDispatcher().parse(fullInput, (Object)((CraftPlayer)this.player).getHandle().cT());
            ArrayList<String> path = new ArrayList<String>();
            for (ParsedCommandNode commandNode : results.getContext().getNodes()) {
                path.add(commandNode.getNode().getName());
            }
            Optional<PreviewableFunction<?>> preview = CommandAPIHandler.getInstance().lookupPreviewable(path);
            if (preview.isPresent()) {
                String jsonToSend;
                String input = ((ParsedCommandNode)results.getContext().getNodes().get(results.getContext().getNodes().size() - 1)).getRange().get(fullInput);
                Component component = null;
                try {
                    PreviewInfo<Component> previewInfo;
                    if (CommandAPIHandler.getInstance().lookupPreviewableLegacyStatus(path)) {
                        parsedInput = null;
                        try {
                            parsedInput = this.nms.getChat((CommandContext<CommandListenerWrapper>)results.getContext().build(fullInput), (String)path.get(path.size() - 1));
                        }
                        catch (CommandSyntaxException e) {
                            throw new WrapperCommandSyntaxException(e);
                        }
                        previewInfo = new PreviewInfo<Component>(this.player, input, chatPreviewQuery, parsedInput);
                    } else {
                        parsedInput = null;
                        try {
                            parsedInput = this.nms.getAdventureChat((CommandContext<CommandListenerWrapper>)results.getContext().build(fullInput), (String)path.get(path.size() - 1));
                        }
                        catch (CommandSyntaxException e) {
                            throw new WrapperCommandSyntaxException(e);
                        }
                        previewInfo = new PreviewInfo<Component>(this.player, input, chatPreviewQuery, parsedInput);
                    }
                    component = preview.get().generatePreview(previewInfo);
                }
                catch (WrapperCommandSyntaxException e) {
                    component = TextComponent.fromLegacyText((String)(e.getMessage() == null ? "" : e.getMessage()));
                }
                if (component == null) throw new NullPointerException("Returned value from chat preview was null");
                if (component instanceof BaseComponent[]) {
                    Component baseComponent = component;
                    jsonToSend = ComponentSerializer.toString((BaseComponent[])baseComponent);
                } else {
                    if (!CommandAPIHandler.getInstance().getPaper().isPresent()) throw new IllegalArgumentException("Unexpected type returned from chat preview, got: " + component.getClass().getSimpleName());
                    if (!(component instanceof Component)) throw new IllegalArgumentException("Unexpected type returned from chat preview, got: " + component.getClass().getSimpleName());
                    Component adventureComponent = component;
                    jsonToSend = (String)GsonComponentSerializer.gson().serialize(adventureComponent);
                }
                if (jsonToSend != null) {
                    result.complete((IChatBaseComponent)IChatBaseComponent.ChatSerializer.a((String)jsonToSend));
                }
            }
            result.complete(null);
        });
        result.thenAcceptAsync(component -> {
            try {
                Field f = PlayerConnection.class.getDeclaredField("L");
                f.setAccessible(true);
                ChatPreviewCache c2 = (ChatPreviewCache)f.get(((CraftPlayer)this.player).getHandle().b);
                c2.a(chatPreviewQuery.substring(1), component);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        return result;
    }
}

