/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ConfigPluginConverter {
    private boolean isLegacyConfig;
    private PluginToConvert[] pluginsToConvert;

    public ConfigPluginConverter(YamlConfiguration config) {
        boolean bl = this.isLegacyConfig = config.getList("plugins-to-convert") != null;
        if (!this.isLegacyConfig) {
            ArrayList<PluginToConvert> pluginsToConvertList = new ArrayList<PluginToConvert>();
            ConfigurationSection pluginsToConvertSection = config.getConfigurationSection("plugins-to-convert");
            for (String pluginName : pluginsToConvertSection.getKeys(false)) {
                Plugin plugin = Bukkit.getPluginManager().getPlugin(pluginName);
                if (plugin == null) {
                    new InvalidPluginException("Could not find a plugin " + pluginName + "! Has it been loaded properly?").printStackTrace();
                    Plugin[] plugins = Bukkit.getPluginManager().getPlugins();
                    String[] pluginNames = new String[plugins.length];
                    for (int i = 0; i < pluginNames.length; ++i) {
                        pluginNames[i] = plugins[i].getName();
                    }
                    System.out.println("Did you mean \"" + this.closestStringTo(pluginName, pluginNames) + "\"?");
                    continue;
                }
                if (!(plugin instanceof JavaPlugin)) {
                    new InvalidPluginException("Plugin " + pluginName + " is not a JavaPlugin!").printStackTrace();
                }
                if (pluginsToConvertSection.get(pluginName) == null) {
                    pluginsToConvertList.add(new PluginToConvert(pluginName, new CommandToConvert[0], true));
                    continue;
                }
                ArrayList<CommandToConvert> commandsToConvertList = new ArrayList<CommandToConvert>();
                ConfigurationSection commandsToConvertSection = pluginsToConvertSection.getConfigurationSection(pluginName);
                for (String commandToConvert : commandsToConvertSection.getKeys(false)) {
                    ArrayList arguments = new ArrayList();
                    ArrayList aliases = new ArrayList();
                    block13: for (String key : commandsToConvertSection.getKeys(false)) {
                        switch (key.toLowerCase()) {
                            case "argument": 
                            case "arguments": {
                                arguments.addAll(commandsToConvertSection.getStringList(key));
                                continue block13;
                            }
                            case "alias": 
                            case "aliases": {
                                aliases.addAll(commandsToConvertSection.getStringList(key));
                                continue block13;
                            }
                        }
                        System.out.println("Unexpected configuration entry:\n\n\t%s:\n\t\t%s:\n\t\t\t%s: <- [Here]\n\nDid you mean \"%s\"?\n".formatted(pluginName, commandToConvert, key, this.closestStringTo(key, "arguments", "aliases")));
                    }
                    commandsToConvertList.add(new CommandToConvert(commandToConvert, arguments.toArray(new String[0]), aliases.toArray(new String[0])));
                }
                pluginsToConvertList.add(new PluginToConvert(pluginName, commandsToConvertList.toArray(new CommandToConvert[0]), false));
            }
            this.pluginsToConvert = pluginsToConvertList.toArray(new PluginToConvert[0]);
        }
    }

    private String closestStringTo(String inputString, String ... possibleStrings) {
        ArrayList costMap = new ArrayList();
        for (String possibleString : possibleStrings) {
            String a = inputString.toLowerCase();
            String b = possibleString.toLowerCase();
            int[] costs = new int[b.length() + 1];
            for (int j = 0; j < costs.length; ++j) {
                costs[j] = j;
            }
            for (int i = 1; i <= a.length(); ++i) {
                costs[0] = i;
                int nw = i - 1;
                for (int j = 1; j <= b.length(); ++j) {
                    int cj = Math.min(1 + Math.min(costs[j], costs[j - 1]), a.charAt(i - 1) == b.charAt(j - 1) ? nw : nw + 1);
                    nw = costs[j];
                    costs[j] = cj;
                }
            }
            costMap.add(new AbstractMap.SimpleEntry<String, Integer>(possibleString, costs[b.length()]));
        }
        if (!costMap.isEmpty()) {
            costMap.sort(Map.Entry.comparingByValue());
            return (String)((Map.Entry)costMap.get(0)).getKey();
        }
        return null;
    }

    record PluginToConvert(String name, CommandToConvert[] commands, boolean convertAll) {
    }

    record CommandToConvert(String name, String[] arguments, String[] aliases) {
    }
}

