/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.arguments;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.ArgumentSubType;
import dev.jorel.commandapi.arguments.CommandAPIArgumentType;
import dev.jorel.commandapi.arguments.EntitySelector;
import dev.jorel.commandapi.nms.NMS;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class EntitySelectorArgument<T>
extends Argument<T> {
    private final EntitySelector selector;

    @Deprecated(forRemoval=true, since="8.7.0")
    public EntitySelectorArgument(String nodeName) {
        this(nodeName, EntitySelector.ONE_ENTITY);
    }

    @Deprecated(forRemoval=true, since="8.7.0")
    public EntitySelectorArgument(String nodeName, EntitySelector selector) {
        NMS<?> nMS = CommandAPIHandler.getInstance().getNMS();
        super(nodeName, nMS._ArgumentEntity(switch (selector) {
            default -> throw new IncompatibleClassChangeError();
            case EntitySelector.MANY_ENTITIES -> ArgumentSubType.ENTITYSELECTOR_MANY_ENTITIES;
            case EntitySelector.MANY_PLAYERS -> ArgumentSubType.ENTITYSELECTOR_MANY_PLAYERS;
            case EntitySelector.ONE_ENTITY -> ArgumentSubType.ENTITYSELECTOR_ONE_ENTITY;
            case EntitySelector.ONE_PLAYER -> ArgumentSubType.ENTITYSELECTOR_ONE_PLAYER;
        }));
        this.selector = selector;
    }

    @Override
    public Class<T> getPrimitiveType() {
        return switch (this.selector) {
            case EntitySelector.MANY_ENTITIES, EntitySelector.MANY_PLAYERS -> Collection.class;
            case EntitySelector.ONE_ENTITY -> Entity.class;
            case EntitySelector.ONE_PLAYER -> Player.class;
            default -> Collection.class;
        };
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.ENTITY_SELECTOR;
    }

    @Override
    public <CommandListenerWrapper> T parseArgument(NMS<CommandListenerWrapper> nms, CommandContext<CommandListenerWrapper> cmdCtx, String key, Object[] previousArgs) throws CommandSyntaxException {
        return (T)nms.getEntitySelector(cmdCtx, key, switch (this.selector) {
            default -> throw new IncompatibleClassChangeError();
            case EntitySelector.MANY_ENTITIES -> ArgumentSubType.ENTITYSELECTOR_MANY_ENTITIES;
            case EntitySelector.MANY_PLAYERS -> ArgumentSubType.ENTITYSELECTOR_MANY_PLAYERS;
            case EntitySelector.ONE_ENTITY -> ArgumentSubType.ENTITYSELECTOR_ONE_ENTITY;
            case EntitySelector.ONE_PLAYER -> ArgumentSubType.ENTITYSELECTOR_ONE_PLAYER;
        });
    }

    @Override
    @Deprecated
    public List<String> getEntityNames(Object argument) {
        return switch (this.selector) {
            case EntitySelector.MANY_ENTITIES -> {
                List entities = (List)argument;
                ArrayList<String> entityNames = new ArrayList<String>();
                for (Entity entity : entities) {
                    entityNames.add(entity.getName());
                }
                yield entityNames;
            }
            case EntitySelector.MANY_PLAYERS -> {
                List players = (List)argument;
                ArrayList<String> playerNames = new ArrayList<String>();
                for (Player player : players) {
                    playerNames.add(player.getName());
                }
                yield playerNames;
            }
            case EntitySelector.ONE_ENTITY -> {
                Entity entity = (Entity)argument;
                yield List.of(entity.getName());
            }
            case EntitySelector.ONE_PLAYER -> {
                Player player = (Player)argument;
                yield List.of(player.getName());
            }
            default -> throw new IllegalStateException("Invalid selector " + this.selector.name());
        };
    }

    public static class ManyPlayers
    extends Argument<Collection> {
        public ManyPlayers(String nodeName) {
            super(nodeName, CommandAPIHandler.getInstance().getNMS()._ArgumentEntity(ArgumentSubType.ENTITYSELECTOR_MANY_PLAYERS));
        }

        @Override
        public Class<Collection> getPrimitiveType() {
            return Collection.class;
        }

        @Override
        public CommandAPIArgumentType getArgumentType() {
            return CommandAPIArgumentType.ENTITY_SELECTOR;
        }

        @Override
        public <CommandSourceStack> Collection<Player> parseArgument(NMS<CommandSourceStack> nms, CommandContext<CommandSourceStack> cmdCtx, String key, Object[] previousArgs) throws CommandSyntaxException {
            return (Collection)nms.getEntitySelector(cmdCtx, key, ArgumentSubType.ENTITYSELECTOR_MANY_PLAYERS);
        }

        @Override
        public List<String> getEntityNames(Object argument) {
            ArrayList<String> playerNames = new ArrayList<String>();
            for (Player entity : (List)argument) {
                playerNames.add(entity.getName());
            }
            return playerNames;
        }
    }

    public static class ManyEntities
    extends Argument<Collection> {
        public ManyEntities(String nodeName) {
            super(nodeName, CommandAPIHandler.getInstance().getNMS()._ArgumentEntity(ArgumentSubType.ENTITYSELECTOR_MANY_ENTITIES));
        }

        @Override
        public Class<Collection> getPrimitiveType() {
            return Collection.class;
        }

        @Override
        public CommandAPIArgumentType getArgumentType() {
            return CommandAPIArgumentType.ENTITY_SELECTOR;
        }

        @Override
        public <CommandSourceStack> Collection<Entity> parseArgument(NMS<CommandSourceStack> nms, CommandContext<CommandSourceStack> cmdCtx, String key, Object[] previousArgs) throws CommandSyntaxException {
            return (Collection)nms.getEntitySelector(cmdCtx, key, ArgumentSubType.ENTITYSELECTOR_MANY_ENTITIES);
        }

        @Override
        public List<String> getEntityNames(Object argument) {
            ArrayList<String> entityNames = new ArrayList<String>();
            for (Entity entity : (List)argument) {
                entityNames.add(entity.getName());
            }
            return entityNames;
        }
    }

    public static class OnePlayer
    extends Argument<Player> {
        public OnePlayer(String nodeName) {
            super(nodeName, CommandAPIHandler.getInstance().getNMS()._ArgumentEntity(ArgumentSubType.ENTITYSELECTOR_ONE_PLAYER));
        }

        @Override
        public Class<Player> getPrimitiveType() {
            return Player.class;
        }

        @Override
        public CommandAPIArgumentType getArgumentType() {
            return CommandAPIArgumentType.ENTITY_SELECTOR;
        }

        @Override
        public <CommandSourceStack> Player parseArgument(NMS<CommandSourceStack> nms, CommandContext<CommandSourceStack> cmdCtx, String key, Object[] previousArgs) throws CommandSyntaxException {
            return (Player)nms.getEntitySelector(cmdCtx, key, ArgumentSubType.ENTITYSELECTOR_ONE_PLAYER);
        }

        @Override
        public List<String> getEntityNames(Object argument) {
            return List.of(((Player)argument).getName());
        }
    }

    public static class OneEntity
    extends Argument<Entity> {
        public OneEntity(String nodeName) {
            super(nodeName, CommandAPIHandler.getInstance().getNMS()._ArgumentEntity(ArgumentSubType.ENTITYSELECTOR_ONE_ENTITY));
        }

        @Override
        public Class<Entity> getPrimitiveType() {
            return Entity.class;
        }

        @Override
        public CommandAPIArgumentType getArgumentType() {
            return CommandAPIArgumentType.ENTITY_SELECTOR;
        }

        @Override
        public <CommandSourceStack> Entity parseArgument(NMS<CommandSourceStack> nms, CommandContext<CommandSourceStack> cmdCtx, String key, Object[] previousArgs) throws CommandSyntaxException {
            return (Entity)nms.getEntitySelector(cmdCtx, key, ArgumentSubType.ENTITYSELECTOR_ONE_ENTITY);
        }

        @Override
        public List<String> getEntityNames(Object argument) {
            return List.of(((Entity)argument).getName());
        }
    }
}

