/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.nms;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.arguments.ArgumentSubType;
import dev.jorel.commandapi.arguments.SuggestionProviders;
import dev.jorel.commandapi.exceptions.AngleArgumentException;
import dev.jorel.commandapi.exceptions.BiomeArgumentException;
import dev.jorel.commandapi.exceptions.TimeArgumentException;
import dev.jorel.commandapi.exceptions.UUIDArgumentException;
import dev.jorel.commandapi.nms.NMSWrapper_1_13_1;
import dev.jorel.commandapi.wrappers.FloatRange;
import dev.jorel.commandapi.wrappers.FunctionWrapper;
import dev.jorel.commandapi.wrappers.IntegerRange;
import dev.jorel.commandapi.wrappers.Location2D;
import dev.jorel.commandapi.wrappers.MathOperation;
import dev.jorel.commandapi.wrappers.NativeProxyCommandSender;
import dev.jorel.commandapi.wrappers.ParticleData;
import dev.jorel.commandapi.wrappers.Rotation;
import dev.jorel.commandapi.wrappers.ScoreboardSlot;
import dev.jorel.commandapi.wrappers.SimpleFunctionWrapper;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import net.minecraft.server.v1_13_R2.Advancement;
import net.minecraft.server.v1_13_R2.ArgumentBlockPredicate;
import net.minecraft.server.v1_13_R2.ArgumentChat;
import net.minecraft.server.v1_13_R2.ArgumentChatComponent;
import net.minecraft.server.v1_13_R2.ArgumentChatFormat;
import net.minecraft.server.v1_13_R2.ArgumentCriterionValue;
import net.minecraft.server.v1_13_R2.ArgumentDimension;
import net.minecraft.server.v1_13_R2.ArgumentEnchantment;
import net.minecraft.server.v1_13_R2.ArgumentEntity;
import net.minecraft.server.v1_13_R2.ArgumentEntitySummon;
import net.minecraft.server.v1_13_R2.ArgumentItemPredicate;
import net.minecraft.server.v1_13_R2.ArgumentItemStack;
import net.minecraft.server.v1_13_R2.ArgumentMathOperation;
import net.minecraft.server.v1_13_R2.ArgumentMinecraftKeyRegistered;
import net.minecraft.server.v1_13_R2.ArgumentMobEffect;
import net.minecraft.server.v1_13_R2.ArgumentNBTTag;
import net.minecraft.server.v1_13_R2.ArgumentParticle;
import net.minecraft.server.v1_13_R2.ArgumentPosition;
import net.minecraft.server.v1_13_R2.ArgumentProfile;
import net.minecraft.server.v1_13_R2.ArgumentRotation;
import net.minecraft.server.v1_13_R2.ArgumentRotationAxis;
import net.minecraft.server.v1_13_R2.ArgumentScoreboardCriteria;
import net.minecraft.server.v1_13_R2.ArgumentScoreboardObjective;
import net.minecraft.server.v1_13_R2.ArgumentScoreboardSlot;
import net.minecraft.server.v1_13_R2.ArgumentScoreboardTeam;
import net.minecraft.server.v1_13_R2.ArgumentScoreholder;
import net.minecraft.server.v1_13_R2.ArgumentTag;
import net.minecraft.server.v1_13_R2.ArgumentTile;
import net.minecraft.server.v1_13_R2.ArgumentVec2;
import net.minecraft.server.v1_13_R2.ArgumentVec2I;
import net.minecraft.server.v1_13_R2.ArgumentVec3;
import net.minecraft.server.v1_13_R2.BlockPosition;
import net.minecraft.server.v1_13_R2.CommandListenerWrapper;
import net.minecraft.server.v1_13_R2.CompletionProviders;
import net.minecraft.server.v1_13_R2.CriterionConditionValue;
import net.minecraft.server.v1_13_R2.CustomFunction;
import net.minecraft.server.v1_13_R2.CustomFunctionData;
import net.minecraft.server.v1_13_R2.DedicatedServer;
import net.minecraft.server.v1_13_R2.DimensionManager;
import net.minecraft.server.v1_13_R2.Entity;
import net.minecraft.server.v1_13_R2.EntityPlayer;
import net.minecraft.server.v1_13_R2.EntitySelector;
import net.minecraft.server.v1_13_R2.EntityTypes;
import net.minecraft.server.v1_13_R2.EnumChatFormat;
import net.minecraft.server.v1_13_R2.EnumDirection;
import net.minecraft.server.v1_13_R2.IBlockData;
import net.minecraft.server.v1_13_R2.IChatBaseComponent;
import net.minecraft.server.v1_13_R2.ICompletionProvider;
import net.minecraft.server.v1_13_R2.IRegistry;
import net.minecraft.server.v1_13_R2.IWorldReader;
import net.minecraft.server.v1_13_R2.LootTableRegistry;
import net.minecraft.server.v1_13_R2.MinecraftKey;
import net.minecraft.server.v1_13_R2.MinecraftServer;
import net.minecraft.server.v1_13_R2.ParticleParam;
import net.minecraft.server.v1_13_R2.ParticleParamBlock;
import net.minecraft.server.v1_13_R2.ParticleParamItem;
import net.minecraft.server.v1_13_R2.ParticleParamRedstone;
import net.minecraft.server.v1_13_R2.ShapeDetectorBlock;
import net.minecraft.server.v1_13_R2.Vec2F;
import net.minecraft.server.v1_13_R2.Vec3D;
import net.minecraft.server.v1_13_R2.World;
import org.bukkit.Axis;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.RemoteConsoleCommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.craftbukkit.v1_13_R2.CraftLootTable;
import org.bukkit.craftbukkit.v1_13_R2.CraftParticle;
import org.bukkit.craftbukkit.v1_13_R2.CraftServer;
import org.bukkit.craftbukkit.v1_13_R2.CraftSound;
import org.bukkit.craftbukkit.v1_13_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_13_R2.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_13_R2.command.CraftBlockCommandSender;
import org.bukkit.craftbukkit.v1_13_R2.command.ProxiedNativeCommandSender;
import org.bukkit.craftbukkit.v1_13_R2.command.VanillaCommandWrapper;
import org.bukkit.craftbukkit.v1_13_R2.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.v1_13_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_13_R2.entity.CraftMinecartCommand;
import org.bukkit.craftbukkit.v1_13_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_13_R2.help.CustomHelpTopic;
import org.bukkit.craftbukkit.v1_13_R2.help.SimpleHelpMap;
import org.bukkit.craftbukkit.v1_13_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_13_R2.potion.CraftPotionEffectType;
import org.bukkit.craftbukkit.v1_13_R2.util.CraftChatMessage;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.help.HelpTopic;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.loot.LootTable;
import org.bukkit.potion.PotionEffectType;

public class NMS_1_13_1
extends NMSWrapper_1_13_1 {
    protected static final MinecraftServer MINECRAFT_SERVER = ((CraftServer)Bukkit.getServer()).getServer();
    private static final VarHandle LootTableRegistry_e;
    private static final VarHandle SimpleHelpMap_helpTopics;
    private static final VarHandle ParticleParamBlock_c;
    private static final VarHandle ParticleParamItem_c;
    private static final VarHandle ParticleParamRedstone_f;

    protected static NamespacedKey fromMinecraftKey(MinecraftKey key) {
        return new NamespacedKey(key.b(), key.getKey());
    }

    @Override
    public ArgumentType<?> _ArgumentAngle() {
        throw new AngleArgumentException();
    }

    @Override
    public ArgumentType<?> _ArgumentAxis() {
        return ArgumentRotationAxis.a();
    }

    @Override
    public ArgumentType<?> _ArgumentBlockPredicate() {
        return ArgumentBlockPredicate.a();
    }

    @Override
    public ArgumentType<?> _ArgumentBlockState() {
        return ArgumentTile.a();
    }

    @Override
    public ArgumentType<?> _ArgumentChat() {
        return ArgumentChat.a();
    }

    @Override
    public ArgumentType<?> _ArgumentChatComponent() {
        return ArgumentChatComponent.a();
    }

    @Override
    public ArgumentType<?> _ArgumentChatFormat() {
        return ArgumentChatFormat.a();
    }

    @Override
    public ArgumentType<?> _ArgumentDimension() {
        return ArgumentDimension.a();
    }

    @Override
    public ArgumentType<?> _ArgumentEnvironment() {
        return ArgumentDimension.a();
    }

    @Override
    public ArgumentType<?> _ArgumentEnchantment() {
        return ArgumentEnchantment.a();
    }

    @Override
    public ArgumentType<?> _ArgumentEntity(ArgumentSubType subType) {
        return switch (subType) {
            case ArgumentSubType.ENTITYSELECTOR_MANY_ENTITIES -> ArgumentEntity.b();
            case ArgumentSubType.ENTITYSELECTOR_MANY_PLAYERS -> ArgumentEntity.d();
            case ArgumentSubType.ENTITYSELECTOR_ONE_ENTITY -> ArgumentEntity.a();
            case ArgumentSubType.ENTITYSELECTOR_ONE_PLAYER -> ArgumentEntity.c();
            default -> throw new IllegalArgumentException("Unexpected value: " + subType);
        };
    }

    @Override
    public ArgumentType<?> _ArgumentEntitySummon() {
        return ArgumentEntitySummon.a();
    }

    @Override
    public ArgumentType<?> _ArgumentFloatRange() {
        return new ArgumentCriterionValue.a();
    }

    @Override
    public ArgumentType<?> _ArgumentIntRange() {
        return new ArgumentCriterionValue.b();
    }

    @Override
    public ArgumentType<?> _ArgumentItemPredicate() {
        return ArgumentItemPredicate.a();
    }

    @Override
    public ArgumentType<?> _ArgumentItemStack() {
        return ArgumentItemStack.a();
    }

    @Override
    public ArgumentType<?> _ArgumentMathOperation() {
        return ArgumentMathOperation.a();
    }

    @Override
    public ArgumentType<?> _ArgumentMinecraftKeyRegistered() {
        return ArgumentMinecraftKeyRegistered.a();
    }

    @Override
    public ArgumentType<?> _ArgumentMobEffect() {
        return ArgumentMobEffect.a();
    }

    @Override
    public ArgumentType<?> _ArgumentNBTCompound() {
        return ArgumentNBTTag.a();
    }

    @Override
    public ArgumentType<?> _ArgumentParticle() {
        return ArgumentParticle.a();
    }

    @Override
    public ArgumentType<?> _ArgumentPosition() {
        return ArgumentPosition.a();
    }

    @Override
    public ArgumentType<?> _ArgumentPosition2D() {
        return ArgumentVec2I.a();
    }

    @Override
    public ArgumentType<?> _ArgumentProfile() {
        return ArgumentProfile.a();
    }

    @Override
    public ArgumentType<?> _ArgumentRotation() {
        return ArgumentRotation.a();
    }

    @Override
    public ArgumentType<?> _ArgumentScoreboardCriteria() {
        return ArgumentScoreboardCriteria.a();
    }

    @Override
    public ArgumentType<?> _ArgumentScoreboardObjective() {
        return ArgumentScoreboardObjective.a();
    }

    @Override
    public ArgumentType<?> _ArgumentScoreboardSlot() {
        return ArgumentScoreboardSlot.a();
    }

    @Override
    public ArgumentType<?> _ArgumentScoreboardTeam() {
        return ArgumentScoreboardTeam.a();
    }

    @Override
    public final ArgumentType<?> _ArgumentScoreholder(ArgumentSubType subType) {
        return switch (subType) {
            case ArgumentSubType.SCOREHOLDER_SINGLE -> ArgumentScoreholder.a();
            case ArgumentSubType.SCOREHOLDER_MULTIPLE -> ArgumentScoreholder.b();
            default -> throw new IllegalArgumentException("Unexpected value: " + subType);
        };
    }

    @Override
    public ArgumentType<?> _ArgumentSyntheticBiome() {
        throw new BiomeArgumentException();
    }

    @Override
    public ArgumentType<?> _ArgumentTag() {
        return ArgumentTag.a();
    }

    @Override
    public ArgumentType<?> _ArgumentTime() {
        throw new TimeArgumentException();
    }

    @Override
    public ArgumentType<?> _ArgumentUUID() {
        throw new UUIDArgumentException();
    }

    @Override
    public ArgumentType<?> _ArgumentVec2() {
        return ArgumentVec2.a();
    }

    @Override
    public ArgumentType<?> _ArgumentVec3() {
        return ArgumentVec3.a();
    }

    @Override
    public void addToHelpMap(Map<String, HelpTopic> helpTopicsToAdd) {
        Map helpTopics = SimpleHelpMap_helpTopics.get(Bukkit.getServer().getHelpMap());
        helpTopics.putAll(helpTopicsToAdd);
    }

    @Override
    public String[] compatibleVersions() {
        return new String[]{"1.13.1"};
    }

    @Override
    public String convert(ItemStack is) {
        return is.getType().getKey().toString() + CraftItemStack.asNMSCopy((ItemStack)is).getOrCreateTag().toString();
    }

    @Override
    public String convert(ParticleData<?> particle) {
        return CraftParticle.toNMS((Particle)particle.particle(), particle.data()).a();
    }

    @Override
    public String convert(PotionEffectType potion) {
        return potion.getName().toLowerCase(Locale.ENGLISH);
    }

    @Override
    public String convert(Sound sound) {
        return CraftSound.getSound((Sound)sound);
    }

    private SimpleFunctionWrapper convertFunction(CustomFunction customFunction) {
        ToIntFunction<CommandListenerWrapper> appliedObj = clw -> MINECRAFT_SERVER.getFunctionData().a(customFunction, clw);
        CustomFunction.c[] cArr = customFunction.b();
        String[] result = new String[cArr.length];
        int size = cArr.length;
        for (int i = 0; i < size; ++i) {
            result[i] = cArr[i].toString();
        }
        return new SimpleFunctionWrapper(NMS_1_13_1.fromMinecraftKey(customFunction.a()), appliedObj, result);
    }

    @Override
    public void createDispatcherFile(File file, CommandDispatcher<CommandListenerWrapper> dispatcher) {
        NMS_1_13_1.MINECRAFT_SERVER.vanillaCommandDispatcher.a(file);
    }

    @Override
    public HelpTopic generateHelpTopic(String commandName, String shortDescription, String fullDescription, String permission) {
        return new CustomHelpTopic(commandName, shortDescription, fullDescription, permission);
    }

    @Override
    public org.bukkit.advancement.Advancement getAdvancement(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return ArgumentMinecraftKeyRegistered.a(cmdCtx, (String)key).bukkit;
    }

    @Override
    public Component getAdventureChat(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        String jsonString = IChatBaseComponent.ChatSerializer.a((IChatBaseComponent)ArgumentChat.a(cmdCtx, (String)key));
        return GsonComponentSerializer.gson().deserialize((Object)jsonString);
    }

    @Override
    public Component getAdventureChatComponent(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        String jsonString = IChatBaseComponent.ChatSerializer.a((IChatBaseComponent)ArgumentChatComponent.a(cmdCtx, (String)key));
        return GsonComponentSerializer.gson().deserialize((Object)jsonString);
    }

    @Override
    public float getAngle(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        throw new AngleArgumentException();
    }

    @Override
    public EnumSet<Axis> getAxis(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        EnumSet<Axis> set = EnumSet.noneOf(Axis.class);
        EnumSet parsedEnumSet = ArgumentRotationAxis.a(cmdCtx, (String)key);
        for (EnumDirection.EnumAxis element : parsedEnumSet) {
            set.add(switch (element) {
                default -> throw new IncompatibleClassChangeError();
                case EnumDirection.EnumAxis.X -> Axis.X;
                case EnumDirection.EnumAxis.Y -> Axis.Y;
                case EnumDirection.EnumAxis.Z -> Axis.Z;
            });
        }
        return set;
    }

    @Override
    public Object getBiome(CommandContext<CommandListenerWrapper> cmdCtx, String key, ArgumentSubType subType) throws CommandSyntaxException {
        throw new BiomeArgumentException();
    }

    @Override
    public Predicate<Block> getBlockPredicate(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        Predicate predicate = ArgumentBlockPredicate.a(cmdCtx, (String)key);
        return block -> predicate.test(new ShapeDetectorBlock((IWorldReader)((CommandListenerWrapper)cmdCtx.getSource()).getWorld(), new BlockPosition(block.getX(), block.getY(), block.getZ()), true));
    }

    @Override
    public BlockData getBlockState(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return CraftBlockData.fromData((IBlockData)ArgumentTile.a(cmdCtx, (String)key).a());
    }

    @Override
    public CommandDispatcher<CommandListenerWrapper> getBrigadierDispatcher() {
        return NMS_1_13_1.MINECRAFT_SERVER.vanillaCommandDispatcher.a();
    }

    @Override
    public BaseComponent[] getChat(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return ComponentSerializer.parse((String)IChatBaseComponent.ChatSerializer.a((IChatBaseComponent)ArgumentChat.a(cmdCtx, (String)key)));
    }

    @Override
    public ChatColor getChatColor(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return CraftChatMessage.getColor((EnumChatFormat)ArgumentChatFormat.a(cmdCtx, (String)key));
    }

    @Override
    public BaseComponent[] getChatComponent(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return ComponentSerializer.parse((String)IChatBaseComponent.ChatSerializer.a((IChatBaseComponent)ArgumentChatComponent.a(cmdCtx, (String)key)));
    }

    @Override
    public CommandListenerWrapper getCLWFromCommandSender(CommandSender sender) {
        if (sender instanceof CraftPlayer) {
            CraftPlayer player = (CraftPlayer)sender;
            return player.getHandle().getCommandListener();
        }
        if (sender instanceof CraftBlockCommandSender) {
            CraftBlockCommandSender blockCommandSender = (CraftBlockCommandSender)sender;
            return blockCommandSender.getWrapper();
        }
        if (sender instanceof CraftMinecartCommand) {
            CraftMinecartCommand minecartCommandSender = (CraftMinecartCommand)sender;
            return minecartCommandSender.getHandle().getCommandBlock().getWrapper();
        }
        if (sender instanceof RemoteConsoleCommandSender) {
            return ((DedicatedServer)NMS_1_13_1.MINECRAFT_SERVER).remoteControlCommandListener.f();
        }
        if (sender instanceof ConsoleCommandSender) {
            return MINECRAFT_SERVER.getServerCommandListener();
        }
        if (sender instanceof ProxiedNativeCommandSender) {
            ProxiedNativeCommandSender proxiedCommandSender = (ProxiedNativeCommandSender)sender;
            return proxiedCommandSender.getHandle();
        }
        throw new IllegalArgumentException("Cannot make " + sender + " a vanilla command listener");
    }

    @Override
    public CommandSender getCommandSenderFromCSS(CommandListenerWrapper clw) {
        try {
            return clw.getBukkitSender();
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }

    @Override
    public org.bukkit.World getDimension(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return MINECRAFT_SERVER.getWorldServer(ArgumentDimension.a(cmdCtx, (String)key)).getWorld();
    }

    @Override
    public World.Environment getEnvironment(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        DimensionManager manager = ArgumentDimension.a(cmdCtx, (String)key);
        return switch (manager.getDimensionID()) {
            case 0 -> World.Environment.NORMAL;
            case -1 -> World.Environment.NETHER;
            case 1 -> World.Environment.THE_END;
            default -> null;
        };
    }

    @Override
    public Enchantment getEnchantment(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return new CraftEnchantment(ArgumentEnchantment.a(cmdCtx, (String)key));
    }

    @Override
    public Object getEntitySelector(CommandContext<CommandListenerWrapper> cmdCtx, String str, ArgumentSubType subType) throws CommandSyntaxException {
        EntitySelector argument = (EntitySelector)cmdCtx.getArgument(str, EntitySelector.class);
        try {
            CommandAPIHandler.getInstance().getField(EntitySelector.class, "m").set(argument, false);
        }
        catch (IllegalAccessException | IllegalArgumentException e1) {
            e1.printStackTrace();
        }
        return switch (subType) {
            case ArgumentSubType.ENTITYSELECTOR_MANY_ENTITIES -> {
                try {
                    ArrayList<CraftEntity> result = new ArrayList<CraftEntity>();
                    for (Entity entity : argument.b((CommandListenerWrapper)cmdCtx.getSource())) {
                        result.add(entity.getBukkitEntity());
                    }
                    ArrayList<CraftEntity> var5_6 = result;
                    yield var5_6;
                }
                catch (CommandSyntaxException e) {
                    CraftEntity var5_7;
                    yield var5_7 = new ArrayList();
                }
            }
            case ArgumentSubType.ENTITYSELECTOR_MANY_PLAYERS -> {
                try {
                    ArrayList<CraftPlayer> result = new ArrayList<CraftPlayer>();
                    for (EntityPlayer player : argument.d((CommandListenerWrapper)cmdCtx.getSource())) {
                        result.add(player.getBukkitEntity());
                    }
                    ArrayList<CraftPlayer> var5_8 = result;
                    yield var5_8;
                }
                catch (CommandSyntaxException e) {
                    ArrayList var5_9 = new ArrayList();
                    yield var5_9;
                }
            }
            case ArgumentSubType.ENTITYSELECTOR_ONE_ENTITY -> {
                CraftEntity var5_10;
                yield var5_10 = argument.a((CommandListenerWrapper)cmdCtx.getSource()).getBukkitEntity();
            }
            case ArgumentSubType.ENTITYSELECTOR_ONE_PLAYER -> {
                CraftPlayer var5_11 = argument.c((CommandListenerWrapper)cmdCtx.getSource()).getBukkitEntity();
                yield var5_11;
            }
            default -> throw new IllegalArgumentException("Unexpected value: " + subType);
        };
    }

    @Override
    public EntityType getEntityType(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return ((EntityTypes)IRegistry.ENTITY_TYPE.get(ArgumentEntitySummon.a(cmdCtx, (String)key))).a((World)((CraftWorld)this.getWorldForCSS((CommandListenerWrapper)cmdCtx.getSource())).getHandle()).getBukkitEntity().getType();
    }

    @Override
    public FloatRange getFloatRange(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        CriterionConditionValue.c range = (CriterionConditionValue.c)cmdCtx.getArgument(key, CriterionConditionValue.c.class);
        float low = range.a() == null ? -3.4028235E38f : ((Float)range.a()).floatValue();
        float high = range.b() == null ? Float.MAX_VALUE : ((Float)range.b()).floatValue();
        return new FloatRange(low, high);
    }

    @Override
    public FunctionWrapper[] getFunction(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        ArrayList<FunctionWrapper> result = new ArrayList<FunctionWrapper>();
        CommandListenerWrapper commandListenerWrapper = ((CommandListenerWrapper)cmdCtx.getSource()).a().b(2);
        for (CustomFunction customFunction : ArgumentTag.a(cmdCtx, (String)key)) {
            result.add(FunctionWrapper.fromSimpleFunctionWrapper(this.convertFunction(customFunction), commandListenerWrapper, e -> ((CommandListenerWrapper)cmdCtx.getSource()).a(((CraftEntity)e).getHandle())));
        }
        return result.toArray(new FunctionWrapper[0]);
    }

    @Override
    public SimpleFunctionWrapper getFunction(NamespacedKey key) {
        return this.convertFunction(MINECRAFT_SERVER.getFunctionData().a(new MinecraftKey(key.getNamespace(), key.getKey())));
    }

    @Override
    public Set<NamespacedKey> getFunctions() {
        HashSet<NamespacedKey> functions = new HashSet<NamespacedKey>();
        for (MinecraftKey key : MINECRAFT_SERVER.getFunctionData().c().keySet()) {
            functions.add(NMS_1_13_1.fromMinecraftKey(key));
        }
        return functions;
    }

    @Override
    public IntegerRange getIntRange(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        CriterionConditionValue.d range = ArgumentCriterionValue.b.a(cmdCtx, (String)key);
        int low = range.a() == null ? Integer.MIN_VALUE : (Integer)range.a();
        int high = range.b() == null ? Integer.MAX_VALUE : (Integer)range.b();
        return new IntegerRange(low, high);
    }

    @Override
    public ItemStack getItemStack(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return CraftItemStack.asBukkitCopy((net.minecraft.server.v1_13_R2.ItemStack)ArgumentItemStack.a(cmdCtx, (String)key).a(1, false));
    }

    @Override
    public Predicate<ItemStack> getItemStackPredicate(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        Predicate predicate = ArgumentItemPredicate.a(cmdCtx, (String)key);
        return item -> predicate.test(CraftItemStack.asNMSCopy((ItemStack)item));
    }

    @Override
    public Location2D getLocation2DBlock(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        ArgumentVec2I.a blockPos = ArgumentVec2I.a(cmdCtx, (String)key);
        return new Location2D(this.getWorldForCSS((CommandListenerWrapper)cmdCtx.getSource()), blockPos.a, blockPos.b);
    }

    @Override
    public Location2D getLocation2DPrecise(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        Vec2F vecPos = ArgumentVec2.a(cmdCtx, (String)key);
        return new Location2D(this.getWorldForCSS((CommandListenerWrapper)cmdCtx.getSource()), vecPos.i, vecPos.j);
    }

    @Override
    public Location getLocationBlock(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        BlockPosition blockPos = ArgumentPosition.a(cmdCtx, (String)key);
        return new Location(this.getWorldForCSS((CommandListenerWrapper)cmdCtx.getSource()), (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ());
    }

    @Override
    public Location getLocationPrecise(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        Vec3D vecPos = ArgumentVec3.a(cmdCtx, (String)key);
        return new Location(this.getWorldForCSS((CommandListenerWrapper)cmdCtx.getSource()), vecPos.x, vecPos.y, vecPos.z);
    }

    @Override
    public LootTable getLootTable(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        MinecraftKey minecraftKey = ArgumentMinecraftKeyRegistered.c(cmdCtx, (String)key);
        return new CraftLootTable(NMS_1_13_1.fromMinecraftKey(minecraftKey), MINECRAFT_SERVER.getLootTableRegistry().getLootTable(minecraftKey));
    }

    @Override
    public MathOperation getMathOperation(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        ArgumentMathOperation.a(cmdCtx, (String)key);
        return MathOperation.fromString(CommandAPIHandler.getRawArgumentInput(cmdCtx, key));
    }

    @Override
    public NamespacedKey getMinecraftKey(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        MinecraftKey resourceLocation = ArgumentMinecraftKeyRegistered.c(cmdCtx, (String)key);
        return new NamespacedKey(resourceLocation.b(), resourceLocation.getKey());
    }

    @Override
    public <NBTContainer> Object getNBTCompound(CommandContext<CommandListenerWrapper> cmdCtx, String key, Function<Object, NBTContainer> nbtContainerConstructor) {
        return nbtContainerConstructor.apply(ArgumentNBTTag.a(cmdCtx, (String)key));
    }

    @Override
    public String getObjective(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws IllegalArgumentException, CommandSyntaxException {
        return ArgumentScoreboardObjective.a(cmdCtx, (String)key).getName();
    }

    @Override
    public String getObjectiveCriteria(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return ArgumentScoreboardCriteria.a(cmdCtx, (String)key).getName();
    }

    @Override
    public OfflinePlayer getOfflinePlayer(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        OfflinePlayer target = Bukkit.getOfflinePlayer((UUID)((GameProfile)ArgumentProfile.a(cmdCtx, (String)key).iterator().next()).getId());
        if (target == null) {
            throw ArgumentProfile.a.create();
        }
        return target;
    }

    @Override
    public ParticleData<?> getParticle(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        ParticleParam particleOptions = ArgumentParticle.a(cmdCtx, (String)key);
        Particle particle = CraftParticle.toBukkit((ParticleParam)particleOptions);
        if (particleOptions instanceof ParticleParamBlock) {
            ParticleParamBlock options = (ParticleParamBlock)particleOptions;
            IBlockData blockData = ParticleParamBlock_c.get(options);
            return new ParticleData<CraftBlockData>(particle, CraftBlockData.fromData((IBlockData)blockData));
        }
        if (particleOptions instanceof ParticleParamRedstone) {
            ParticleParamRedstone options = (ParticleParamRedstone)particleOptions;
            return this.getParticleDataAsDustOptions(particle, options);
        }
        if (particleOptions instanceof ParticleParamItem) {
            ParticleParamItem options = (ParticleParamItem)particleOptions;
            return new ParticleData<ItemStack>(particle, CraftItemStack.asBukkitCopy((net.minecraft.server.v1_13_R2.ItemStack)ParticleParamItem_c.get(options)));
        }
        CommandAPI.getLogger().warning("Invalid particle data type for " + particle.getDataType().toString());
        return new ParticleData<Object>(particle, null);
    }

    private ParticleData<Particle.DustOptions> getParticleDataAsDustOptions(Particle particle, ParticleParamRedstone options) {
        String optionsStr = options.a();
        String[] optionsArr = optionsStr.split(" ");
        float red = Float.parseFloat(optionsArr[1]);
        float green = Float.parseFloat(optionsArr[2]);
        float blue = Float.parseFloat(optionsArr[3]);
        Color color = Color.fromRGB((int)((int)(red * 255.0f)), (int)((int)(green * 255.0f)), (int)((int)(blue * 255.0f)));
        return new ParticleData<Particle.DustOptions>(particle, new Particle.DustOptions(color, ParticleParamRedstone_f.get(options)));
    }

    @Override
    public Player getPlayer(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        Player target = Bukkit.getPlayer((UUID)((GameProfile)ArgumentProfile.a(cmdCtx, (String)key).iterator().next()).getId());
        if (target == null) {
            throw ArgumentProfile.a.create();
        }
        return target;
    }

    @Override
    public PotionEffectType getPotionEffect(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return new CraftPotionEffectType(ArgumentMobEffect.a(cmdCtx, (String)key));
    }

    @Override
    public Recipe getRecipe(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return ArgumentMinecraftKeyRegistered.b(cmdCtx, (String)key).toBukkitRecipe();
    }

    @Override
    public Rotation getRotation(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        Vec2F vec = ArgumentRotation.a(cmdCtx, (String)key).b((CommandListenerWrapper)cmdCtx.getSource());
        return new Rotation(vec.i, vec.j);
    }

    @Override
    public ScoreboardSlot getScoreboardSlot(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return new ScoreboardSlot(ArgumentScoreboardSlot.a(cmdCtx, (String)key));
    }

    @Override
    public Collection<String> getScoreHolderMultiple(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return ArgumentScoreholder.b(cmdCtx, (String)key);
    }

    @Override
    public String getScoreHolderSingle(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return ArgumentScoreholder.a(cmdCtx, (String)key);
    }

    @Override
    public CommandSender getSenderForCommand(CommandContext<CommandListenerWrapper> cmdCtx, boolean isNative) {
        CraftEntity proxy;
        CommandListenerWrapper clw = (CommandListenerWrapper)cmdCtx.getSource();
        CommandSender sender = clw.getBukkitSender();
        Vec3D pos = clw.getPosition();
        Vec2F rot = clw.i();
        org.bukkit.World world = this.getWorldForCSS(clw);
        Location location = new Location(world, pos.x, pos.y, pos.z, rot.j, rot.i);
        Entity proxyEntity = clw.f();
        CraftEntity craftEntity = proxy = proxyEntity == null ? null : proxyEntity.getBukkitEntity();
        if (isNative || proxy != null && !sender.equals(proxy)) {
            return new NativeProxyCommandSender(sender, (CommandSender)proxy, location, world);
        }
        return sender;
    }

    @Override
    public SimpleCommandMap getSimpleCommandMap() {
        return ((CraftServer)Bukkit.getServer()).getCommandMap();
    }

    @Override
    public final Object getSound(CommandContext<CommandListenerWrapper> cmdCtx, String key, ArgumentSubType subType) {
        MinecraftKey soundResource = ArgumentMinecraftKeyRegistered.c(cmdCtx, (String)key);
        return switch (subType) {
            case ArgumentSubType.SOUND_SOUND -> {
                for (CraftSound sound : CraftSound.values()) {
                    try {
                        if (!CommandAPIHandler.getInstance().getField(CraftSound.class, "minecraftKey").get(sound).equals(soundResource.getKey())) continue;
                        Sound var5_9 = Sound.valueOf((String)sound.name());
                        yield var5_9;
                    }
                    catch (IllegalAccessException | IllegalArgumentException e1) {
                        e1.printStackTrace();
                        Object var5_10 = null;
                        yield var5_10;
                    }
                }
                Object var5_11 = null;
                yield var5_11;
            }
            case ArgumentSubType.SOUND_NAMESPACEDKEY -> {
                NamespacedKey var5_12;
                yield var5_12 = NMS_1_13_1.fromMinecraftKey(soundResource);
            }
            default -> throw new IllegalArgumentException("Unexpected value: " + subType);
        };
    }

    @Override
    public SuggestionProvider<CommandListenerWrapper> getSuggestionProvider(SuggestionProviders provider) {
        return switch (provider) {
            case SuggestionProviders.FUNCTION -> (context, builder) -> {
                CustomFunctionData functionData = MINECRAFT_SERVER.getFunctionData();
                ICompletionProvider.a((Iterable)functionData.g().a(), (SuggestionsBuilder)builder, (String)"#");
                return ICompletionProvider.a(functionData.c().keySet(), (SuggestionsBuilder)builder);
            };
            case SuggestionProviders.RECIPES -> CompletionProviders.b;
            case SuggestionProviders.SOUNDS -> CompletionProviders.c;
            case SuggestionProviders.ADVANCEMENTS -> (cmdCtx, builder) -> ICompletionProvider.a(MINECRAFT_SERVER.getAdvancementData().b().stream().map(Advancement::getName), (SuggestionsBuilder)builder);
            case SuggestionProviders.LOOT_TABLES -> (cmdCtx, builder) -> {
                Map map = LootTableRegistry_e.get(MINECRAFT_SERVER.getLootTableRegistry());
                return ICompletionProvider.a(map.keySet(), (SuggestionsBuilder)builder);
            };
            case SuggestionProviders.ENTITIES -> CompletionProviders.d;
            default -> (context, builder) -> Suggestions.empty();
        };
    }

    @Override
    public SimpleFunctionWrapper[] getTag(NamespacedKey key) {
        ArrayList customFunctions = new ArrayList(MINECRAFT_SERVER.getFunctionData().g().b(new MinecraftKey(key.getNamespace(), key.getKey())).a());
        SimpleFunctionWrapper[] result = new SimpleFunctionWrapper[customFunctions.size()];
        int size = customFunctions.size();
        for (int i = 0; i < size; ++i) {
            result[i] = this.convertFunction((CustomFunction)customFunctions.get(i));
        }
        return result;
    }

    @Override
    public Set<NamespacedKey> getTags() {
        HashSet<NamespacedKey> functions = new HashSet<NamespacedKey>();
        for (MinecraftKey key : MINECRAFT_SERVER.getFunctionData().g().a()) {
            functions.add(NMS_1_13_1.fromMinecraftKey(key));
        }
        return functions;
    }

    @Override
    public String getTeam(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return ArgumentScoreboardTeam.a(cmdCtx, (String)key).getName();
    }

    @Override
    public int getTime(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        throw new TimeArgumentException();
    }

    @Override
    public UUID getUUID(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        throw new UUIDArgumentException();
    }

    @Override
    public org.bukkit.World getWorldForCSS(CommandListenerWrapper clw) {
        return clw.getWorld() == null ? null : clw.getWorld().getWorld();
    }

    @Override
    public boolean isVanillaCommandWrapper(Command command) {
        return command instanceof VanillaCommandWrapper;
    }

    @Override
    public void reloadDataPacks() {
    }

    @Override
    public void resendPackets(Player player) {
        MINECRAFT_SERVER.getCommandDispatcher().a(((CraftPlayer)player).getHandle());
    }

    @Override
    public Message generateMessageFromJson(String json) {
        return IChatBaseComponent.ChatSerializer.a((String)json);
    }

    static {
        VarHandle ltr_e = null;
        VarHandle shm_ht = null;
        VarHandle ppb_c = null;
        Object ppi_c = null;
        VarHandle ppr_g = null;
        try {
            ltr_e = MethodHandles.privateLookupIn(LootTableRegistry.class, MethodHandles.lookup()).findVarHandle(LootTableRegistry.class, "e", Map.class);
            shm_ht = MethodHandles.privateLookupIn(SimpleHelpMap.class, MethodHandles.lookup()).findVarHandle(SimpleHelpMap.class, "helpTopics", Map.class);
            ppb_c = MethodHandles.privateLookupIn(ParticleParamBlock.class, MethodHandles.lookup()).findVarHandle(ParticleParamBlock.class, "c", IBlockData.class);
            ppb_c = MethodHandles.privateLookupIn(ParticleParamItem.class, MethodHandles.lookup()).findVarHandle(ParticleParamItem.class, "c", net.minecraft.server.v1_13_R2.ItemStack.class);
            ppr_g = MethodHandles.privateLookupIn(ParticleParamRedstone.class, MethodHandles.lookup()).findVarHandle(ParticleParamRedstone.class, "f", Float.TYPE);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
        LootTableRegistry_e = ltr_e;
        SimpleHelpMap_helpTopics = shm_ht;
        ParticleParamBlock_c = ppb_c;
        ParticleParamItem_c = ppi_c;
        ParticleParamRedstone_f = ppr_g;
    }
}

