/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi;

import dev.jorel.commandapi.CommandAPIExecutor;
import dev.jorel.commandapi.exceptions.WrapperCommandSyntaxException;
import dev.jorel.commandapi.executors.CommandBlockCommandExecutor;
import dev.jorel.commandapi.executors.CommandBlockResultingCommandExecutor;
import dev.jorel.commandapi.executors.CommandExecutor;
import dev.jorel.commandapi.executors.ConsoleCommandExecutor;
import dev.jorel.commandapi.executors.ConsoleResultingCommandExecutor;
import dev.jorel.commandapi.executors.EntityCommandExecutor;
import dev.jorel.commandapi.executors.EntityResultingCommandExecutor;
import dev.jorel.commandapi.executors.ExecutorType;
import dev.jorel.commandapi.executors.NativeCommandExecutor;
import dev.jorel.commandapi.executors.NativeResultingCommandExecutor;
import dev.jorel.commandapi.executors.PlayerCommandExecutor;
import dev.jorel.commandapi.executors.PlayerResultingCommandExecutor;
import dev.jorel.commandapi.executors.ProxyCommandExecutor;
import dev.jorel.commandapi.executors.ProxyResultingCommandExecutor;
import dev.jorel.commandapi.executors.ResultingCommandExecutor;
import java.util.ArrayList;
import org.bukkit.command.CommandSender;

abstract class Executable<T extends Executable<T>> {
    protected CommandAPIExecutor<?> executor = new CommandAPIExecutor();

    Executable() {
    }

    public T executes(final CommandExecutor executor, ExecutorType ... types) {
        if (types == null || types.length == 0) {
            this.executor.addNormalExecutor(executor);
        } else {
            for (final ExecutorType type : types) {
                this.executor.addNormalExecutor(new CommandExecutor(){

                    @Override
                    public void run(CommandSender sender, Object[] args) throws WrapperCommandSyntaxException {
                        executor.executeWith(sender, args);
                    }

                    @Override
                    public ExecutorType getType() {
                        return type;
                    }
                });
            }
        }
        return (T)this;
    }

    public T executes(final ResultingCommandExecutor executor, ExecutorType ... types) {
        if (types == null || types.length == 0) {
            this.executor.addResultingExecutor(executor);
        } else {
            for (final ExecutorType type : types) {
                this.executor.addResultingExecutor(new ResultingCommandExecutor(){

                    @Override
                    public int run(CommandSender sender, Object[] args) throws WrapperCommandSyntaxException {
                        return executor.executeWith(sender, args);
                    }

                    @Override
                    public ExecutorType getType() {
                        return type;
                    }
                });
            }
        }
        return (T)this;
    }

    public T executesPlayer(PlayerCommandExecutor executor) {
        this.executor.addNormalExecutor(executor);
        return (T)this;
    }

    public T executesPlayer(PlayerResultingCommandExecutor executor) {
        this.executor.addResultingExecutor(executor);
        return (T)this;
    }

    public T executesEntity(EntityCommandExecutor executor) {
        this.executor.addNormalExecutor(executor);
        return (T)this;
    }

    public T executesEntity(EntityResultingCommandExecutor executor) {
        this.executor.addResultingExecutor(executor);
        return (T)this;
    }

    public T executesProxy(ProxyCommandExecutor executor) {
        this.executor.addNormalExecutor(executor);
        return (T)this;
    }

    public T executesProxy(ProxyResultingCommandExecutor executor) {
        this.executor.addResultingExecutor(executor);
        return (T)this;
    }

    public T executesCommandBlock(CommandBlockCommandExecutor executor) {
        this.executor.addNormalExecutor(executor);
        return (T)this;
    }

    public T executesCommandBlock(CommandBlockResultingCommandExecutor executor) {
        this.executor.addResultingExecutor(executor);
        return (T)this;
    }

    public T executesConsole(ConsoleCommandExecutor executor) {
        this.executor.addNormalExecutor(executor);
        return (T)this;
    }

    public T executesConsole(ConsoleResultingCommandExecutor executor) {
        this.executor.addResultingExecutor(executor);
        return (T)this;
    }

    public T executesNative(NativeCommandExecutor executor) {
        this.executor.addNormalExecutor(executor);
        return (T)this;
    }

    public T executesNative(NativeResultingCommandExecutor executor) {
        this.executor.addResultingExecutor(executor);
        return (T)this;
    }

    public CommandAPIExecutor<? extends CommandSender> getExecutor() {
        return this.executor;
    }

    public void setExecutor(CommandAPIExecutor<? extends CommandSender> executor) {
        this.executor = executor;
    }

    public T clearExecutors() {
        this.executor.setNormalExecutors(new ArrayList());
        this.executor.setResultingExecutors(new ArrayList());
        return (T)this;
    }
}

