/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.preprocessor;

import de.icongmbh.oss.maven.plugin.javassist.ClassTransformer;
import dev.jorel.commandapi.preprocessor.NMSMeta;
import java.util.Arrays;
import java.util.Properties;
import java.util.stream.Collectors;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import javassist.build.JavassistBuildException;

public class ProcessNMSMeta
extends ClassTransformer {
    public boolean shouldTransform(CtClass candidateClass) throws JavassistBuildException {
        try {
            return candidateClass.getAnnotation(NMSMeta.class) != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public void applyTransformations(CtClass classToTransform) throws JavassistBuildException {
        try {
            CtMethod toStringMethod = classToTransform.getDeclaredMethod("compatibleVersions");
            classToTransform.removeMethod(toStringMethod);
        }
        catch (NotFoundException toStringMethod) {
            // empty catch block
        }
        String versions = "";
        try {
            NMSMeta source = (NMSMeta)classToTransform.getAnnotation(NMSMeta.class);
            versions = Arrays.stream(source.compatibleWith()).map(x -> "\"" + x + "\"").collect(Collectors.joining(", "));
        }
        catch (ClassNotFoundException e) {
            throw new JavassistBuildException((Throwable)e);
        }
        try {
            CtMethod compatibleVersionsMethod = CtNewMethod.make((String)"public String[] compatibleVersions() {\n\treturn new String[] { %s };\n}\n".formatted(versions), (CtClass)classToTransform);
            classToTransform.addMethod(compatibleVersionsMethod);
        }
        catch (CannotCompileException e) {
            throw new JavassistBuildException((Throwable)e);
        }
    }

    public void configure(Properties properties) {
        if (properties == null) {
            return;
        }
    }
}

