/*
 * Decompiled with CFR 0.152.
 */
package dev.netcode.security.encryption;

import dev.netcode.security.encryption.Base58;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;

public class RSAEncrypter {
    public static KeyPair generateKeyPair(int size) {
        KeyPairGenerator keygen = null;
        try {
            keygen = KeyPairGenerator.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        keygen.initialize(size, new SecureRandom());
        return keygen.generateKeyPair();
    }

    public static String decrypt(byte[] cipher, PrivateKey privateKey) {
        byte[] dec = new byte[]{};
        try {
            Cipher c = Cipher.getInstance("RSA");
            c.init(2, privateKey);
            dec = c.doFinal(cipher);
        }
        catch (Exception e) {
            System.out.println("Error while decrypting: " + e.getMessage());
            e.printStackTrace();
        }
        return new String(dec, StandardCharsets.UTF_8);
    }

    public static byte[] encrypt(String message, PublicKey publicKey) {
        Cipher cipher = null;
        byte[] encrypted = null;
        try {
            cipher = Cipher.getInstance("RSA");
            cipher.init(1, publicKey);
        }
        catch (Exception e) {
            System.out.println("Error while encrypting: " + e.getMessage());
        }
        try {
            encrypted = cipher.doFinal(message.getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException | BadPaddingException | IllegalBlockSizeException e) {
            System.out.println("Error while encrypting: " + e.getMessage());
        }
        return encrypted;
    }

    public static String sign(PrivateKey privateKey, String input) {
        try {
            Signature privateSignature = Signature.getInstance("SHA256withRSA");
            privateSignature.initSign(privateKey);
            privateSignature.update(input.getBytes(StandardCharsets.UTF_8));
            byte[] signature = privateSignature.sign();
            return Base64.getEncoder().encodeToString(signature);
        }
        catch (Exception e) {
            System.err.println("Signing failed: " + e.getMessage());
            return null;
        }
    }

    public static boolean verifySignature(PublicKey publicKey, String data, String signature) {
        try {
            Signature publicSignature = Signature.getInstance("SHA256withRSA");
            publicSignature.initVerify(publicKey);
            publicSignature.update(data.getBytes(StandardCharsets.UTF_8));
            byte[] signatureBytes = Base64.getDecoder().decode(signature);
            return publicSignature.verify(signatureBytes);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static PublicKey generatePublicKeyFromString(byte[] key) {
        try {
            X509EncodedKeySpec X509publicKey = new X509EncodedKeySpec(key);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            return kf.generatePublic(X509publicKey);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static PrivateKey generatePrivateKeyFromString(byte[] key) {
        try {
            PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(key);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            return kf.generatePrivate(pkcs8EncodedKeySpec);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String keyToString(Key key) {
        if (key == null) {
            return "null";
        }
        return Base64.getEncoder().encodeToString(key.getEncoded());
    }

    public static String getFingerprint(PublicKey key) {
        try {
            X509EncodedKeySpec pubkeyspec = new X509EncodedKeySpec(key.getEncoded());
            return Base58.encode(MessageDigest.getInstance("SHA-1").digest(pubkeyspec.getEncoded()));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

