/*
 * Decompiled with CFR 0.152.
 */
package dev.netcode.security.identity;

import com.google.gson.Gson;
import dev.netcode.security.encryption.RSAEncrypter;
import dev.netcode.security.identity.Identity;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.json.JSONObject;

public class Signature {
    private String issuerName;
    private String issuerIdentityID;
    private String dataHash;
    private String signature;
    private String issueDate;

    public Signature(String issuerName, String issuerIdentityID, String dataHash) {
        this.issuerName = issuerName;
        this.issuerIdentityID = issuerIdentityID;
        this.dataHash = dataHash;
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        this.issueDate = sdf.format(new Date());
    }

    public boolean isValid(PublicKey publicKey, Identity identity) {
        if (!identity.getHash().contentEquals(this.dataHash)) {
            return false;
        }
        return RSAEncrypter.verifySignature(publicKey, this.getVerifiableDataString(), this.signature);
    }

    public void sign(PrivateKey privateKey) {
        this.signature = RSAEncrypter.sign(privateKey, this.getVerifiableDataString());
    }

    public String toString() {
        return new Gson().toJson((Object)this);
    }

    public String getVerifiableDataString() {
        JSONObject json = new JSONObject();
        json.put("issuerName", (Object)this.issuerName);
        json.put("issuerIdentityID", (Object)this.issuerIdentityID);
        json.put("dataHash", (Object)this.dataHash);
        json.put("issueDate", (Object)this.issueDate);
        return json.toString();
    }

    public String getIssuerName() {
        return this.issuerName;
    }

    public String getIssuerIdentityID() {
        return this.issuerIdentityID;
    }

    public String getDataHash() {
        return this.dataHash;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getIssueDate() {
        return this.issueDate;
    }
}

