/*
 * Decompiled with CFR 0.152.
 */
package dev.tinyflow.core.parser;

import com.agentsflex.core.chain.Chain;
import com.agentsflex.core.chain.ChainEdge;
import com.agentsflex.core.chain.ChainNode;
import com.agentsflex.core.chain.EdgeCondition;
import com.agentsflex.core.chain.JsCodeCondition;
import com.agentsflex.core.util.CollectionUtil;
import com.agentsflex.core.util.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import dev.tinyflow.core.Tinyflow;
import dev.tinyflow.core.parser.NodeParser;
import dev.tinyflow.core.parser.impl.CodeNodeParser;
import dev.tinyflow.core.parser.impl.ConfirmNodeParser;
import dev.tinyflow.core.parser.impl.EndNodeParser;
import dev.tinyflow.core.parser.impl.HttpNodeParser;
import dev.tinyflow.core.parser.impl.KnowledgeNodeParser;
import dev.tinyflow.core.parser.impl.LlmNodeParser;
import dev.tinyflow.core.parser.impl.LoopNodeParser;
import dev.tinyflow.core.parser.impl.SearchEngineNodeParser;
import dev.tinyflow.core.parser.impl.StartNodeParser;
import dev.tinyflow.core.parser.impl.TemplateNodeParser;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ChainParser {
    private Map<String, NodeParser> nodeParserMap = new HashMap<String, NodeParser>();

    public ChainParser() {
        this.initDefaultParsers();
    }

    private void initDefaultParsers() {
        this.nodeParserMap.put("startNode", new StartNodeParser());
        this.nodeParserMap.put("codeNode", new CodeNodeParser());
        this.nodeParserMap.put("confirmNode", new ConfirmNodeParser());
        this.nodeParserMap.put("httpNode", new HttpNodeParser());
        this.nodeParserMap.put("knowledgeNode", new KnowledgeNodeParser());
        this.nodeParserMap.put("loopNode", new LoopNodeParser());
        this.nodeParserMap.put("searchEngineNode", new SearchEngineNodeParser());
        this.nodeParserMap.put("templateNode", new TemplateNodeParser());
        this.nodeParserMap.put("endNode", new EndNodeParser());
        this.nodeParserMap.put("llmNode", new LlmNodeParser());
    }

    public Map<String, NodeParser> getNodeParserMap() {
        return this.nodeParserMap;
    }

    public void setNodeParserMap(Map<String, NodeParser> nodeParserMap) {
        this.nodeParserMap = nodeParserMap;
    }

    public void addNodeParser(String type, NodeParser nodeParser) {
        this.nodeParserMap.put(type, nodeParser);
    }

    public Chain parse(Tinyflow tinyflow) {
        String jsonString = tinyflow.getData();
        if (StringUtil.noText((String)jsonString)) {
            return null;
        }
        JSONObject root = JSON.parseObject((String)jsonString);
        JSONArray nodes = root.getJSONArray("nodes");
        JSONArray edges = root.getJSONArray("edges");
        return this.parse(tinyflow, nodes, edges, null);
    }

    public Chain parse(Tinyflow tinyflow, JSONArray nodes, JSONArray edges, JSONObject parentNode) {
        int i;
        if (CollectionUtil.noItems((Collection)nodes) || CollectionUtil.noItems((Collection)edges)) {
            return null;
        }
        Chain chain = new Chain();
        for (i = 0; i < nodes.size(); ++i) {
            ChainNode node;
            JSONObject nodeObject = nodes.getJSONObject(i);
            if ((parentNode != null || !StringUtil.noText((String)nodeObject.getString("parentId"))) && (parentNode == null || !parentNode.getString("id").equals(nodeObject.getString("parentId"))) || (node = this.parseNode(tinyflow, nodeObject)) == null) continue;
            chain.addNode(node);
        }
        for (i = 0; i < edges.size(); ++i) {
            ChainEdge edge;
            JSONObject edgeObject = edges.getJSONObject(i);
            JSONObject edgeData = edgeObject.getJSONObject("data");
            if ((parentNode != null || edgeData != null && !StringUtil.noText((String)edgeData.getString("parentNodeId"))) && (parentNode == null || edgeData == null || !edgeData.getString("parentNodeId").equals(parentNode.getString("id")) || parentNode.getString("id").equals(edgeObject.getString("source"))) || (edge = this.parseEdge(edgeObject)) == null) continue;
            chain.addEdge(edge);
        }
        return chain;
    }

    private ChainNode parseNode(Tinyflow tinyflow, JSONObject nodeObject) {
        String type = nodeObject.getString("type");
        if (StringUtil.noText((String)type)) {
            return null;
        }
        NodeParser nodeParser = this.nodeParserMap.get(type);
        return nodeParser == null ? null : nodeParser.parse(nodeObject, tinyflow);
    }

    private ChainEdge parseEdge(JSONObject edgeObject) {
        if (edgeObject == null) {
            return null;
        }
        ChainEdge edge = new ChainEdge();
        edge.setId(edgeObject.getString("id"));
        edge.setSource(edgeObject.getString("source"));
        edge.setTarget(edgeObject.getString("target"));
        JSONObject data = edgeObject.getJSONObject("data");
        if (data == null || data.isEmpty()) {
            return edge;
        }
        String conditionString = data.getString("condition");
        if (StringUtil.hasText((String)conditionString)) {
            edge.setCondition((EdgeCondition)new JsCodeCondition(conditionString.trim()));
        }
        return edge;
    }
}

