/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.datasource;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;

public final class DataSourceManager {
    private final Map<String, DataSource> dataSourcePerNameMap;

    public DataSourceManager(Map<String, DataSource> dataSourcePerNameMap) {
        this.dataSourcePerNameMap = dataSourcePerNameMap;
    }

    public Connection getConnection() throws SQLException {
        return this.dataSourcePerNameMap.get("default").getConnection();
    }

    public Connection getConnection(String dataSourceName) throws SQLException {
        DataSource dataSource = this.dataSourcePerNameMap.get(dataSourceName);
        return dataSource != null ? dataSource.getConnection() : null;
    }

    public DataSource getDataSource() {
        return this.dataSourcePerNameMap.get("default");
    }

    public DataSource getDataSource(String dataSourceName) {
        return this.dataSourcePerNameMap.get(dataSourceName);
    }
}

