/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.redis.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.google.inject.Singleton;
import com.typesafe.config.Config;
import dev.voidframework.core.utils.JsonUtils;
import dev.voidframework.redis.Redis;
import dev.voidframework.redis.exception.RedisException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisDataException;

@Singleton
public class DefaultRedis
implements Redis {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRedis.class);
    private final Provider<Jedis> jedisProvider;
    private final int defaultDatabase;

    @Inject
    public DefaultRedis(Provider<Jedis> jedisProvider, Config configuration) {
        this.jedisProvider = jedisProvider;
        this.defaultDatabase = configuration.getInt("voidframework.redis.defaultDatabase");
    }

    @Override
    public Jedis getConnection() {
        if (this.defaultDatabase == 0) {
            return (Jedis)this.jedisProvider.get();
        }
        return this.getConnection(this.defaultDatabase);
    }

    @Override
    public Jedis getConnection(int db) {
        Jedis jedis = (Jedis)this.jedisProvider.get();
        jedis.select(db >= 0 ? db : this.defaultDatabase);
        return jedis;
    }

    @Override
    public <T> T get(String key, TypeReference<T> typeReference) {
        return this.get(key, JsonUtils.objectMapper().readerFor(typeReference));
    }

    @Override
    public <T> T get(String key, Class<T> clazz) {
        return this.get(key, JsonUtils.objectMapper().readerFor(clazz));
    }

    @Override
    public <T> T get(String key, JavaType javaType) {
        return this.get(key, JsonUtils.objectMapper().readerFor(javaType));
    }

    @Override
    public <T> void set(String key, TypeReference<T> typeReference, T value) {
        this.set(key, typeReference, value, 0);
    }

    @Override
    public <T> void set(String key, TypeReference<T> typeReference, T value, int expiration) {
        this.set(key, JsonUtils.objectMapper().writerFor(typeReference), value, expiration);
    }

    @Override
    public <T> void set(String key, Class<T> clazz, T value) {
        this.set(key, clazz, value, 0);
    }

    @Override
    public <T> void set(String key, Class<T> clazz, T value, int expiration) {
        this.set(key, JsonUtils.objectMapper().writerFor(clazz), value, expiration);
    }

    @Override
    public void set(String key, JavaType javaType, Object value) {
        this.set(key, javaType, value, 0);
    }

    @Override
    public void set(String key, JavaType javaType, Object value, int expiration) {
        this.set(key, JsonUtils.objectMapper().writerFor(javaType), value, expiration);
    }

    @Override
    public <T> T getOrElse(String key, TypeReference<T> typeReference, Callable<T> block) {
        return this.getOrElse(key, typeReference, block, 0);
    }

    @Override
    public <T> T getOrElse(String key, TypeReference<T> typeReference, Callable<T> block, int expiration) {
        return this.getOrElse(key, JsonUtils.objectMapper().readerFor(typeReference), JsonUtils.objectMapper().writerFor(typeReference), block, expiration);
    }

    @Override
    public <T> T getOrElse(String key, Class<T> clazz, Callable<T> block) {
        return this.getOrElse(key, clazz, block, 0);
    }

    @Override
    public <T> T getOrElse(String key, Class<T> clazz, Callable<T> block, int expiration) {
        return this.getOrElse(key, JsonUtils.objectMapper().readerFor(clazz), JsonUtils.objectMapper().writerFor(clazz), block, expiration);
    }

    @Override
    public <T> T getOrElse(String key, JavaType javaType, Callable<T> block) {
        return this.getOrElse(key, javaType, block, 0);
    }

    @Override
    public <T> T getOrElse(String key, JavaType javaType, Callable<T> block, int expiration) {
        return this.getOrElse(key, JsonUtils.objectMapper().readerFor(javaType), JsonUtils.objectMapper().writerFor(javaType), block, expiration);
    }

    @Override
    public void remove(String key) {
        try (Jedis jedis = this.getConnection();){
            jedis.del(key);
        }
    }

    @Override
    public void remove(String ... keys) {
        try (Jedis jedis = this.getConnection();){
            for (String key : keys) {
                jedis.del(key);
            }
        }
    }

    @Override
    public boolean exists(String key) {
        boolean exists;
        try (Jedis jedis = this.getConnection();){
            exists = jedis.exists(key);
        }
        return exists;
    }

    @Override
    public <T> long addInList(String key, TypeReference<T> typeReference, Object value) {
        return this.addInList(key, JsonUtils.objectMapper().writerFor(typeReference), value);
    }

    @Override
    public <T> long addInList(String key, TypeReference<T> typeReference, Object value, int maxItem) {
        return this.addInList(key, JsonUtils.objectMapper().writerFor(typeReference), value, maxItem);
    }

    @Override
    public <T> long addInList(String key, Class<T> clazz, T value) {
        return this.addInList(key, JsonUtils.objectMapper().writerFor(clazz), value);
    }

    @Override
    public <T> long addInList(String key, Class<T> clazz, T value, int maxItem) {
        return this.addInList(key, JsonUtils.objectMapper().writerFor(clazz), value, maxItem);
    }

    @Override
    public long addInList(String key, JavaType javaType, Object value) {
        return this.addInList(key, JsonUtils.objectMapper().writerFor(javaType), value);
    }

    @Override
    public long addInList(String key, JavaType javaType, Object value, int maxItem) {
        return this.addInList(key, JsonUtils.objectMapper().writerFor(javaType), value, maxItem);
    }

    @Override
    public <T> List<T> getFromList(String key, TypeReference<T> typeReference) {
        return this.getFromList(key, typeReference, 0, -1);
    }

    @Override
    public <T> List<T> getFromList(String key, TypeReference<T> typeReference, int offset, int count) {
        return this.getFromList(key, JsonUtils.objectMapper().readerFor(typeReference), offset, count);
    }

    @Override
    public <T> List<T> getFromList(String key, Class<T> clazz) {
        return this.getFromList(key, clazz, 0, -1);
    }

    @Override
    public <T> List<T> getFromList(String key, Class<T> clazz, int offset, int count) {
        return this.getFromList(key, JsonUtils.objectMapper().readerFor(clazz), offset, count);
    }

    @Override
    public <T> List<T> getFromList(String key, JavaType javaType) {
        return this.getFromList(key, javaType, 0, -1);
    }

    @Override
    public <T> List<T> getFromList(String key, JavaType javaType, int offset, int count) {
        return this.getFromList(key, JsonUtils.objectMapper().readerFor(javaType), offset, count);
    }

    @Override
    public boolean tryLock(String key, int expiration) {
        long ret = 0L;
        try (Jedis jedis = this.getConnection();){
            ret = jedis.setnx(key, "1");
            if (ret == 1L) {
                jedis.expire(key, (long)expiration);
            }
        }
        catch (ProvisionException | JedisConnectionException ex) {
            LOGGER.error("Can't connect to Redis: {}", (Object)ex.getCause().getMessage());
        }
        catch (JedisDataException ex) {
            LOGGER.error("Can't connect to Redis: {}", (Object)ex.getMessage());
        }
        return ret == 1L;
    }

    @Override
    public long decrement(String key, int expiration) {
        long value;
        try (Jedis jedis = this.getConnection();){
            value = jedis.decr(key);
            if (expiration > 0 && value == -1L) {
                jedis.expire(key, (long)expiration);
            }
        }
        return value;
    }

    @Override
    public long decrement(String key) {
        return this.decrement(key, -1);
    }

    @Override
    public long increment(String key) {
        return this.increment(key, -1);
    }

    @Override
    public long increment(String key, int expiration) {
        long value;
        try (Jedis jedis = this.getConnection();){
            value = jedis.incr(key);
            if (expiration > 0 && value == 1L) {
                jedis.expire(key, (long)expiration);
            }
        }
        return value;
    }

    private long addInList(String key, ObjectWriter writer, Object value) {
        long l;
        block8: {
            String data = writer.writeValueAsString(value);
            Jedis jedis = this.getConnection();
            try {
                l = jedis.rpush(key, new String[]{data});
                if (jedis == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jedis != null) {
                        try {
                            jedis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    LOGGER.error("Can't add object in list", (Throwable)ex);
                    return -1L;
                }
            }
            jedis.close();
        }
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long addInList(String key, ObjectWriter writer, Object value, int maxItem) {
        try {
            String data = writer.writeValueAsString(value);
            try (Jedis jedis = this.getConnection();){
                long currentIdx = jedis.rpush(key, new String[]{data});
                if (currentIdx > (long)maxItem) {
                    jedis.ltrim(key, maxItem > 0 ? (long)(maxItem - 1) : (long)(maxItem + 1), -1L);
                    long l2 = maxItem;
                    return l2;
                }
                long l = currentIdx;
                return l;
            }
        }
        catch (IOException ex) {
            LOGGER.error("Can't add object in list", (Throwable)ex);
            return -1L;
        }
    }

    private <T> T get(String key, ObjectReader reader) {
        Object object = null;
        try {
            String rawData;
            try (Jedis jedis = this.getConnection();){
                rawData = jedis.get(key);
            }
            if (rawData != null) {
                object = reader.readValue(rawData.getBytes());
            }
        }
        catch (IOException ex) {
            LOGGER.error("Can't get object", (Throwable)ex);
        }
        return (T)object;
    }

    private <T> List<T> getFromList(String key, ObjectReader reader, int offset, int count) {
        ArrayList<Object> objects = new ArrayList<Object>();
        try {
            List rawData;
            try (Jedis jedis = this.getConnection();){
                int stop = offset + count;
                rawData = jedis.lrange(key, (long)offset, stop <= 0 ? (long)stop : (long)(stop - 1));
            }
            if (rawData != null) {
                for (String s : rawData) {
                    objects.add(reader.readValue(s));
                }
            }
        }
        catch (IOException | NullPointerException ex) {
            LOGGER.error("Can't get object from list", (Throwable)ex);
        }
        return objects;
    }

    private <T> T getOrElse(String key, ObjectReader reader, ObjectWriter writer, Callable<T> block, int expiration) {
        T data = this.get(key, reader);
        if (data == null) {
            try {
                data = block.call();
            }
            catch (Exception ex) {
                throw new RedisException.CallableFailure(ex);
            }
            this.set(key, writer, data, expiration);
        }
        return data;
    }

    private void set(String key, ObjectWriter writer, Object value, int expiration) {
        try {
            String data = writer.writeValueAsString(value);
            try (Jedis jedis = this.getConnection();){
                jedis.set(key, data);
                if (expiration > 0) {
                    jedis.expire(key, (long)expiration);
                }
            }
        }
        catch (IOException ex) {
            LOGGER.error("Can't set object", (Throwable)ex);
        }
    }
}

